program wind
  use Math_Const
  use trajectory
  use Derivation
  use gtool_history
  implicit none
  integer :: i, j
  integer, parameter :: nx=300, ny=300, tstep=20000
  real, dimension(nx,ny) :: u, v, rot_2d, pres, dummy
  real, dimension(tstep,1) :: tx, ty
  real :: x(nx), y(ny)
  real, parameter :: xmin=-pi, xmax=pi, ymin=-pi, ymax=pi, dt=0.1
  real :: dx, dy

  dx=(xmax-xmin)/(nx-1)
  dy=(ymax-ymin)/(ny-1)

  dummy=-10.0

  x=(/((xmin+dx*(i-1)),i=1,nx)/)
  y=(/((ymin+dy*(i-1)),i=1,ny)/)

  do j=1,ny
     do i=1,nx
        pres(i,j)=cos(x(i))+cos(y(j))
     end do
  end do

  do j=1,ny
     call grad_1d( x, pres(:,j), v(:,j) )
  end do
  do i=1,nx
     call grad_1d( y, pres(i,:), u(i,:) )
  end do

  v=-v

  call curl( x, y, u, v, rot_2d )

  call Stream_Line_2d( dt, tstep, 0.1, 0.1, x, y, u, v, tx(:,1), ty(:,1), 'RK4' )

!-- gtool writing (netcdf)

  call HistoryCreate( &                             ! ҥȥ꡼
    & file='wind.nc', title='derivation test program', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','y'/), dimsizes=(/nx,ny/),               &
    & longnames=(/'X-coordinate','Y-coordinate'/),       &
    & units=(/'m','m'/),                                 &
    & origin=0.0, interval=0.0 )

  call HistoryPut('x',x)                            ! ѿ
  call HistoryPut('y',y)                            ! ѿ

  call HistoryAddVariable( &                        ! ѿ
    & varname='pres', dims=(/'x','y'/), &
    & longname='pressure', units='1', xtype='float')

  call HistoryPut('pres',pres)                      ! ѿ

  call HistoryAddVariable( &                        ! ѿ
    & varname='rot', dims=(/'x','y'/), &
    & longname='rotation', units='1/s', xtype='float')

  call HistoryPut('rot',rot_2d)                      ! ѿ

  call HistoryAddVariable( &                        ! ѿ
    & varname='u', dims=(/'x','y'/), &
    & longname='X-wind', units='1', xtype='float')

  call HistoryPut('u',u)                      ! ѿ

  call HistoryAddVariable( &                        ! ѿ
    & varname='v', dims=(/'x','y'/), &
    & longname='Y-wind', units='1', xtype='float')

  call HistoryPut('v',v)                      ! ѿ
  call HistoryClose

end program
