require "numru/gfdnavi_data"

if ARGV.include?("-h") || ARGV.include?("--help")
  print "Usage: ruby #$0 [gfdnavi_webservice_portal_URL]\n"
  exit
end

url_prefix = ARGV.shift || "http://localhost:3000/data"
url_prefix = url_prefix.sub(/\/\z/, "")


def display(plot)
  IO.popen("display","w"){|io| io.print(plot.to_png)}
end



p "1: plot"
t = GfdnaviData.parse(url_prefix + "/samples/reanalysis/ncep/T.jan.nc/T")
display( t.plot("tone") )


p "2: plot with authorization"
t2 = GfdnaviData.parse(url_prefix + "/samples/reanalysis/ncep/T.jan_only_root.nc/T",
                     "root")
display( t2.plot("tone") )


p "3: analysis"
t_xm = t.analysis("mean", "lon")
p t_xm.to_gphys


p "4: plot of analized result"
display( t_xm.plot("tone") )


p "5: plot of multiple variables (one diagram)"
u = GfdnaviData.parse(url_prefix + "/samples/reanalysis/ncep/UV.jan.nc/U")
v = GfdnaviData.parse(url_prefix + "/samples/reanalysis/ncep/UV.jan.nc/V")
uv = GfdnaviData::Array[u,v]
display( uv.plot("vector") )


p "6: plot of multiple variables (multiple diagrams)"
uv.plot("tone").each do |gd|
  display( gd )
end


p "7: analysis for array which contains analyzed result"
t_eddy = GfdnaviData::Array[t, t_xm].analysis("subtraction")
p t_eddy.to_gphys
display( t_eddy.plot("tone") )
