require "numru/vizshot"

module NumRu
  class VizShotGfdnavi < VizShot

    def ==(other)
      return false unless @set == other.instance_variable_get("@set")
      self.instance_variable_get("@plots") == other.instance_variable_get("@plots")
    end

    def get_variables
      unless @variables
        @variables = Array.new
        @plots.each{|pl|
          pl[:variables].each{|path|
            if /^(temporary\:.+\.nc)\/(.+)$/ =~ path
              fname = $1
              vname = $2
              var = Variable.new
              var.file = fname
              var.path = File.join(fname,vname)
            else
              var = Variable.find(:first, :conditions => ["path=?",path],:user=>:all)
            end
            if var
              @variables.push var unless @variables.include?(var)
            else
              raise "[BUG] variable is invalid (#{path})"
            end
          }
        }
      end
      return @variables
    end

    def to_yaml_properties
      props = instance_variables.sort
      props.delete("@variables")
      return props
    end
    
    def get_plots(num=nil)
      if num
        @plots[num].dup
      else
        @plots.collect{|pl| pl.dup}
      end
    end

    def get_size
      [ @set[:admin][:iwidth], @set[:admin][:iheight] ]
    end

    def get_itr
      @set[:fig]['itr']
    end

    def get_viewport
      @set[:fig]['viewport'].join(',')
    end

    # redefined
    def cut_out_data(basename)
      newplots = Array.new
      data_paths = Array.new
      @plots.each_with_index{|pl, i|
        gphys, gphys2 = get_gphyses(pl.dup)
        method = pl[:method]
        script = pl.delete(:script)
        cut = pl.delete(:cut)
        slice = pl.delete(:slice)
        ndims = self.class.ndims(method)
        unless script.nil? && cut.nil? || slice.nil? && ndims == gphys.rank
          filename = basename + sprintf("_%03d",i) + '.nc'
          data_paths.push _output_data(gphys,filename,ndims)
          pl = pl.dup
          pl[:file] = filename
          pl[:var] = gphys.name
        end
        if gphys2
          cut2 = pl.delete(:cut2) || cut
          slice2 = pl.delete(:slice2) || slice
          unless script.nil? && cut2.nil? || slice2.nil? && ndims == gphys2.rank
            filename = basename + sprintf("_%03d_2",i) + '.nc'
            data_paths.push _output_data(gphys2,filename,ndims)
            pl = pl.dup
            pl[:file2] = filename
            pl[:var2] = gphys.name
          end
        end
      }
      return data_paths
    end

    protected

    # redefined
    def get_gphyses(arg)
      vars = arg.delete(:variables)
      unless Array === vars
        raise "variables is valid"
      end
      gphyses = Array.new
      slice = [arg.delete(:slice)]
      slice[1] = arg.delete(:slice2) || slice[0]
      cut = [arg.delete(:cut)]
      cut[1] = arg.delete(:cut2) || cut[0]
      vars.each_with_index{|path,i|
        if /^(temporary\:.+\.nc)\/(.+)$/ =~ path
          fname = $1
          vname = $2
          v = Variable.new
          v.file = fname
          v.path = File.join(fname,vname)
        else
          v = Variable.find(:first,:conditions=>["path=?",path],:user=>:all)
        end
        if v
          gphys = v.to_gphys
          if i==0 || i==1
            gphys = gphys[*(slice[i])] if slice[i]
            case cut[i]
            when Hash
              h = Hash.new
              gphys.axnames.each do |ax|
                if v = cut[i][ax]
                  h[ax] = v
                end
              end
              if h.any?
                gphys = gphys.cut(h)
              end
            when Array
              gphys = gphys.cut(*(cut[i]))
            end
          end
          gphyses.push gphys
        else
          raise "variable is invalid (#{path})"
        end
      }
      if src = arg.delete(:script)
        safe = $SAFE
        lambda {
#          $SAFE = 2
          eval src
        }.call
        $SAFE = safe
        gphyses1 = []
        gphyses.each_with_index{|gphys,i|
          gphys = gphys[*(slice[i])] if slice[i]
          case cut[i]
          when Hash
            h = Hash.new
            gphys.axnames.each do |ax|
              if v = cut[i][ax]
                h[ax] = v
              end
            end
            if h.any?
              gphys = gphys.cut(h)
            end
            gphyses1.push(gphys)
          when Array
            gphyses1.push(gphys.cut(*(cut[i])))
          else
            gphyses1.push(gphys)
          end
        }
        gphyses = gphyses1
      end
      gphyses = [gphyses] if GPhys === gphyses
      raise "wrong number of gphyses" if gphyses.length > 2
      return gphyses
    end

    def _output_data(gphys,filename,ndims)
      path = @@dumpdir + filename
      case ndims
      when 1
        gphys = gphys.first1D
      when 2
        gphys = gphys.first2D
      when 3
        gphys = gphys.first3D
      else
        raise "Ploting more-than-3D data is not supported"
      end
      file = NetCDF.create(path)
      GPhys::IO.write(file,gphys)
      file.close
      return path
    end

  end
end


#.*ENDOFLIB


if ActiveRecord::Base.connection.tables.include?("nodes")
DrawMethod.find(:all, :user=>:all).each{|dm|
  if dm.name && dm.script && dm.script!="NULL"
    hash = {
      :name => dm.name,
      :ndims => dm.ndims,
      :nvars => dm.nvars,
      :script => dm.script
    }
    hash[:ggraph] = dm.ggraph if dm.ggraph && dm.ggraph!="NULL"
    NumRu::VizShotGfdnavi.add_extensions(hash)
  end
}
end
