require "virtual_data"
require "narray"

require "numru/gfdnavi_data/local_cache"

require "numru/gfdnavi_data/array_local"
require "numru/gfdnavi_data/directory_local"
require "numru/gfdnavi_data/variable_local"
require "forwardable"

require "numru/gfdnavi_data/image_local"
require "numru/gfdnavi_data/knowledge_local"


module GfdnaviData
  module Local
    extend Forwardable


    @@local_cache_path = LocalCache.new
    @@local_cache_gphys = LocalCache.new
    @@alias = Hash.new

    # module functions

    def self.parse_path(path, user=nil)
      $descriptions = ::Array.new
      $i=1
      path_org = path
      if pa = @@alias[path]
        path = pa
      end
      if lc = @@local_cache_path.get([path,user])
        return lc
      end
      methods = ::Array.new
      if /\A(.+)\[([\d,])\]\z/ =~ path
        path = $1
        index = $2
        methods.unshift(["[]",index.split(",").collect{|c|c.to_i}])
      end
      while /\A(.+)\/?(find|analysis|plot|cut)+\(([^\)]+)\)(?:\[([\d,]+)\])?\z/ =~ path
        path = $1
        unless path == ("/" || "nil")
          path= path.chop 
        end
        index = $4
        method = $2
        opts = $3
        unless method == ("cut" || "find")
          opts = opts.split(";")
        end
        methods.unshift(["[]",index.split(",").collect{|c|c.to_i}]) if index
        methods.unshift [method,opts]
      end
      unless (path == "/") || path.nil?
        $descriptions.push("path="+ path)
      end 
      operation = nil
      if /\A(.*)\/(variables|images)\z/ =~ path
        path = $1
        operation =  $2
      end
      if /\A\/?\[(.+)\]\z/ =~ path # [...]
        path = $1
        ary = ::Array.new
        while /\A([^\(,]+(?:\([^\)]+\))?(?:\[[^\]]+\])?),(.+)/ =~ path
          path = $2
          ary.push GfdnaviData::Local.parse_path($1, user)
        end
        ary.push GfdnaviData::Local.parse_path(path, user)
        obj = VirtualData.new(ary)
      else
        obj = Node.find(:first, :conditions => ["path=?", path], :user => user)
        unless obj
          raise "path is invalid: #{path_org}, (#{path}), user=#{user.inspect}"
        end
      end
      gd = GfdnaviData::Local.create(user, obj)
      gd = gd.send(operation) if operation
      methods.each do |method, params|
        gd = gd.send(method, *params)
      end

=begin findƃG[ɂȂ
    path = gd.path
    unless path == path_org
      @@alias[path_org] = path unless @@alias.has_key?(path_org)
    end
      @@local_cache_path.push([path,user], gd)
=end
      return gd
    end

    def self.create(user, object)
      object = object.entity if Node === object
      hash = {"user"=>user, "object"=>object}
      case object
      when NodeEntityAbstract
        case object.node_type
        when Node::DIRECTORY
          obj = GfdnaviData::DirectoryLocal.new(hash)
        when Node::VARIABLE
          obj = GfdnaviData::VariableLocal.new(hash)
        when Node::IMAGE
          obj = GfdnaviData::ImageLocal.new(hash)
        when Node::KNOWLEDGE
          obj = GfdnaviData::KnowledgeLocal.new(hash)
        else
          raise "node type (#{object.node_type}) is invalid"
        end
      when VirtualData
        if object.array?
          obj = GfdnaviData::ArrayLocal.new(hash)
        else
          if object.type == "draw"
            obj = GfdnaviData::ImageLocal.new(hash)
          else
            obj = GfdnaviData::VariableLocal.new(hash)
          end
        end
      when ::Array, ActiveRecord::Associations::AssociationCollection
        obj = GfdnaviData::ArrayLocal.new(hash)
      else
        raise "type (#{object.class}) is invalid"
      end
    end


    # instance methods

    def init(hash)
      @user = User.find(:first, :conditions => ["login=?",user]) if String === @user
      unless @object
        @object = eval("::#{self.class.const_get(:OBJECT_CLASS).name}").new
        @new_data = true
      else
        @new_data = false
      end
    end

    def local?
      true
    end

    def remote?
      false
    end

    def get_object
      return @object
    end


    def to_hash(opts={})
      @object.to_hash(opts)
    end

    def to_rb(opts={})
      if @object.respond_to?(:to_rb)
        @object.to_rb(opts)
      else
        uri_prefix = opts[:uri_prefix]
        pa = @object.path
        pa = File.join(uri_prefix, "data", pa) if uri_prefix
        code = <<-EOF
require "numru/gfdnavi_data"

data = GfdnaviData.parse("#{pa}")
        EOF
      end
    end

    def user=(user)
      @user = user
    end

    %w(name path mtime owner other_mode rgroups wgroups size guest_owner file other_readable groups_readable title description).each do |me|
      def_delegator :@object, me+"="
      def_delegator :@object, me
    end

    def save_as(path, user=nil)
      unless GfdnaviData::Variable === self || GfdnaviData::Image === self || GfdnaviData::Knowledge === self
        raise "saving is not supported for array"
      end
      user ||= @user
      unless user
        raise "user must be specified"
      end
      @object.save_as(path, user)
    end

    def delete
      unless @user
        raise "user must be specified"
      end
      unless NodeEntityAbstract === @object && !(::Variable  === @object)
        raise "cannot delete this data: #{@object.class}"
      end
      if @user.super_user? || @object.owner == @user
        @object.destroy_all
      else
        raise "cannot delete: Permission denied"
      end
    end

    private
    def str_to_hash(hash, key, val)
      if /\A([^\[]+)\[(.+)\]\z/ =~ key
        key = $1
        keys = $2.split("][")
        keys.unshift key
        keys[0..-2].each do |k|
          hash = (hash[k] ||= Hash.new)
        end
        hash[keys[-1]] = val
      else
        hash[key] = val
      end
    end

    def str_to_options(str)
      opts = Hash.new
      while /\A([^=]+)=(.*)\z/ =~ str
        key = $1
        val = $2
        if /\A([^=]*),([^,=]+=.*)\z/ =~ val
          val = $1
          str = $2
        else
          str = ""
        end
        val = val.split(",") if /,/ =~ val
        str_to_hash(opts, key, val)
      end
      return opts
    end

    def get_attribute(name)
      #    get_object(path, @user)
      case name
      when /\A(?:variable|image)_nodes\z/
        @object.send(name, :user => @user)
      when "children"
        @object.send(name, false, :user => @user)
      else
        @object.send(name)
      end
    end

    def create(obj)
      GfdnaviData::Local.create(@user, obj)
    end

  end
end
