require "numru/gfdnavi_data/knowledge"

module GfdnaviData
  class KnowledgeRemote < GfdnaviData::Knowledge

    def to_knlge
      get_object("knlge")
    end

    def initialize(hash={})
      super(hash)
    end

    meths = ["category","creator","textbody","default_layout","horizontal_figures","figures_size_height_or_width", "figures_size_units","figures_size_number","comment_on","comment_number"]
    meths.collect!{|me| /\A(.+)_id\z/ =~ me ? $1 : me}
    #meths += ["get_contents", "relational_images", "relational_variables", "figures", "insert_figures=", "swap_figures", "comments", "make_new_comment", "save", "delete", "delete_figure"]
    meths += ["get_contents", "relational_images", "relational_variables", "figures", "insert_figures", "swap_figures", "comments", "make_new_comment", "save", "delete", "delete_figure"]

    meths.each do |name|
        eval <<-EOL, binding, __FILE__, __LINE__+1
        def #{name}=(arg)
          @representation[\"knlge\"] ||= {\"gfdnavi_knowledge\"=>Hash.new}
          @representation[\"knlge\"][\"gfdnavi_knowledge\"][\"#{name}\"] = arg
        end
        EOL

        eval <<-EOL, binding, __FILE__, __LINE__+1
        def #{name}
          unless @representation[\"knlge\"] && @representation[\"knlge\"][\"gfdnavi_knowledge\"]
            return nil
          end
          @representation[\"knlge\"][\"gfdnavi_knowledge\"][\"#{name}\"]
        end
        EOL
    end

    def update_save_data(hash)
      # 󂯎鑤 gl.key = value Ƃ`ɂȂ
      hash.update(@representation["knlge"]["gfdnavi_knowledge"])
    end
  end
end
