require "forwardable"

module GfdnaviData
  class KnowledgeLocal < GfdnaviData::Knowledge
    extend Forwardable

    OBJECT_CLASS = ::Knowledge

    # [J͈Ϗ
    #if Node.table_exists? && OBJECT_CLASS.table_exists?
    #meths = Node.column_names.dup + OBJECT_CLASS.column_names.dup
    if OBJECT_CLASS.table_exists?
      meths = OBJECT_CLASS.column_names.dup
      meths.delete("id")
      meths.collect!{|me| /\A(.+)_id\z/ =~ me ? $1 : me} # ...._id  _id 
      meths += ["get_contents", "relational_images", "relational_variables", "figures", "insert_figures", "swap_figures", "comments", "make_new_comment", "save", "delete", "delete_figure"]
      meths.each do |me|
        def_delegator :@object, me
        def_delegator :@object, me+"="
      end
    end

    def to_knlge
      # typẽ`FbNKv
      path = GFDNAVI_DATA_PATH + @object.path
      knowledge_file = File.open(path)
      knowledge_yml = knowledge_file.read
      knowledge_hash = YAML.load(knowledge_yml)
      return knowledge_hash
    end

    def initialize(hash={})
      # hash̒gȂAł
      super(hash) # ͕K{

      #  {} ȂVK쐬ƂɂA
      # pX͍̏sȂB
      unless hash=={}
        # === pX̏
        # * Local:
        #    * X[p[[ȔꍇAK΃pXƂ݂Ȃ(ǂɂłt@Cu)
        #    * ʃ[ȔꍇA"/usr/" + user_name + "/knowledge/" + @path 
        #      ̌`ɂȂĂȂΑ΃pXƂ݂Ȃ(/knowledge/ȉɂt@CuȂ)
        # * Remote: http:// ͂܂̂ŏȗ邱Ƃ͂Ȃ
        path = @object.path
        unless @user.super_user
          unless /^\/usr\/(.*)\/knowledge\/.*/ =~ path
            path = "/usr/" + user_name + "/knowledge/" + path
          end
        end
        @object.path = path
        @object.owner = @user
      end
    end
  end
end

