require "numru/gfdnavi_data/image"
require "fileutils"

module GfdnaviData
  class ImageLocal < GfdnaviData::Image

    OBJECT_CLASS = ::Image

    def to_png
      @object.to_png
    end

    def copy(path)
      img = Image.new
      img.org_path = save.org_path
      img.path = path
      img.name = File.basename(path)
      FileUtils.cp(fname, img.fname)
      img
    end

    def png=(png)
      unless @new_data
        raise "cannot change data"
      end
      unless String === png && /\A.PNG/ =~ png
        raise "not PNG data"
      end
      @png = png
    end

    def save
      if @new_data
        fname = Node.add_prefix(path)
        if File.exist?(fname)
          raise "file already exists: #{path}"
        end
        File.open(fname, "w") do |file|
          file.write @png
        end
      end
      @object.save
    end

  end
end
