require "net/http"
require "cgi"
require "yaml"

module GfdnaviRemote

  @@object_cache = Hash.new
  @@http_cache = Hash.new

  def parse_url(url, user=nil, passwd=nil)
    passwd = GfdnaviRemote.get_password(url, user) if user && passwd.nil?
    obj = self.get_object(url, user, passwd)
    case obj["type"]
    when /array/
      gr = GfdnaviRemoteArray.new(url, user, obj)
    else
      gr = GfdnaviRemoteData._new(url, user, obj)
    end
    gr.password = passwd if passwd
    return gr
  end
  module_function :parse_url

  def get_object(url, user, passwd, suffix="yml")
    cache_key = [url, user, suffix]
    if obj = @@object_cache[cache_key]
      return obj
    end
    /\A(https?:\/\/[^\/]+)(\/.*)\z/ =~ url
    path = $2
    u = URI.parse($1)
    protocol = u.scheme
    host = u.host
    port = u.port
    key_http = host+port.to_s
    http = @@http_cache[key_http] || (@@http_cache[key_http] = Net::HTTP.new(host,port) )
    path = CGI.escape(path).gsub(/\%2F/,"/")

    if /\.#{suffix}\z/ =~ path
      req = Net::HTTP::Get.new(path)
    else
      req = Net::HTTP::Get.new("#{path}.#{suffix}")
    end
    req.basic_auth(user, passwd) if user

    res = http.request(req)
    if res.code == "200"
      obj = res.body
      case suffix
      when "yml", "knlge"
        obj = YAML.load(obj)
        unless Hash === obj
          raise "object is invalid"
        end
      end
      @@object_cache[cache_key] = obj
      return obj
    else
      raise "http failed: code=#{res.code}"
#      raise "http failed: code=#{res.code}, body='#{res.body}'"
    end
  end
  module_function :get_object

  def get_password(url, user)
    if user
      unless /mswin(?!ce)|mingw|bccwin/ =~ RUBY_PLATFORM
        system("stty -echo > /dev/null 2>&1")
      end
      $stderr.print "\ninput password of #{user} for #{url} : "
      passwd = $stdin.gets.chomp!
      unless /mswin(?!ce)|mingw|bccwin/ =~ RUBY_PLATFORM
        system("stty echo > /dev/null 2>&1")
      end
      $stderr.print "\n"
      return passwd
    end
    return nil
  end
  module_function :get_password

  def initialize(url, user=nil, object= nil)
    @url = url
    @user = user
    @object = object
  end

  def local?
    false
  end

  def remote?
    true
  end

  def password=(passwd)
    @passwd = passwd
  end

  def get_object(suffix=nil)
    @passwd = GfdnaviRemote.get_password(@url, @user) if @user && !defined?(@passwd)
    if suffix && suffix != "yml"
      GfdnaviRemote::get_object(@url, @user, @passwd, suffix)
    else
      @object ||= GfdnaviRemote::get_object(@url, @user, @passwd)
    end
  end

  def url
    return @url if @url
    get_object unless @object
    return @object["url"]
  end

  def analysis(func, *args)
    get_object
    hash = @object["analysis"] 
    url = hash["url"]
    func_name = Regexp.escape(hash["function_name"])
    func_args = Regexp.escape(hash["function_arguments"])
    url = url.sub(/#{func_name}/, func)
    url = url.sub(/#{func_args}/, args.join(","))
    return create_data_array(url)
  end

  def plot(dm, opts = Hash.new)
    get_object
    hash = @object["plot"]
    url = hash["url"]
    dm_name = Regexp.escape(hash["draw_method_name"])
    dm_opts = Regexp.escape(hash["draw_method_options"])
    url = url.sub(/#{dm_name}/, dm)
    url = url.sub(/#{dm_opts}/, opts.to_a.collect{|k,v|"k=v"}.join(","))
    return create_data_array(url)
  end

  def slice(*index)
    get_object
    if hash = @object["slice"]
      url = hash["url"]
      ind = Regexp.escape(hash["index"])
      url = url.sub(/#{ind}/, index.join(","))
    else
      url = @object[*index]
    end
    if index.length == 1 && Integer === index[-1]
      return create_data(url)
    else
      return create_data_array(url)
    end
  end

  def cut(*args)
    get_object
    if hash = @object["cut"]
      url = hash["url"]
      arg = Regexp.escape(hash["arguments"])
      args = args[0].collect{|k,v| "#{k}=>#{v}"} if (args.length==1 && args[0].kind_of?(Hash))
      url = url.sub(/#{arg}/, args.join(","))
    else
      raise "BUG"
    end
    case self
    when GfdnaviRemoteArray
      return create_data_array(url)
    when GfdnaviRemoteData
      return create_data(url)
    end
  end

  def to_rb
    get_object("rb")
  end


  private
  def get_attribute(name)
    get_object
    @object[name]
  end

  def create(url)
    if Hash === url && /array/ =~ url["type"]
      create_data_array(url)
    else
      create_data(url)
    end
  end

  def create_data(obj)
    url = nil
    case obj
    when Hash
      obj = obj.dup
      url = obj.delete("url")
      obj = nil if obj.empty?
    when String
      url = obj
      obj = nil
    end
    gr = GfdnaviRemoteData._new(url, @user, obj)
    gr.password = @passwd if @passwd
    return gr
  end

  def create_data_array(obj)
    url = nil
    case obj
    when Hash
      obj = obj.dup
      url = obj.delete("url")
      obj = nil if obj.empty?
    when String
      url = obj
      obj = nil
    end
    gr = GfdnaviRemoteArray.new(url, @user, obj)
    gr.password = @passwd if @passwd
    return gr
  end


end
