require "numru/gfdnavi_data/gfdnavi_data"
require "numru/gfdnavi_data/gfdnavi_local"

class GfdnaviLocalData < GfdnaviData
  include GfdnaviLocal

  if Node.table_exists? && Knowledge.table_exists?
    meths = Node.column_names.dup + Knowledge.column_names.dup
    meths.delete("id")
    meths.delete("node_type")
    meths.delete("path")
    meths.collect!{|me| /\A(.+)_id\z/ =~ me ? $1 : me}
    meths += meths.collect{|me| "#{me}="}
    meths.each do |me|
      def_delegator :@object, me
    end
  end

  def initialize(obj, user)
    super 
    @object = @object.entity if Node === @object
  end

  def to_gphys
    # typẽ`FbNKv
    key = "#{path}.gphys"
    if obj = @@local_cache_gphys.get(key)
      return obj
    end
    t0 = Time.new
    obj = @object.to_gphys
    t1 = Time.new
    @@local_cache_gphys.push(key, obj, obj.size, t1-t0)
    return obj
  end

  def to_png
    # typẽ`FbNKv
    # ꂽ́uVirtualDatavΏۂɂĂB
    return @object.to_png
  end
  
  def to_nc
    # typẽ`FbNKv
    gphys = self.to_gphys
    gphys = [gphys] unless Array === gphys
    ofname = GFDNAVI_DATA_CACHE_PATH + "_001.nc"
    file = NumRu::NetCDF.create(ofname)
    begin
      gphys.each do |g|
        NumRu::GPhys::IO.write(file,g)
      end
    ensure
      file.close
    end
    return ofname
  end

  def to_knlge
    # typẽ`FbNKv
    path = GFDNAVI_DATA_PATH + @object.path
    knowledge_file = File.open(path)
    knowledge_yml = knowledge_file.read
    knowledge_hash = YAML.load(knowledge_yml)
    return knowledge_hash
  end

  def save_as(path, user)
    @object.save_as(path, user)
  end

end
