require "virtual_data"
require "thread"
require "narray"
require "rexml/document"


module GfdnaviLocal

  class LocalCache
    DEFAULT_MAX_SIZE = 100000
    DEFAULT_MAX_NUMBER = 10000

    def initialize(max_size = DEFAULT_MAX_SIZE, max_num = DEFAULT_MAX_NUMBER)
      @max_size = max_size
      @max_num = max_num
      @hash = Hash.new
      @size = NArray.int(max_num)
      @score = NArray.int(max_num)
      @keys = Array.new
      @mutex = Mutex.new
    end

    def push(key, val, size=0, ctime=0)
      if @hash[key]
        return nil
      else
        return nil if size > @max_size/2
        @mutex.synchronize {
          if (@hash.length < @max_num-1) && (@size.sum + size < @max_size)
            id = @hash.length
          else
            id = pruning(size)
          end
          @hash[key] = {:val => _dump(val), :id => id, :calc_time => ctime, :time => Time.now, :count => 1}
          @keys[id] = key
          update_score(id)
        }
        return self
      end
    end

    def get(key)
      ret = nil
      @mutex.synchronize {
        if h = @hash[key]
          h[:time] = Time.now
          h[:count] += 1
          update_score(h[:id])
          ret = _load(h[:val])
        end
      }
      return ret
    end

    private

    if Rails.configuration.cache_classes
      def _load(obj)
        return obj
      end
      def _dump(obj)
        return obj
      end
    else
      def _load(obj)
        Directory
        Variable
        Image
        DrawMethod
        DrawMethodOption
        Function
        FunctionArgument
        FunctionOutput
        return Marshal.load(obj)
      end
      def _dump(obj)
        return Marshal.dump(obj)
      end
    end

    def pruning(size)
      i = @score.eq(@score.min).where[0]
      @hash.delete(@keys[i])
      @keys[i] = nil
      @size[i] = 0
      @score[i] = 0
      if @size.sum + size > @max_size && @hash.length > 1
        pruning(size)
      end
      return i
    end

    def update_score(id)
      h = @hash[@keys[id]]
      @score[id] = h[:time].to_i + h[:count]*100 + h[:calc_time]
    end
  end # end of LocalCache class

  @@local_cache_path = LocalCache.new
  @@local_cache_gphys = LocalCache.new
  @@alias = Hash.new

  def parse_path(path, user=nil)
   $descriptions=Array.new
   $i=1
    path_org = path
    if pa = @@alias[path]
      path = pa
    end
    if lc = @@local_cache_path.get([path,user])
      return lc
    end
    methods = Array.new
    if /\A(.+)\[([\d,])\]\z/ =~ path
      path = $1
      index = $2
      methods.unshift(["[]",index.split(",").collect{|c|c.to_i}])
    end
    while /\A(.+)\/?(find|analysis|plot|cut)+\(([^\)]+)\)(?:\[([\d,]+)\])?\z/ =~ path
      
      path = $1
      unless path == ("/" || "nil")
       path= path.chop 
      end
      index = $4
      method = $2
      opts = $3
      unless method == ("cut" || "find")
        opts = opts.split(";")
      end

      methods.unshift(["[]",index.split(",").collect{|c|c.to_i}]) if index
      methods.unshift [method,opts]
    end
   
    unless path == ("/" || "nil")
      $descriptions.push("path="+ path)
    end 
    operation = nil
    if /\A(.*)\/(variables|images)\z/ =~ path
      path = $1
      operation =  $2
    end
    if /\A\/?\[(.+)\]\z/ =~ path
      path = $1
      ary = Array.new
      while /\A([^\(,]+(?:\([^\)]+\))?(?:\[[^\]]+\])?),(.+)/ =~ path
        path = $2
        ary.push GfdnaviLocal.parse_path($1, user)
      end
      ary.push GfdnaviLocal.parse_path(path, user)
      vd = VirtualData.new(ary)
      obj = GfdnaviLocalArray.new(vd, user)
    else
      node = Node.find(:first, :conditions => ["path=?", path], :user => user)
      unless node
        raise "path is invalid: #{path_org}"
      end
      obj = GfdnaviLocalData._new(node, user)
      
    end
    
    obj = obj.send(operation) if operation
    methods.each do |method, params|
      obj = obj.send(method, *params)
    end  

=begin findƃG[ɂȂ
    path = obj.path
    unless path == path_org
      @@alias[path_org] = path unless @@alias.has_key?(path_org)
    end
      @@local_cache_path.push([path,user], obj)
=end
   return obj
  end
  module_function :parse_path

  def initialize(obj, user)
    @object = obj
    @user = user && User.find(:first, :conditions => ["login=?",user])
  end

  def local?
    true
  end

  def remote?
    false
  end

  def get_object
    return @object
  end

  def find(query)
    @path =Array.new
    all=NodeQuery.new
    descriptions=Array.new
    descriptions=query.split(/&/)
    
    descriptions.each { |desc|

      if /\Apath=/ =~ desc
        $descriptions[0] = desc
      else
        $descriptions[$i] = desc
        $i=$i+1
      end
    }
    
    qstr = all.make_query($descriptions,user=nil)
    if qstr then
      rnodes=Node.find_by_sql(qstr)
      expres=ExplorerResult.new(-1)
      expres.put_results(rnodes)
      options=Hash.new
      results=all.generate_results(rnodes,expres,$options)
      result=results.to_xml
      result=REXML::Document.new(result)
      
      xpath="//node"
      result.elements.each(xpath) do |e|
        npath=e.elements["path"]
        npath=npath.text
        @path.push(npath)
      end
      obj2 = Array.new() 
    
        @path.each{ |path| 
          obj2 +=  Node.find(:all, :conditions => ["path=?",path], :user=>@user) 
        }
        obj = create_data_array(obj2)
        
      if ($options["show_kwfacets"]&&$options["show_spfacets"]) || ($options["show_kwfacets"]&&$options["show_kwvalues"])
        return result
      else
        return obj 
      end    
    else
      return 
    end
  end

  def analysis(func, args=[])
    case func
    when String
      func, user = func.split(",")
      user ||= "root"
      func = Function.find(:first, :conditions => ["path=?","/usr/#{user}/functions/#{func}"], :user => @user)
      unless func
        raise "function not found"
      end
    when Function
    else
      raise "function is invalid"
    end
    case @object
    when VirtualData
      obj = @object.dup
    else
      obj = VirtualData.new(@object)
    end
    args = args.split(",") if String === args
    obj = obj.analysis(func, *args)
    return create_data_array(obj)
  end

  def plot(draw_method, opts={})
 
    case draw_method
    when String
      dm, user = draw_method.split(",")
      user ||= "root"
      dm = DrawMethod.find(:first, :conditions => ["path=?","/usr/#{user}/draw_methods/#{dm}"], :user => @user)
      unless dm
        raise "draw_method not found"
      end
    when DrawMethod
      dm = draw_method
    else
      raise "draw_method is invalid"
    end
    case @object
    when VirtualData
      obj = @object.dup
    else
      obj = VirtualData.new(@object)
    end
    if String === opts
      opts = str_to_options(opts)
    end
    obj = obj.plot(dm, opts)
    return create_data_array(obj)
  end

  def slice(*index)
    return create(@object[*index])
  end

  def cut(*args)
    if args.length == 0
      raise "argument is invalid"
    elsif args.length == 1
      case args[0]
      when String
        hash = nil
        ary = nil
        args[0].split(",").each{|s|
          if /\A(.+)=>(.+)\z/ =~ s
            if ary
              raise "argument is invalid"
            else
              k = $1
              v = $2
              hash ||= Hash.new
              if /\A(.+)\.\.(.+)\z/ =~ v
                v = Float($1)..Float($2)
              else
                v = Float(v)
              end
              hash[k] = v
            end
          else
            if hash
              raise "argument is invalid"
            else
              ary ||= Array.new
              ary.push Float(s)
            end
          end
        }
        args = ary || [hash]
      when Hash
      else
        raise "argument is invalid"
      end
    end
    return create(@object.cut(*args))
  end

  def to_hash(opts={})
    @object.to_hash(opts)
  end

  def to_rb(opts={})
    if @object.respond_to?(:to_rb)
      @object.to_rb(opts)
    else
      uri_prefix = opts[:uri_prefix]
      pa = @object.path
      pa = File.join(uri_prefix, "data", pa) if uri_prefix
      code = <<-EOF
require "numru/gfdnavi_data"

data = GfdnaviData.parse("#{pa}")
      EOF
    end
  end

  private
  def str_to_hash(hash, key, val)
    if /\A([^\[]+)\[(.+)\]\z/ =~ key
      key = $1
      keys = $2.split("][")
      keys.unshift key
      keys[0..-2].each do |k|
        hash = (hash[k] ||= Hash.new)
      end
      hash[keys[-1]] = val
    else
      hash[key] = val
    end
  end

  def str_to_options(str)
    opts = Hash.new
    while /\A([^=]+)=(.*)\z/ =~ str
      key = $1
      val = $2
      if /\A([^=]*),([^,=]+=.*)\z/ =~ val
        val = $1
        str = $2
      else
        str = ""
      end
      val = val.split(",") if /,/ =~ val
      str_to_hash(opts, key, val)
    end
    return opts
  end

  def get_attribute(name)
#    get_object(path, @user)
    case name
    when /\A(?:variable|image)_nodes\z/
      @object.send(name, :user => @user)
    when "children"
      @object.send(name, false, :user => @user)
    else
      @object.send(name)
    end
  end

  def create(obj)
    if Array === obj || (VirtualData === obj && obj.array?)
      create_data_array(obj)
    else
      create_data(obj)
    end
  end

  def create_data(obj)
    GfdnaviLocalData._new(obj, @user)
  end

  def create_data_array(obj)
    GfdnaviLocalArray.new(obj, @user)
  end

end
