require "numru/gfdnavi_data/gfdnavi_abstract"
require "forwardable"

class GfdnaviData < GfdnaviAbstract
  extend Forwardable

  # Ϗ
  meths = ["get_contents", "relational_images", "relational_variables", "figures", "insert_figures=", "swap_figures", "comments", "make_new_comment", "save", "delete", "delete_figure"]
  meths.each do |me|
    def_delegator :@object, me
  end

  def self.parse(url, *args)
    if /\Ahttps?:\/\// =~ url
      GfdnaviRemote.parse_url(url, *args)
    else
      GfdnaviLocal.parse_path(url, *args)
    end
  end

  class << self
    alias :_new :new
    def new(url, user_name, type, hash=nil)
      unless @user = User.find(:first, :conditions => ["login=?", user_name])
        raise "Please input user name correctly.\n"
      end
      raise "type must not be null.\n" unless type

      @path = url
      @type = type
      case type
      when "knlge", "knowledge"
        @object = Knowledge.new

        # === path ̏
        # * Local:
        #    * X[p[[ȔꍇAK΃pXƂ݂Ȃ
        #    * ʃ[ȔꍇA"/usr/" + user_name + "/knowledge/" + @path 
        #      ̌`ɂȂĂȂΑ΃pXƂ݂Ȃ
        # * Remote: http:// ͂܂̂ŏȗ邱Ƃ͂Ȃ
        unless @user.super_user
          unless /^\/usr\/(.*)\/knowledge\/.*/ =~ @path
            @path = "/usr/" + user_name + "/knowledge/" + @path
          end
        end
        @object.path = @path
        @object.owner = @user

        # Hashǂ݂ @object ɑ
        if hash
          hash.each do |key, value|
            @object.send(key+"=", value)
          end
        end
      end

      if /\Ahttps?:\/\// =~ url
        GfdnaviRemoteData._new(url,user_name, @object)
      else
        GfdnaviLocalData._new(@object, user_name)
      end
    end
  end

  def parent
    attr = get_attribute("parent")
    create_data(attr)
  end

  def children
    attr = get_attribute("children")
    create_data_array(attr)
  end

  def variables
    attr = get_attribute("variable_nodes")
    create_data_array(attr)
  end

  def images
    attr = get_attribute("image_nodes")
    create_data_array(attr)
  end

  def +(other)
    other = other[0] if GfdnaviArray === other
    unless other.kind_of?(GfdnaviData)
      raise "others must be kind of GfdnaviData"
    end
    GfdnaviArray[self, other].analysis("addition")
  end
  def -(other)
    other = other[0] if GfdnaviArray === other
    unless other.kind_of?(GfdnaviData)
      raise "others must be kind of GfdnaviData"
    end
    GfdnaviArray[self, other].analysis("subtraction")
  end
  def *(other)
    other = other[0] if GfdnaviArray === other
    unless other.kind_of?(GfdnaviData)
      raise "others must be kind of GfdnaviData"
    end
    GfdnaviArray[self, other].analysis("multiplication")
  end
  def /(other)
    other = other[0] if GfdnaviArray === other
    unless other.kind_of?(GfdnaviData)
      raise "others must be kind of GfdnaviData"
    end
    GfdnaviArray[self, other].analysis("division")
  end

end
