require "numru/gfdnavi_data/gfdnavi_abstract"

class GfdnaviArray < GfdnaviAbstract

  def self.[](*objs)
    locate = nil
    objs_new = Array.new
    objs.each do |obj|
      case obj
      when GfdnaviArray
        obj.each do |o|
          objs_new.push o
        end
      when GfdnaviData
        objs_new.push obj
      else
        raise "#{obj.class} is not supported"
      end
      if obj.remote?
        loc = obj.url.sub(/#{Regexp.escape(obj.path)}/,"")
      elsif obj.local?
        loc = :local
      end
      if locate
        unless locate == loc
          raise "different hosts is not supported yet"
        end
      else
        locate = loc
      end
    end
    if locate == :local
      GfdnaviLocalArray.new(objs_new, nil)
    else
      url = "#{locate}/[#{objs_new.collect{|obj| obj.path}.join(",")}]"
      GfdnaviRemoteArray.new(url)
    end
  end

  def [](*index)
    slice(*index)
  end

  def length
    get_attribute("length")
  end

  def each
    length.times do |i|
      yield self[i]
    end
  end

  def each_with_index
    length.times do |i|
      yield self[i], i
    end
  end

  %w(gphys png).each do |name|
    eval <<-EOF
  def to_#{name}
    if length == 1
      self[0].to_#{name}
    else
      raise "This contains many elements"
    end
  end
    EOF
  end

end
