require "rexml/document"

module GfdnaviData
  class DirectoryLocal < GfdnaviData::Directory

    OBJECT_CLASS = ::Directory

    def find(query)
      @path =Array.new
      all=NodeQuery.new
      descriptions=Array.new
      descriptions=query.split(/&/)
      descriptions.each { |desc|
        if /\Apath=/ =~ desc
          $descriptions[0] = desc
        else
          $descriptions[$i] = desc
          $i=$i+1
        end
      }
      qstr = all.make_query($descriptions,user=nil)
      if qstr then
        rnodes=Node.find_by_sql(qstr)
        expres=ExplorerResult.new(-1)
        expres.put_results(rnodes)
        options=Hash.new
        results=all.generate_results(rnodes,expres,$options)
        result=results.to_xml
        result=REXML::Document.new(result)
        xpath="//node"
        result.elements.each(xpath) do |e|
          npath=e.elements["path"]
          npath=npath.text
          @path.push(npath)
        end
        obj2 = Array.new() 
        @path.each{ |path| 
          obj2 +=  Node.find(:all, :conditions => ["path=?",path], :user=>@user) 
        }
        obj = create_data_array(obj2)
        if ($options["show_kwfacets"]&&$options["show_spfacets"]) || ($options["show_kwfacets"]&&$options["show_kwvalues"])
          return result
        else
          return obj 
        end
      else
        return 
      end
    end

    def to_nc
      if ::Directory === @object && @object.downloadable?
        @object.fname
      else
        raise "object is invalid (#{@object.inspect})"
      end
    end

  end
end
