require "numru/gfdnavi_data/array"

module GfdnaviData
  class ArrayRemote < GfdnaviData::Array

    def slice(*index)
      get_object
      if hash = @object["slice"]
        url = hash["url"]
        ind = Regexp.escape(hash["index"])
        url = url.sub(/#{ind}/, index.join(","))
        obj = nil
      else
        obj = ::Array.new
        index.each do |i|
          o = @object[i]
          unless o
            raise "index (#{i}) is out of range"
          end
          obj.push o
        end
        url = nil
      end
      if index.length == 1 && Integer === index[-1]
        case @object["type"]
        when /array_(.+)/
          dtype = $1
        when "array"
          return GfdnaviData::Remote.parse_url(@object[index[0]]["url"], @user, @password)
        else
          raise "type (#{@object["type"]}) is invalid"
        end
      else
        dtype = "array"
      end
      GfdnaviData::Remote.create(url, @user, @password, obj, dtype)
    end

    def analysis(func, *args)
      get_object
      if hash = @object["analysis"]
        url = hash["url"]
        func_name = Regexp.escape(hash["function_name"])
        func_args = Regexp.escape(hash["function_arguments"])
        url = url.sub(/#{func_name}/, func)
        url = url.sub(/#{func_args}/, args.join(","))
        return GfdnaviData::Remote.create(url, @user, @password, nil, "array")
      else
        raise "anaysis is not supported for this array"
      end
    end

    def plot(dm, opts = Hash.new)
      get_object
      if hash = @object["plot"]
        url = hash["url"]
        dm_name = Regexp.escape(hash["draw_method_name"])
        dm_opts = Regexp.escape(hash["draw_method_options"])
        url = url.sub(/#{dm_name}/, dm)
        url = url.sub(/#{dm_opts}/, opts.to_a.collect{|k,v|"k=v"}.join(","))
        gd = create("url"=>url, "type"=>"array")
        return gd
      else
        raise "plot is not supported for this array"
      end
    end

  end
end
