require "numru/gfdnavi_data/array"

module GfdnaviData
  class ArrayLocal < GfdnaviData::Array

    def analysis(func, args=[])
      case func
      when String
        func, user = func.split(",")
        user ||= "root"
        func = Function.find(:first, :conditions => ["path=?","/usr/#{user}/functions/#{func}"], :user => @user)
        unless func
          raise "function not found"
        end
      when Function
      else
        raise "function is invalid"
      end
      case @object
      when VirtualData
        obj = @object.dup
      else
        obj = VirtualData.new(@object)
      end
      args = args.split(",") if String === args
      obj = obj.analysis(func, *args)
      return create(obj)
    end


    def plot(draw_method, opts={})
      case draw_method
      when String
        dm, user = draw_method.split(",")
        user ||= "root"
        dm = DrawMethod.find(:first, :conditions => ["path=?","/usr/#{user}/draw_methods/#{dm}"], :user => @user)
        unless dm
          raise "draw_method not found"
        end
      when DrawMethod
        dm = draw_method
      else
        raise "draw_method is invalid"
      end
      case @object
      when VirtualData
        obj = @object.dup
      else
        obj = VirtualData.new(@object)
      end
      if String === opts
        opts = str_to_options(opts)
      end
      obj = obj.plot(dm, opts)
      return create(obj)
    end

    def slice(*index)
      obj = @object[*index]
      return GfdnaviData::Base === obj ? obj : create(obj)
    end

  end
end
