require "numru/gfdnavi_data/base"

module GfdnaviData
  class Array < GfdnaviData::Base

    # singleton methods
    def self.[](*objs)
      locate = nil
      objs_new = ::Array.new
      objs.each do |obj|
        case obj
        when GfdnaviData::Array
          obj.each do |o|
            objs_new.push o
          end
        when GfdnaviData::Base
          objs_new.push obj
        else
          raise "#{obj.class} is not supported"
        end
        if obj.remote?
          loc = obj.url.sub(/#{Regexp.escape(obj.path)}/,"")
        elsif obj.local?
          loc = :local
        end
        if locate
          unless locate == loc
            raise "different hosts is not supported yet"
          end
        else
          locate = loc
        end
      end
      if locate == :local
        GfdnaviData::ArrayLocal.new("object" => objs_new)
      else
        url = "#{locate}/[#{objs_new.collect{|obj| obj.path}.join(",")}]"
        user = nil
        pw = nil
        objs_new.each do |obj|
          if u = obj.user
            if user
              raise("users are not the same") if user != obj.user
            else
              user = u
            end
            if pw2 = obj.password
              if pw
                raise("password is not the same") if pw != obj.password
              else
                pw = pw2
              end
            end
          end
        end
        gd = GfdnaviData::ArrayRemote.new("url"=>url, "user"=>user)
        gd.password = pw
        gd
      end
    end


    # instance methods
    def [](*index)
      slice(*index)
    end

    def length
      get_attribute("length")
    end

    def each
      length.times do |i|
        yield self[i]
      end
    end

    def each_with_index
      length.times do |i|
        yield self[i], i
      end
    end

    %w(gphys png).each do |name|
      eval <<-EOL, binding, __FILE__, __LINE__+1
      def to_#{name}
        if length == 1
          self[0].to_#{name}
        else
          raise "This contains many elements"
        end
      end
      EOL
    end

  end
end
