var gfdnaviUrlRoot;

function setCookie(name,value,expire){
    if (value) {
	document.cookie = name + '=' + escape(value) + ((expire==null)?'':('; expires='+expire.toGMTString()));
    } else {
	expire = new Date();
        var year = expire.getYear();
	year = year < 1900 ? year + 1900 : year;
	expire.setYear(year - 1);
	document.cookie = name + '=null; expires='+expire.toGMTString();
    }
}

function getCookie(name){
  var search = name + '=';
  if (document.cookie.length>0) {
    offset = document.cookie.indexOf(search);
    if (offset != -1){
      offset += search.length;
      end     = document.cookie.indexOf(';',offset);
      if(end == -1)
        end = document.cookie.length;
      return unescape(document.cookie.substring(offset,end));
    }
  }
  return null;
}

var PopupMenu = Class.create();
PopupMenu.prototype = {
  initialize: function(element, html, title) {
    this.html = html;
    this.title = title;
    if (element)
      Event.observe(element, "click", this.openMenu.bindAsEventListener(this));
  },
  openMenu: function(e) {
    var date = new Date();
    date = date.getTime();
    var id = 'popup_menu_'+date;
    var hid = 'popup_header_'+date;
    html = '<div id="'+id+'" class="popup_menu" style="display:none">';
    html += '<table cellspacing="0" cellpadding="0" border="1" bordercolor="black">'
    html += '<tr id="'+hid+'" border="0" style="background-color:#ddeeff;cursor:move;">';
    html += '<td>';
    html += '<div align="left" style="float:left">';
    if (this.title)
      html += this.title;
    html += '</div>';
    html += '<div align="right"><a href="#" onClick="Element.remove($(\''+id+'\'));"><img src="' + gfdnaviUrlRoot + '/images/x.gif" alt="X" class="delete"/></a></div>';
    html += '</td></tr>';
    html += '<tr><td>';
    html += '<div style="padding:5px">' + this.html  + '</div>';
    html += '</td></tr>';
    html += '</table>';
    html += '</div>';

    new Insertion.Bottom(Element.extend(document.body), html);
    var menu = $(id);
    new Draggable(menu,{handle: hid});
    if (e) {
      menu.style.left = Event.pointerX(e)-5 + 'px';
      menu.style.top = Event.pointerY(e)-5 + 'px';
    } else {
      menu.style.left = '10px';
      menu.style.top = '10px';
    }
    Element.show(menu);
    if (e)
      Event.stop(e);
    this.id = id;
  },
  closeMenu: function(e) {
    Element.remove(this.id);
  }
}

var BenchMark = Class.create();
BenchMark.prototype = {
  initialize: function (){},
  start: function() {
    this.start_date = new Date();
  },
  set: function(ary, body) {
    this.ids = ary;
    this.body = body;
  },
  load: function(id) {
    if (this.ids) {
      this.ids = this.ids.without(id);
      if (this.ids.length == 0)
        this.complete();
    }
  },
  complete: function() {
    if ( this.start_date ) {
      var html = this.body + '<br/><hr/>';
      var now = new Date();
      var msec = now.getTime() - this.start_date.getTime();
      html += parseInt(msec/60000)+':'+parseInt((msec%60000)/1000)+'.'+parseInt(msec%1000);
      var pop = new PopupMenu(null, html, 'Result of Benchmark');
      pop.openMenu();
      this.start_date = null;
      this.ids = null;
      this.body = null;
    }
  }
}
var benchMark = new BenchMark();


var normalBgColor = "transparent";
var highlightBgColor = "yellow";
function bgUnhighlight(obj) { obj.style.backgroundColor=normalBgColor; }
function bgHighlight(obj) { obj.style.backgroundColor=highlightBgColor; }

var html_hidden = " <font color='red'><b>(hidden currently)</b></font> ";
var temp_save_str = "";

function helpLinkHilit(id, self) {
  obj = $(id);
  if(obj && testElementVisible(obj)){
    obj.style.backgroundColor=highlightBgColor;
  } else {
    temp_save_str = self.innerHTML
    self.innerHTML = temp_save_str + html_hidden;
  }
}
function helpLinkUnhilit(id, self) {
  obj = $(id);
  if(obj && testElementVisible(obj)){
    obj.style.backgroundColor=normalBgColor;
  } else {
    self.innerHTML = temp_save_str;
  }
}

function testElementVisible(obj) {
  elm = obj;
  while (elm) {
    if (elm == document)
      return true;
    if (!Element.visible(elm))
      return false;
    elm = elm.parentNode;
  }
}

function bgFlash(id){
   new Effect.Highlight(id,
          {startcolor:"#ff0000",endcolor:"#ffffff",restorecolor:"#ffffff"});
}

//copy of knowledge.js
function showCommentListShort () {
    comment_list_short = document.getElementById("comment_list_short")
    comment_list_short_button = document.getElementById("comment_list_short_button")
    comment_list_hide = document.getElementById("comment_list_hide")
    comment_list_hide_button = document.getElementById("comment_list_hide_button")
    comment_list_all = document.getElementById("comment_list_all")
    comment_list_all_button = document.getElementById("comment_list_all_button")
    
    comment_list_short.style.display = "block";
    comment_list_short_button.style.borderStyle = "solid";
    comment_list_hide.style.display = "none";
    comment_list_hide_button.style.borderStyle = "none";
    comment_list_all.style.display = "none";
    comment_list_all_button.style.borderStyle = "none";
}

function showCommentListHide () {
    comment_list_short = document.getElementById("comment_list_short")
    comment_list_short_button = document.getElementById("comment_list_short_button")
    comment_list_hide = document.getElementById("comment_list_hide")
    comment_list_hide_button = document.getElementById("comment_list_hide_button")
    comment_list_all = document.getElementById("comment_list_all")
    comment_list_all_button = document.getElementById("comment_list_all_button")
    
    comment_list_short.style.display = "none";
    comment_list_short_button.style.borderStyle = "none";
    comment_list_hide.style.display = "block";
    comment_list_hide_button.style.borderStyle = "solid";
    comment_list_all.style.display = "none";
    comment_list_all_button.style.borderStyle = "none";
}

function showCommentListAll () {
    comment_list_short = document.getElementById("comment_list_short")
    comment_list_short_button = document.getElementById("comment_list_short_button")
    comment_list_hide = document.getElementById("comment_list_hide")
    comment_list_hide_button = document.getElementById("comment_list_hide_button")
    comment_list_all = document.getElementById("comment_list_all")
    comment_list_all_button = document.getElementById("comment_list_all_button")
      
    comment_list_short.style.display = "none";
    comment_list_short_button.style.borderStyle = "none";
    comment_list_hide.style.display = "none";
    comment_list_hide_button.style.borderStyle = "none";
    comment_list_all.style.display = "block";
    comment_list_all_button.style.borderStyle = "solid";
}
