# Extension of GPhys class for Gfdnavi

require "numru/gphys"
require "narray_gfdnavi"

module NumRu
  class GPhys

    # == Parameters @@read_size_limit_1 and @@read_size_limit_2
    # 
    # By default, both are nil, so no restriction is made
    # on the size of data to read in onto run-time memory.
    # To limit it, set these parameters explicitly by calling 
    # the class methods read_size_limit_1= and/or read_size_limit_2=.
    # 
    # It's up to the programmer how to use the
    # two limits. It's OK to use only one of them.
    # If both are set, it is recommended to set as
    # @@read_size_limit_2 > @@read_size_limit_1, because
    # of the order of judgements (the former is evaluated first).

    @@read_size_limit_1 = nil   # e.g., 2000000
    @@read_size_limit_2 = nil   # e.g., 10000000


    class Read_Size_Limit_2_Exceeded < StandardError
    end

    class Read_Size_Limit_1_Exceeded < StandardError
    end

    # class method definitions:
    class << self
      unless defined?(__new__)
        alias :__new__ :new

      # Limit the size of data to read in with GPhys#val.
      # This is implemented by defining singletone method
      # for the VArray that represent the main data array.
      # (Note that no restriction is made for coordinate varaibles,
      # which is practically unnecessary.)
        def new(grid,data)
          if VArrayDummy === data
            if NumRu::GPhysDummy == self
              return __new__(grid,data)
            else
              return GPhysDummy.new(grid,data)
            end
          end
          gp = __new__(grid,data)
          data = gp.data
          def data.val
            if @@read_size_limit_2 && length > @@read_size_limit_2
              raise Read_Size_Limit_2_Exceeded, "Exceeded the maximum array size to read in (length=#{@@read_size_limit_2}). Reduce the size by using the 'axes' window, and try again. (Or perhaps you may get around the error by programming with GPhys::each_along_dims.)"
            elsif @@read_size_limit_1 && length > @@read_size_limit_1
              raise Read_Size_Limit_1_Exceeded, "Exceeded the maximum array size to read in (length=#{@@read_size_limit_1}). Reduce the size by using the 'axes' window, and try again. (Or perhaps you may get around the error by programming with GPhys::each_along_dims.)"
	  end
            super
          end
          gp
        end
      end

      # Set internal parameter @@read_size_limit_1
      def read_size_limit_1= (limit)
	return if limit.nil?
	raise(ArgumentError,"Expect an integer") if !limit.is_a?(Integer)
	@@read_size_limit_1 = limit
      end

      # Set internal parameter @@read_size_limit_2 
      def read_size_limit_2= (limit)
	return if limit.nil?
	raise(ArgumentError,"Expect an integer") if !limit.is_a?(Integer)
	@@read_size_limit_2 = limit
      end

      def read_size_limit_1
	@@read_size_limit_1
      end

      def read_size_limit_2
	@@read_size_limit_2
      end

    end

    def size
      NArray.new(typecode,1).to_s.size * total
    end


# --  To be remove; marged to GPhys --
    def marshal_dump
      [@data.copy, @grid.copy]
    end

    def marshal_load(ary)
      @data = ary[0]
      @grid = ary[1]
    end
# ------------------

  end


  class GPhysDummy < GPhys
    def initialize(grid,data)
      @data = data
      @grid = grid
    end
    def rank
      @grid.rank
    end
    def shape
      @grid.shape
    end
  end
  class VArrayDummy < VArray
    def inspect
      "VArrayDummy"
    end
    def [](*arg)
      self
    end
    for f in Math_funcs + Binary_operators.collect{|name| name.sub(/^\./,"")} + Binary_operatorsL.collect{|name| name.sub(/^\./,"")} + Unary_operators + NArray_type1_methods + NArray_type2_methods + NArray_type3_methods
      eval <<-EOS
        def #{f}(*arg)
          self
        end
      EOS
    end
  end

end

