class Knowledge < NodeEntityAbstract
  has_many :knowledge_figures, :dependent => :destroy
  validates_length_of :textbody, :within => 0..100000
  validates_format_of :category, :with => /^[a-zA-Z0-9_]+$/, :message => "you can only use alphabets and numbers and underscore to Category."

  # m̕ۑA̕ϐĐ}}
  @@to_saved_figures = Array.new # GfdnaviDataIuWFNg̔z
  @@to_saved_figures_caption = Array.new

  # ̏擾AHashɂĕԂ
  def get_contents
    if (comment_on = self.comment_on && Knowledge.find(self.comment_on, :user => @user))
      comment_on_path = comment_on.path
    else
      comment_on_path = nil
    end
    knowledge_hash = {
      "title" => self.title,
      "creator" => self.creator,
      "category" => self.category,
      "textbody" => self.textbody,
      "description" => self.description,
      "default_layout" => self.default_layout,
      "horizontal_figures"=> self.horizontal_figures,
      "knowledge_figures" => [],
      "owner" => self.owner.login,
      "figures_size_height_or_width" => self.figures_size_height_or_width,
      "figures_size_units" => self.figures_size_units,
      "figures_size_number" => self.figures_size_number,
      "comment_on" => comment_on_path,
      "comment_number" => self.comment_number,
      # "rgroups" => groups,
      "other_mode" => self.other_mode,
      "other_readable" => self.other_readable,
      "groups_readable" => self.groups_readable,
      "name" => self.name
    }
    return knowledge_hash
  end

  # Ɋ܂܂}́AɂȂϐ擾
  def relational_variables(user_name)
    user = User.find_by_login(user_name)
    nrs = NodeRelation.find(:all, :conditions => ["referenced_by=?", self.node_id])
    nodes = Array.new
    nrs.each do |nr|
      nr_node = Node.find(nr.reference)
      nodes.push(nr.reference) if nr_node.node_type == 1
    end
    return nodes
  end

  # Ɋ܂܂}́A摜擾
  def relational_images(user_name)
    user = User.find_by_login(user_name)
    nrs = NodeRelation.find(:all, :conditions => ["referenced_by=?", self.node_id])
    nodes = Array.new
    nrs.each do |nr|
      nr_node = Node.find(nr.reference)
      nodes.push(nr.reference) if nr_node.node_type == 2
    end
    return nodes
  end

  # Ɋ܂܂}̏擾AHashArrayɂĕԂ
  def figures
    fig_infos = Array.new
    self.knowledge_figures.each do |kf|
      fig_infos.push({"image" => kf.image_path, "caption" => kf.caption})
    end
    return fig_infos # ͂̂܂ insert_figures= \bhɓnƂł
  end
  
  # ɐ}}
  def insert_figures=(args)
    # args  GfdnaviData, String (path), ͂̔z + [U
    unless !args || args.length < 1 || user_name = args[-1]
      raise "Please input user name correctly.\n"
    end
    user = User.find(:first, :conditions => ["login=?", user_name])

    figs = args[0..-2]
    figs.each do |i|
      @@to_saved_figures.push(i["image"])
      @@to_saved_figures_caption.push(i["caption"])
    end
  end

  # (ɕۑꂽɑ΂)}폜ĕۑ
  # 1Ԗڂ̊G1Ŏw肷(0ł͂Ȃ)
  def delete_figure(arg, user_name)
    unless self.node_id
      raise "This method can be used for saved documents.\n"
    else
      figs = self.figures
      unless figs.delete_at(arg-1) # arg͈͊OnilԂ
        raise "Inputed number is out of range.\n
             Please input number within the range from 1 to #{figs.length}.\n"
      end
      @@to_saved_figures = []
      @@to_saved_figures_caption = []
      figs.push(user_name)
      self.insert_figures = figs
      save("delete_figure")
    end
  end

  # (ɕۑꂽɑ΂)}̏Ԃւĕۑ
  # 1Ԗڂ̊G1Ŏw肷(0ł͂Ȃ)
  def swap_figures(first, second, user_name)
    unless self.node_id
      raise "This method can be used for saved documents.\n"
    else
      figs = self.figures
      if (first > figs.length) || (second > figs.length) || (first < 1) || (second < 1)
        raise "Inputed number is out of range.\n
             Please input number within the range from 1 to #{figs.length}.\n"
      end
      figs[first-1], figs[second-1] = figs[second-1], figs[first-1]
      @@to_saved_figures = []
      @@to_saved_figures_caption = []
      figs.push(user_name)
      self.insert_figures = figs
      save("swap")
    end
  end

  ### ̃\bhӖ͂H
  # {錠̂O[v Array Ŏ擾
  # def visible_to
  #   Group.find_by_bit_flag(self.rgroups).collect{|g| g.name}
  # end
  
  # Rg擾AArrayɂĕԂ
  def comments(user_name)
    user = User.find_by_login(user_name)
    comments = Knowledge.find(:all, :conditions=>["comment_on=?", self.node_id], :user => user)
  end

  ##### ̃XgāA̃RgIłɂɃRgłƂB ####

  # self ɑ΂ẴRg쐬B
  def make_new_comment(user_name)
    user = (login=user_name) && User.find_by_login(login)
    
    # ŃRgԍ߂
    knowledge, knowledge_figures, comments, image_paths, image_widths, image_heights, caption_widths, caption_heights = Knowledge.read_parameters_of_knowledge_document(self.path, user)
    new_comment_number = (comments.collect{|comment| comment.comment_number}.max || 0) + 1

    # ŃRg̃pX߂(΃pXŕ\)
    comment_path = knowledge.path[0..-7] + "_comment_" + new_comment_number.to_s + ".knlge"

    # Rg new  return 
    nc = GfdnaviData.new(comment_path, user.login, "knlge")
    nc.comment_on = self.node_id # RgɂȂKnowledgenode_idi[
    nc.comment_number = new_comment_number # Ԗڂ̃Rg
    nc.title = "Re[#{new_comment_number}]:"+ knowledge.title
    nc.category = "comment"
    return nc
  end

  # == m̍폜
  # * RgƂɂ͌̃pXƂēn
  # * destroyDB\bhƖÔłɂ
  def delete(user_name, parent_path=nil) 
    ActiveRecord::Base::transaction do
      user = User.find_by_login(user_name)
      
      # ꂽRg̏
      comments = Knowledge.find(:all, :conditions => ["comment_on=?", self.node_id])
      comments.each do |comment|
        File.delete(comment.fname)
        comment.destroy
      end
      
      # node_relations e[ů֌W̏
      node_relations = NodeRelation.find(:all, :conditions => ["name=? AND referenced_by=?", "based_on", self.node_id])
      node_relations.each do |nr|
        nr.destroy
      end
      
      # f[^x[X̏
      self.destroy
    end
    # fBXN .knlge t@C
    File.delete(self.fname)
  end

  # == m̕ۑ
  def save(type=nil)
    Knowledge.transaction do
      KnowledgeFigure.transaction do 
        #    ActiveRecord::Base::transaction do
        check_path(self.path) unless self.comment_on || !type || (type == "comment") || (type == "edit_save") || (type == "edit_save_as")

        # ɓpathꍇA}Ă (R}hCedit)
        # R}hCeditɂ́Asave ̈ edit ͎w肵Ȃ̂łőv
        unless type=="swap" || type=="delete_figure" || type=="edit_save"
          if (k = Knowledge.find(:first, :conditions => ["path=?", path]))
            k.figures.reverse.each do |fig|
              @@to_saved_figures.unshift(fig["image"])
              @@to_saved_figures_caption.unshift(fig["caption"])
            end
          end
        end

        # === knowledge  parent ߂
        FileUtils.makedirs(File.join(RAILS_ROOT, File.dirname(self.path)))
        parent = Directory.find(:first, :conditions => ["path=?",File.dirname(self.path)])
        unless parent
          parent = Directory.new
          parent.path = File.dirname(self.path)
          parent.name = File.basename(self.path)
          parent.owner = self.owner
          parent.save!
        end

        # === self.path gāA}ƂȂ摜̕ۑꏊ߂.
        fig_dir_path = File.join(parent.path, "." + File.basename(self.path, ".knlge"))

        # === knowledge_figures e[u̒gݒ
        knlge_figs = Array.new

        # ㏑ۑ̂ƂẢ摜͏AVɓ꒼
        # (摜̃Rs[͊ @@to_saved_figures_caption ɓĂ)
        if type == "edit_save"
          kfs = KnowledgeFigure.find(:all, :conditions => ["knowledge_id = ?", self.id])
          kas = keyword_attributes = KeywordAttribute.find(:all, :conditions => ["node_id = ?", self.node])
          kfs.each {|kf| kf.destroy }
          kas.each {|ka| ka.destroy }
        end

        @@to_saved_figures.each_with_index do |figure, i|
          #  ==== 摜path (image_path)擾
          if String === figure
            # * ̉摜pꍇ figure ̂܂ path
            image_path = figure
          else
            #if GfdnaviData === figure
            # * 摜𕶏Ƌɕۑꍇ, path Ō߂
            if i < 10
              prefix = "image00"
            elsif i < 100
              prefix = "image0"
            else
              prefix = "image"
            end
            image_path = File.join(fig_dir_path, prefix + i.to_s + ".png")

            # 쐬҂X[p[[UȂꍇA
            # save_as \bh(lib/virtual_data.rb) ɓn߂ /usr/[U 菜
            unless self.owner.super_user?
              /^\/usr\/(.+?)(\/.+)$/ =~ image_path
              for_db_path = $2
            else
              for_db_path = image_path
            end

            figure.save_as(for_db_path, self.owner)
          end

          knlge_fig = KnowledgeFigure.new
          knlge_fig.knowledge = self # knowledgese[u id Ŋ֘At
          knlge_fig.image_path = image_path
          knlge_fig.caption = @@to_saved_figures_caption[i]
          knlge_figs.push(knlge_fig)
        end

        # === knowledges e[u̒gݒ
        self.knowledge_figures = knlge_figs # knowledge_figurese[u id Ŋ֘At
        self.horizontal_figures = 1 unless horizontal_figures
        self.figures_size_height_or_width = 0 unless figures_size_height_or_width
        self.figures_size_units = 0 unless figures_size_units
        self.figures_size_number = 100 unless figures_size_number
        self.default_layout = 0 unless default_layout

        # === node e[u̒gݒ
        self.name = self.title
        self.other_readable = 1 # true
        self.groups_readable = -1
        self.parent = parent.node
        self.mtime = Time.new

        # === save Ƃ̌̏
        unless super # Knowledge.save
          # raise "failed to save a document (in knowledge.rb): #{self.errors.inspect}"
          return false
        else
          # ==== p[^
          @@to_saved_figures = []
          @@to_saved_figures_caption = []

          # ==== node_relations table
          # + knowledgenode_idKvȂ̂ŁA͒m̕ۑɍsKvB
          # + L^֌W
          #   * reference: lf[^, referenced_by: m, name: "based_on"
          #   * reference: 摜, referenced_by: m, name: "based_on"
          # + Save(㏑)̂Ƃ̂݁AO node_relations 
          if type == "edit_save"
            self.delete_node_relations
          end

          # + node_relations e[uɊ֌WL^
          # ++ KnowledgeFiguregāA摜ƕϐ̔zꂼ擾
          variables = Array.new
          images = Array.new
          self.knowledge_figures.each do |kf|
            if (img = Image.find(:first, :conditions=>["path=?", kf.image_path], :user => @user))
              images << img # 摜̔z
              if img.org_path # GfdnaviŐꂽ摜ȊOorg_pathȂ
                vd = GfdnaviData.parse(img.org_path).get_object
                variables += vd.virtual_nodes # 摜̊ɂȂϐ̔z
              end
            end
          end

          # ++ Ŏ擾ϐƉ摜 node_relationse[uɓ
          node_relations = Array.new
          (images + variables).uniq.each do |var|
            node_relation = NodeRelation.new
            node_relation.attributes = {:reference => var.node, :referenced_by => self.node, :name => "based_on"}
            node_relations << node_relation
            node_relation.save
          end

          # ==== .knlge t@C̍쐬
          # * knowledge e[u
          knowledge_hash = {"gfdnavi_knowledge" => self.get_contents}
          # * knowledge_figures e[u
          self.knowledge_figures.each do |kf|
            knowledge_hash["gfdnavi_knowledge"]["knowledge_figures"].push({"image_path" => kf.image_path, "caption"  => kf.caption})
          end
          # * node_relations e[u
          node_relation_hash = {"reference" => []}
          (images + variables).uniq.each do |var|
            node_relation_hash["reference"].push({"name" => "based_on", "path" => var.path})
          end
          knowledge_hash["gfdnavi_knowledge"].merge!(node_relation_hash) if node_relation_hash

          # + .knlget@Cւ̏
          File.open(self.fname,"w"){|file| file.print knowledge_hash.to_yaml}
          return true
        end # end of unless super
      end # end of KnowledgeFigure.transaction
    end # end of Knowledge.transaction
    #    end # end of transaction
  end

  # m̕ʖۑ
  def save_as(path, user_name)
    knowledge_hash = self.get_contents
    knowledge_hash.delete("knowledge_figures")
    knowledge_hash.delete("owner")
    new_gd = GfdnaviData.new(path, user_name, "knlge", knowledge_hash)
    new_gd.insert_figures = self.figures.push(user_name)
    new_gd.save("edit_save_as")
  end

  # == ͂ꂽpXǂ𒲂ׂ
  # // ȂǂׂB
  def check_path(path)
    case path
    when /\.\.\//
      raise '"../" cannot be used in path.'
    when /^\s*$/
      raise 'Path cannot be empty.'
    when /\/\s*$/, /\/\s*\//
      raise "Directory that doesn't have name is forbidden."
    when /\_comment\_/
      raise "\"_comment_\" is forbidden string."
    when /\.\d\.$/
      raise "\".number.knlge\" is forbidden string."
    end
  end

  # == self Ɋւ NodeRelation 
  def delete_node_relations
    old_node_relations = NodeRelation.find(:all, :conditions => ["name=? AND referenced_by=?", "based_on", self.node_id])
    old_node_relations.each do |relation|
      relation.destroy
    end
  end

  #<< class methods >>
  class << self
    def read_parameters_of_knowledge_document(path, user)
      knowledge = Knowledge.find(:first, :conditions => ["path=?", path], :user => user)
      comments = Knowledge.find(:all, :conditions => ["comment_on = ?" ,knowledge.node_id])
      knowledge_figures = KnowledgeFigure.find(:all, :conditions => ["knowledge_id=?", knowledge.id]) # not found -> return []

      # = G̃pXƑ傫
      #   * G̃pXnodese[upath擾
      #   * G̑傫imagese[uvizshot擾
      image_paths = Array.new
      image_widths = Array.new
      image_heights = Array.new
      caption_widths = Array.new
      caption_heights = Array.new
      knowledge_figures.each do |kf|
        unless (image = Node.find(:first, :conditions => ["path = ?", kf.image_path], :user => user))
          #raise "Figure is not found.\n"

          # vizshotƂnormalTCYKp
          image_widths << 250
          image_heights << 254
          caption_widths << 440
          caption_heights << 440
        else
          image_paths << image.path
=begin
          vizshot_yaml = image.org_path
          begin
            vizshot = YAML.load(vizshot_yaml)
            if (image_size = vizshot.get_size)
              image_widths << image_size[0]
              image_heights << image_size[1]
              caption_widths << (image_size[0] * 0.8).to_i
              caption_heights << (image_size[1] * 0.8).to_i
            else
              # vizshot畜łȂƂnormalTCYKp
              image_widths << 554
              image_heights << 554
              caption_widths << 440
              caption_heights << 440
            end
          rescue
=end
            # vizshotƂnormalTCYKp
            image_widths << 250
            image_heights << 254
            caption_widths << 440
            caption_heights << 440
#          end
        end
      end
      return knowledge, knowledge_figures, comments, image_paths, image_widths, image_heights, caption_widths, caption_heights
    end
    
    # OpenID̐ړɂ http://  https:// A܂ɂ / 菜
    def remove_scheme(user)
      if user.internal_user
        user.login
      else
        username_in_path = user.login
        case username_in_path
        when /^http:\/\/(.+)/, /^https:\/\/(.+)/
          username_in_path = $1
        end
        
        case username_in_path
        when /(.+)\/$/
          username_in_path = $1
        end
        return username_in_path
      end
    end
  end
end



