require "activerecord_gfdnavi"

class CrossResult
 attr_accessor :id, :keynames, :qsetid, :resulttree, :resultids, :nodes
  def initialize(qsetid)
    @keynames = Array.new
    @resulttree=PathNode.new
    @resulttree.path="/"
    @resultids = Array.new
    @nodes=Array.new
    @qsetid=qsetid
  end
  def reset_resulttree
    @resulttree=PathNode.new
    @resulttree.path="/"
  end 
  
  def put_results(nodes)
    @resultids.clear
    @nodes.clear
    @nodes = nodes
   
	@nodes.each{ |res|
      @resultids.push(res.id)      
    }
    @resultids.uniq!  
end
  
  def resultlist(p)
    reset_resulttree   
    dir=Array.new
    res=Array.new
    @nodes.each{ |n|
      if n.node_type==0 then
        dir.push n
      else
        res.push n
      end
    }
    
    res.each{ |r|
      flg=0
      dir.each{ |d|
        if r.path=~/#{d.path}/ then
            flg=1
            break
        end
      }
      if flg==0 then
        @resulttree.addpath(r)
      end
    }
    return res
  end
 
  def count
    return @resultids.size
  end
  
  def all_covered(slat,slon,elat,elon)
    tablename="nodes"
    
    if @qsetid!=0 then
      nodelist = "(select distinct ancestor as id from node_lineages where descendant in (#{@resultids.join(',')})) n"

if @resultids.length ==0 then
        return []          
      end        
    else
      nodelist = "nodes n"
    end

    qstr=<<-EOM
      select latitude_lb,longitude_lb, latitude_rt, longitude_rt, 
             count(*) as cnt
      from spatial_and_time_attributes s join #{nodelist} on n.id = s.node_id
      where s.latitude_lb<#{slat} and s.latitude_rt>#{elat}
        and s.longitude_lb<#{slon} and s.longitude_rt>#{elon}
        group by s.latitude_lb,s.longitude_lb, s.latitude_rt, s.longitude_rt
    EOM
    return Node.find_by_sql(qstr)
  end

  def partial_covered(slat,slon,elat,elon)
    if @qsetid!=0 then
      nodelist = "(select distinct ancestor as id from node_lineages where descendant in (#{@resultids.join(',')})) n"
      if @resultids.length ==0 then
        return []          
      end        
    else
      nodelist = "nodes n"
    end
    qstr=<<-EOM
      select latitude_lb,longitude_lb, latitude_rt, longitude_rt, 
             count(*) as cnt
      from spatial_and_time_attributes s join #{nodelist} on n.id = s.node_id
      where not (latitude_lb<#{slat} and latitude_rt>#{elat}
             and longitude_lb<#{slon} and longitude_rt>#{elon})
        and latitude_lb<>latitude_rt
        and longitude_lb<>longitude_rt
        group by latitude_lb,longitude_lb, latitude_rt, longitude_rt
    EOM
    return Node.find_by_sql(qstr)
  end

  def points(slat,slon,elat,elon)
    if @qsetid!=0 then
      nodelist = "(select distinct ancestor as id from node_lineages where descendant in (#{@resultids.join(',')})) n"
      if @resultids.length ==0 then
        return []          
      end        
    else
      nodelist = "nodes n"
    end
    qstr=<<-EOM
      select latitude_lb,longitude_lb, latitude_rt, longitude_rt, 
             count(*) as cnt
      from spatial_and_time_attributes s join #{nodelist} on n.id = s.node_id
      where latitude_lb=latitude_rt
        and longitude_lb=longitude_rt
      group by latitude_lb,longitude_lb
    EOM
    return Node.find_by_sql(qstr)
  end

  def get_keyname_list
    if @qsetid!=0 then
        nodelist = "(select distinct ancestor as id from node_lineages where descendant in (#{@resultids.join(',')})) n"
        if @resultids.length ==0 then
           return []          
        end        
    else
      nodelist = "nodes n"
    end
    igr_attrs=""
    i=0
    GFDNAVI_IGNORED_ATTRS.each{ |iga|
      if i==0 then
        igr_attrs="'#{iga}'"
      else
        igr_attrs="#{igr_attrs},'#{iga}'"
      end
      i=i+1
    }
    
    if GFDNAVI_IGNORED_ATTRS.size>0 then 
    qstr=<<-EOF
        select k.name as kname,count(distinct n.id) as cnt
        from  keyword_attributes k join #{nodelist} on k.node_id = n.id
        where not (k.name in (#{igr_attrs}))
        group by k.name
        order by cnt DESC
    EOF
    else
    qstr=<<-EOF
        select k.name as kname,count(distinct n.id) as cnt
        from  keyword_attributes k join #{nodelist} on k.node_id = n.id
        group by k.name
        order by cnt DESC
    EOF
    end
    keylist=KeywordAttribute.find_by_sql(qstr)
    return keylist
  end
  
 def get_path
  if @qsetid>0 then
    res=QueryHistory.find(:all,:conditions=>["queryset_id=? and querytype='path'",@qsetid])
    if res.size>0 then
      res[0].description=~/[P](.*)/
      return $1
    end
  end
  return "/"
 end
 
 def get_path_list
  if @qsetid>0 then
    QueryHistory.find(:all,:conditions=>["queryset_id=? and querytype='path'",@qsetid])  
    tables="(select v.* from nodes v, gfdnavi_querycache.queryset_#{@qsetid} c where v.id=c.vid)"
    path=get_path
  else
    tables="nodes"
    path="/"
  end
      sql1=<<-EOM
       select d2.path as dpath, count(distinct v.id) as cnt
       from nodes d1,nodes d2,#{tables} v
       where d1.path = ?
         and d2.parent_id = d1.id
         and v.path like #{concat("d2.path","'%'")}
       group by d2.path
       order by cnt DESC
     EOM
     pathlist = Node.find_by_sql([sql1,path])
   return pathlist
 end
 
 def get_keyvalue_list(keyname)
    if @qsetid!=0 then
      nodelist = "(select distinct ancestor as id from node_lineages where descendant in (#{@resultids.join(',')})) n"
	else
      nodelist = "nodes n"
    end
    qstr=<<-EOF
        select k.value as value, k.num_value as num_value, count(distinct n.id) as cnt
        from #{nodelist} join keyword_attributes k on k.node_id=n.id
        where k.name='#{keyname}'
        group by k.value
        order by cnt DESC
    EOF
    keylist=KeywordAttribute.find_by_sql(qstr)
    return keylist
 end
 
 def get_querysetids(session_id)
   res=Array.new
   qhistories=QueryHistory.find_by_sql(["select distinct queryset_id from query_histories where session_id=? order by queryset_id;",session_id])
   qhistories.each{ |qh|
     res.push qh.queryset_id
   }
   return res
 end
 
=begin
 def get_result_path_tree
   if id!= 0 then
     reslist=Node.find(:all,:select=>"path, count(*) as cnt",:joins=>"JOIN gfdnavi_querycache.cache_#{@id} ON gfdnavi_querycache.cache_#{@id}.vid=id", :group=>"path", :order=>"path")
   else
     reslist=Node.find(:all,:select=>"path, count(*) as cnt",:group=>"path",:order=>"path")
  end
  
  rid=0
  resultpath=PathNode.new
  reslist.each{ |res|
    if resultpath.path=="" then
      resultpath.path=res.path
      resultpath.id=rid
      resultpath.cnt=1
      rid=rid+1
    else
      patharray_res=res.path.split(/\//)
      patharray_node=resultpath.path.split(/\//)
      i=0
      while patharray_res[i]==patharray_node[i] do
        i=i+1
      end
      if patharray_
    end
  }    
  
 end
=end
end
