! anvarslices4.f90 - slice(AN_VARIABLE, VARYING_STRING * 4)
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

        ! ʊEʁBʏ͍Wϐ̒lɂwƂ݂ȂB
        ! w肪 "^" Ŏn܂ꍇ͊iqԍɂwƂ݂ȂB
        ! ȗ͍Wϐ̏ق肳B
        !  "^" łꍇɂ ^1 Ƃ݂ȂB
        ! ȗ͍Wϐ̑傫ق肳B
        !  "^" łꍇɂ ^-1 Ƃ݂ȂB
        ! Ԋuȗ͘A肳B

subroutine ANVarSliceS4(var, dimname, lower, upper, interval)
    use an_types, only: AN_VARIABLE
    use iso_varying_string
    use netcdf_f77
    use dc_error
    use dc_string, only: stod, stoi
    use an_generic, only: Slice, get_slice
    implicit none
    type(AN_VARIABLE), intent(inout):: var
    type(VARYING_STRING), intent(in):: dimname
    type(VARYING_STRING), intent(in):: lower
    type(VARYING_STRING), intent(in):: upper
    type(VARYING_STRING), intent(in):: interval
    integer:: id, idim, istart, icount, istride, stat, idx
    character(len = NF_MAX_NAME):: dimname_try
    real, pointer:: dimvalue(:)
continue
    if (dimname == "") return
    stat = 0
    idim = 0
    nullify(dimvalue)
    do, id = 1, size(var%dimids)
        stat = nf_inq_dimname(var%fileid, var%dimids(id), dimname_try)
        if (stat /= NF_NOERR) goto 999
        if (dimname == dimname_try) then 
            idim = id
            exit
        endif
    enddo
    if (idim == 0) then
        stat = GT_EBADDIMNAME;  goto 999
    endif
    ! ݂
    ! 
    ! --- ̏ ---
    !
    if (lower == "") then
        if (decreasing_axis()) then
            istart = -1
        else
            istart = 1
        endif
    else if (lower == "^") then
        istart = 1
    else if (index(lower, '^') == 1) then
        istart = stoi(extract(lower, 2))
    else
        istart = lookup_floor_index(stod(lower))
    endif
    call Slice(var, idim, start=istart)
    !
    ! --- Ԋȕ ---
    !
    if (interval == "" .or. interval == "^") then
        istride = 1
    else if (index(interval, "^") == 1) then
        istride = stoi(extract(interval, 2))
    else
        istride = ceiling(stod(interval) / average_stride())
    endif
    call Slice(var, idim, stride=istride)
    !
    ! --- [̏ ---
    !
    ! Slice ̐ݒlĊmF
    call get_slice(var, idim, start=istart, stride=istride)
    if (upper == "") then
        if (decreasing_axis()) then
            idx = 1
        else
            idx = HUGE(icount)
        endif
    else if (upper == "^") then
        icount = HUGE(icount)
        call Slice(var, idim, count=icount)
        goto 120
    else if (index(upper, "^") == 1) then
        icount = (stoi(extract(upper, 2)) - istart) / istride
        call Slice(var, idim, count=icount)
        goto 120
    else if (upper == lower) then
        icount = 1
        call Slice(var, idim, count=icount)
        goto 120
    else
        idx = lookup_ceiling_index(stod(upper))
    endif
    if (idx > istart) then
        icount = (idx - istart) / istride + 1
    else
        ! ϐlPȏꍇ
        icount = (istart - idx) / istride + 1
        istart = idx
    endif
    call Slice(var, idim, start=istart, count=icount)
    120 continue
    ! n
999 continue
    if (associated(dimvalue)) deallocate(dimvalue)
    call StoreError(stat, "ANVarSliceS4", cause_s=dimname)
    return
contains

    subroutine build_value_table
        use an_generic, only: Open, Get, Close
        type(AN_VARIABLE):: dimvar
        if (associated(dimvalue)) return
        call Open(dimvar, var, idim)
        call Get(dimvar, dimvalue)
        call Close(dimvar)
    end subroutine

    logical function decreasing_axis() result(result)
        call build_value_table
        result = dimvalue(1) > dimvalue(size(dimvalue))
    end function

    real function average_stride() result(result)
        call build_value_table
        result = (dimvalue(1) - dimvalue(size(dimvalue))) / max(1, size(dimvalue) - 1)
        if (abs(result) < epsilon(result)) result = epsilon(result)
    end function

    ! w肵l value ȉōő̒l^iqԍ
    ! ݂Ȃ΁Al̏Ȓ[̊iqԍ

    integer function lookup_floor_index(value) result(result)
        double precision:: value
    continue
        if (decreasing_axis()) then
            do, result = 1, size(dimvalue)
                if (dimvalue(result) <= value) return
            enddo
            result = size(dimvalue)
        else
            do, result = size(dimvalue), 1, -1
                if (dimvalue(result) <= value) return
            enddo
            result = 1
        endif
    end function

    ! w肵l value ȏōŏ̒l^iqԍ
    ! ݂Ȃ΁Al̑傫Ȓ[̊iqԍ

    integer function lookup_ceiling_index(value) result(result)
        double precision:: value
    continue
        if (decreasing_axis()) then
            do, result = size(dimvalue), 1, -1
                if (dimvalue(result) >= value) return
            enddo
            result = 1
        else
            do, result = 1, size(dimvalue)
                if (dimvalue(result) >= value) return
            enddo
            result = size(dimvalue)
        endif
    end function

end subroutine
