! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

recursive subroutine ANVarOpen(var, url, writable, err)
    use iso_varying_string, &
        only: VARYING_STRING, operator(/=), char, assignment(=), operator(==)
    use an_types
    use an_file
    use dc_url
    use dc_error
    use netcdf_f77
    use an_generic, only: Slice
    implicit none
    type(AN_VARIABLE), intent(inout):: var
    type(VARYING_STRING), intent(in):: url
    logical, intent(in), optional:: writable
    logical, intent(out), optional:: err
    type(VARYING_STRING):: filename, varname, iorange
    type(VARYING_STRING):: limitdim, iorange_remainder
    type(VARYING_STRING):: range(3)
    character(len = NF_MAX_NAME):: dimname
    integer:: stat, nvars, ndims, i, growable_dim_id
continue
    call UrlSplit(url, file=filename, var=varname, iorange=iorange)
    if (filename == "") filename = "gtool.nc"
    call ANFileOpen(var%fileid, filename, stat=stat, writable=writable)
    if (stat /= 0) goto 999
    !
    ! OϐTo
    !
    if (varname /= '') then
        var%varid = 0
        stat = nf_inq_varid(var%fileid, char(varname), var%varid)
        if (stat == NF_ENOTVAR) then
            var%varid = 0
            goto 100
        endif
    else
        ! OȂłΎϐłȂŏ̕ϐƂ肾
        stat = nf_inq_nvars(var%fileid, nvars)
        if (stat /= 0) goto 999
        var%varid = 1
        do, i = 1, nvars
            stat = nf_inq_varname(var%fileid, i, dimname)
            if (stat /= NF_NOERR) goto 999
            stat = nf_inq_dimid(var%fileid, dimname, var%dimid)
            if (stat == NF_NOERR) cycle
            if (stat /= NF_EBADDIM) goto 999
            var%varid = i
            stat = NF_NOERR
            exit
        enddo
    endif
    if (stat /= NF_NOERR) goto 999
    !
    ! id 𒲂ׂ
    !
100 continue
    stat = nf_inq_dimid(var%fileid, char(varname), var%dimid)
    if (stat /= NF_NOERR) then
        if (var%varid <= 0) goto 999
        var%dimid = 0
    endif
    !
    ! 𒲂ׂĕKvȔzt
    !
    if (var%varid > 0) then
        stat = nf_inq_varndims(var%fileid, var%varid, ndims)
        if (stat /= NF_NOERR) goto 999
        if (ndims == 0) then
            nullify(var%dimids, var%allcount)
        else
            allocate(var%dimids(ndims), var%allcount(ndims))
            stat = nf_inq_vardimid(var%fileid, var%varid, var%dimids)
            if (stat /= NF_NOERR) goto 999
        endif
    else
        ndims = 1
        allocate(var%dimids(1), var%allcount(1))
        var%dimids(1) = var%dimid
    endif
    ! Even if no unlimited dimension exists, stat will be NF_NOERR.
    stat = nf_inq_unlimdim(var%fileid, growable_dim_id)
    if (stat /= NF_NOERR) goto 999
    var%growable = .FALSE.
    do, i = 1, ndims
        stat = nf_inq_dimlen(var%fileid, var%dimids(i), var%allcount(i))
        if (stat /= NF_NOERR) goto 999
        if (var%dimids(i) == growable_dim_id) var%growable = .TRUE.
    enddo
    if (ndims == 0) then
        nullify(var%start, var%count, var%stride)
    else
        allocate(var%start(ndims), var%count(ndims), var%stride(ndims))
        var%start(:) = 1
        var%count(:) = var%allcount(:)
        var%stride(:) = 1
    endif
    var%attrid = 0
    !
    ! o͔͈͌菈
    !
    do
        call IORangeParse(iorange, limitdim, range, iorange_remainder)
        if (limitdim == "") exit
        call Slice(var, limitdim, &
            lower=range(1), upper=range(2), interval=range(3))
        iorange = iorange_remainder
    enddo
    !
    ! G[ (튮Ă)
    !
999 continue
    call StoreError(stat, 'ANVarOpen', err)
end subroutine
