! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine ANVarAttrCopy(to, attrname, from, err)
    use an_types, only: AN_VARIABLE
    use an_file, only: ANFileDefineMode
    use netcdf_f77
    use dc_url, only: GT_PLUS
    use dc_error
    implicit none
    type(AN_VARIABLE), intent(in):: to
    character(len = *), intent(in):: attrname
    type(AN_VARIABLE), intent(in):: from
    logical, intent(out), optional:: err
    integer:: stat
    stat = ANFileDefineMode(to%fileid)
    if (stat /= NF_NOERR) goto 999
    if (attrname(1:1) == GT_PLUS) then
        stat = nf_copy_att(from%fileid, NF_GLOBAL, attrname(2:), &
            & to%fileid, NF_GLOBAL)
    else
        stat = nf_copy_att(from%fileid, from%varid, attrname, &
            & to%fileid, to%varid)
    endif
999 continue
    call StoreError(stat, "ANVarAttrCopy", err)
end subroutine