! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.
! gtcopy - ϐʃc[

! 
!   gtcopy ϐ o͕ϐ
!   gtcopy ϐ ϐ ... o̓t@C

program gtcopy
    use gtool
    implicit none
    type(VARYING_STRING):: source
    type(VARYING_STRING):: dest, dest_f, dest_v
    integer:: i, argc
    argc = GtArgCount()
    if (argc < 2) then
        print *, "usage: gtcopy source ... dest"
        stop
    else if (argc == 2) then
        call GtArgGet(1, source)
        call GtArgGet(argc, dest)
        call do_copy(source, dest)
    else
        call GtArgGet(argc, dest)
        call UrlSplit(dest, file=dest_f)
        do, i = 1, argc - 1
            call GtArgGet(i, source)
            call UrlSplit(source, var=dest_v)
            dest = UrlMerge(file=dest_f, var=dest_v)
            call do_copy(source, dest)
        enddo
    endif
contains

    subroutine do_copy(source, dest)
        type(VARYING_STRING), intent(in):: source
        type(VARYING_STRING), intent(in):: dest
        type(GT_VARIABLE):: vSource
        type(GT_VARIABLE):: vDest
        call Open(vSource, url=source)
        call Create(vDest, url=dest, copyfrom=vSource, copyvalue=.TRUE.)
        call Close(vSource)
        call Close(vDest)
    end subroutine

end program
