! chars.f90 - character type support routines
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module dc_chars

    implicit none

contains

    function char_array_to_char(array) result(result)
	character, intent(in)::		array(:)
	character(len = size(array))::	result
    continue
	result = transfer(array, result)
    end function

    function char_6array_to_char(array) result(result)
	character, intent(in)::		array(:, :, :, :, :, :)
	character(len = size(array))::	result
    continue
	result = transfer(array, result)
    end function

    function char_to_char_6array(chars, d) result(result)
	character(len = *), intent(in)::	chars
	integer, intent(in)::			d(6)
	character:: result(d(1), d(2), d(3), d(4), d(5), d(6))
    continue
	result = reshape(transfer(chars, 'c', len(chars)), d)
    end function

end module
