program test
	use netcdf_file
	use netcdf_dimension
	type(NC_FILE)::		file
	type(NC_ERROR)::	err
	type(NC_DIMENSION)::	lat
	character(len = 64)::	buf
	logical::		ok

	err = create(file, 'foo.nc')
	call assert(err)
	print *, 'test file foo.nc created'
	lat = Dimension(file, 'lat', 128)
	if (.error. lat) call assert(NetcdfLastError())
	call NetcdfSaveError(NF_NOERR, '', '')
	ok = (Name(lat) == 'lat')
	call assert(NetcdfLastError())
	print *, 'name check for dimension name reading/writing:', ok
	err = close(file)

end program
