#! /usr/local/bin/ruby

require "gtrb08.rb"

module Data1

# ʪ̤
  Temperature = Var.new( Undef,  Undef,   "K",   "Temperature")
  Longitude   = Var.new(   0.0,  360.0,   "deg", "Longitude"  )
  Latitude    = Var.new( -90.0,   90.0,   "deg", "Latitude"   )
  Height      = Var.new(   0.0,  Undef,   "m",   "Height"     )
  Time        = Var.new(   0.0,  Undef,   "s",   "Time"       )

# ʻҤ
  Grid1 = Grid.new(20,7,5,Undef)

# ǥǡ
  Tmp1 = Datum.new                (Temperature,Grid1, "1111")
  Lon1 = RegularEdgeDatum.new     (Longitude,  Grid1, "1000")
  Lat1 = EdgeDatum.new            (Latitude,   Grid1, "0100")
  Hgt1 = EdgeDatum.new            (Height,     Grid1, "0010")
  Tim1 = IncrementalEdgeDatum.new (Time,       Grid1, "0001", 1000.0)

# 4̥顼̥ǡ
  Tmp  = ScalarSphericalData.new  (Tmp1,Lon1,Lat1,Hgt1,Tim1)

# ǡͤ
  def Hgt1.val(i,j,k,t)
     1.0e3*k
  end
  def Lat1.val(i,j,k,t)
    [-90.0, -60.0, -30.0, 0.0, 30.0, 60.0, 90.0][j]
  end
  def Tmp1.val(i,j,k,t)
     if(t<10) 
       Math.sin(Lon1.val(i,j,k,t)*Math::PI/180.0) \
      *Math.cos(Lat1.val(i,j,k,t)*Math::PI/180.0) \
      *Math.exp(-Hgt1.val(i,j,k,t)/3000.0) \
      *Math.exp(-Tim1.val(i,j,k,t)/3600.0)
    end
  end

end  # of module Data1

# ǥե
A = Data1::Tmp
A.draw = [M, Lon, Lat]
####################################################
#   end data definition
####################################################

# 󥿡
A.cont
A.cont(T,Z,{Lon=>1,Lat=>1})
B = A.ave(Z); B.cont
B.curv(Lon,{Lat=>1})

