#! /usr/local/bin/ruby

##############################################################
# gtrb7.rb                  99/06/28  numa@ees.hokudai.ac.jp
##############################################################
require "dcl"    # dcl library interface

M="m"; X="x"; Y="y"; Z="z"; T="t"; Lon="lon"; Lat="lat"; 
Undef=1.0e36

# ʪ̤
def SetVar(nm,mn=0.0,mx=1.0,uni='')
   eval "#{nm}=Var.new(#{mn},#{mx},'#{uni}','#{nm}')"
end

# ʪ̤
class Var
   def initialize(mn=0.0, mx=1.0, uni='', nm=''); 
       self.minmax=([mn,mx]);  @unit=uni; @name=nm; 
   end
   def minmax=(mx);  @min=mx[0];  @max=mx[1];   end
   def min;  @min    end	
   def max;  @max    end
   def name=(nm); @name=nm end
   def name; @name end
   def unit=(uni); @unit=uni end
   def unit; @unit end
end

# ʻҿ
class Grid
   def initialize(*n); set_ng(*n)               end
   def set_ng(*n)
       @ng=[]; @ng=n.dup
       @ngall=1; for i in @ng; @ngall*=i;  end            
   end
   def ng; @ng                                  end
   def ngall; @ngall                            end
   def ndim; @ng.length                         end
end

# ǥǡ
class Datum
   def initialize(va,gr,d=NIL,ed=NIL) 
       @var=va; @grd=gr; @dim=d; 
       if(!@dim) then @dim="1"*@grd.ndim end
       if(ed) then  @eidx=edgeIndex(@dim)
       else         @eidx=NIL           
       end
   end
   def edgeIndex(dim)
       y=0; 
       for i in 0..dim.length-1
         z=dim[i,1].to_i; y+=z; x=i if(z>0)
       end
       if (y == 1) then x; else NIL; end
   end
   def var; @var                                  end
   def grd; @grd                                  end
   def dim; @dim                                  end
   def eidx; @eidx                                end
   def vmn(*i);   val(*i)-del(*i)/2.0             end
   def vmx(*i);   val(*i)+del(*i)/2.0             end
   def del(*i);  (@var.max-@var.min)/@grd.ngall   end
   def proto=(p); @proto=p                        end
   def proto;     @proto                          end
   def ope=(p);   @ope=p                          end
   def ope;       @ope                            end
end

# ʻդȤʤǥǡ
class EdgeDatum < Datum
   def initialize(va,gr,d="0") 
       super(va,gr,d,TRUE)
       if (!@eidx) then raise "EdgeDatum: not edge Index" end
   end
   def del(*i)
     im=i.dup; ip=i.dup; 
     im[@eidx]=max(im[@eidx]-1,0)
     ip[@eidx]=min(ip[@eidx]+1,@grd.ng[@eidx])
     abs(val(*ip)-val(*im))/2.0
   end
end

# ʻդȤʤǥǡ: §ʻ
class RegularEdgeDatum < EdgeDatum
   def val(*i)
     @var.min + ((@var.max-@var.min)*i[@eidx])/@grd.ng[@eidx]         
   end
   def del(*i)
     (@var.max-@var.min)/@grd.ng[@eidx]         
   end
end

# ʻդȤʤǥǡ: §ʻ(ʬ)
class IncrementalEdgeDatum < EdgeDatum
   def initialize(va,gr,d="0",i=1.0) 
       super(va,gr,d);  @inc=i
   end
   def val(*i)
     @var.min + @inc*i[@eidx]
   end
   def del(*i)
     @inc
   end
   def inc=(i); @inc=i end
   def inc; @inc end
end

# ǡ = ǥǡνޤ 
class ClassData
   def initialize(*dat)
      @datas = []; @datas=dat.dup
   end	
   def index(d)
      for i in 0..@datas.length-1; return i if (d == @datas[i]); end
   end
   def setindex(i,d)
      @datas[i]=d
   end
end

class Gindex
   def initialize(xs)
      @x=xs; 
      if (!(@ix=@x.eidx)) then raise "#{xs} is not edge" end      
      @nx=@x.grd.ng[@ix]
   end
   def nx=(n); @nx=n end
   def x;  @x        end
   def ix; @ix       end
   def nx; @nx       end
end

# 顼̥ǡ 
class ScalarData < ClassData
  def initialize(*dat)
      super(*dat)
      @xdraw=NIL; @ydraw=NIL; @sdraw={}
  end

  def slice(ss,ds)
     sl=[0]*evalx(ds).grd.ndim
     ss.each_key {|k| 
	kk = evalx(k)
        if (!(ik=kk.eidx)) then raise k + " is not edge" end
        sl[ik]=ss[k]
     }
     return sl
  end

  def get_x(ds, xi, slice)
    dd=[]; d=evalx(ds)
    idx=slice.dup
    for i in 0..xi.nx-1
      idx[xi.ix]=i; dd[i]=d.val(*idx)
      if(!dd[i]) then dd.pop; xi.nx=i; break; end
    end
    return dd
  end     

  def get_xy(ds, xi, yi, slice)
    dd=[]; d=evalx(ds)
    idx=slice.dup
    for i in 0..xi.nx-1
      idx[xi.ix]=i; if(!d.val(*idx)) then xi.nx=i; break; end
    end
    idx=slice.dup
    for j in 0..yi.nx-1
      idx[yi.ix]=j; if(!d.val(*idx)) then yi.nx=j; break; end
    end
    idx=slice.dup; ij=0
    for j in 0..yi.nx-1
      for i in 0..xi.nx-1
        idx[xi.ix]=i; idx[yi.ix]=j; dd[ij]=d.val(*idx); ij+=1
      end
    end
    return dd
  end     

  def rmaxmin(xi,xx)
    xmin=xi.x.var.min; xmax=xi.x.var.max
    if(xmin == Undef) then xmin=min(xx[0],xx[xi.nx-1]) end
    if(xmax == Undef) then xmax=max(xx[0],xx[xi.nx-1]) end
    return [xmin,xmax]
  end

  def cont(xs=@xdraw, ys=@ydraw, ss=@sdraw, ms=@main)
    xi = Gindex.new(evalx(xs))
    yi = Gindex.new(evalx(ys))
    m  = evalx(ms)
    sl = slice(ss,ms)

    mm = get_xy(ms,xi,yi,sl)
    xx = get_x(xs,xi,sl)
    yy = get_x(ys,yi,sl)
    xmin,xmax = rmaxmin(xi,xx)
    ymin,ymax = rmaxmin(yi,yy)

    Dcl.gropn(1)
    Dcl.grfrm()
    Dcl.grswnd(xmin, xmax, ymin, ymax)
    Dcl.grsvpt(0.2, 0.8, 0.2, 0.8)
    Dcl.grstrn(1)
    Dcl.grstrf()
    Dcl.usdaxs()
    Dcl.uxmttl('T',m.var.name,   0.0)
    Dcl.uxsttl('B',xi.x.var.name,0.0)
    Dcl.uysttl('L',yi.x.var.name,0.0)
    Dcl.uwsgxa(xx,xi.nx)
    Dcl.uwsgya(yy,yi.nx)
    Dcl.udcntr(mm,xi.nx,xi.nx,yi.nx)
    Dcl.grcls()
  end

  def curv(xs=@xdraw, ss=@sdraw, ms=@main)
    xi = Gindex.new(evalx(xs))
    m  = evalx(ms)
    sl = slice(ss,ms)

    xx = get_x(xs,xi,sl)
    mm = get_x(ms,xi,sl)
    xmin,xmax = rmaxmin(xi,xx)

    Dcl.gropn(1)
    Dcl.grfrm()
    Dcl.glrset('RUNDEF',Undef)
    Dcl.grswnd(xmin, xmax, Undef, Undef)
    Dcl.grsvpt(0.2, 0.8, 0.2, 0.8)
    Dcl.usinit()
    Dcl.usgrph(xi.nx,xx,mm)
    Dcl.uxsttl('B',xi.x.var.name,0.0)
    Dcl.uysttl('L',m.var.name,   0.0)
    Dcl.grcls()
  end

  def ave(xs, ms=@main)
    xi  = Gindex.new(evalx(xs))
    m   = evalx(ms); ind=index(m)
    dim = m.dim.dup; dim[xi.ix] = "0"
    dn  = Datum.new(m.var,m.grd,dim);
    dn.proto=m; dn.ope=xi
    def dn.val(*idx)
  	sv=0.0; sw=0.0
        begin
          for i in 0..ope.nx
             idx[ope.ix]=i; w=ope.x.del(*idx)
             sv+=proto.val(*idx)*w;  sw+=w
  	  end
        rescue
        end
        if(sw>0) then sv/sw; else NIL; end
    end
    sd=dup; sd.main=dn; sd.setindex(ind,dn); 
    return sd
  end

  def main;   @main  end
  def xdraw;  @xdraw end
  def ydraw;  @ydraw end
  def sdraw;  @sdraw end
  def main=(m);  @main=m  end
  def xdraw=(x); @xdraw=x end
  def ydraw=(y); @ydraw=y end
  def sdraw=(s); @sdraw=s end
  def draw=(d)
     @main=d[0]; @xdraw=d[1]; @ydraw=d[2]
  end

end

# 4顼 A(x,y,z,t)
class Scalar4DData < ScalarData
   def initialize(*d)
       super(*d); self.draw=(d);
   end
   def m;   @datas[0]  end
   def x;   @datas[1]  end
   def y;   @datas[2]  end
   def z;   @datas[3]  end
   def t;   @datas[4]  end
end

# 4̥顼 A(,,z,t)
class ScalarSphericalData < Scalar4DData
   def lon;  @datas[1]  end
   def lat;  @datas[2]  end
end

# utility ؿ
def max(i,j); if(i>j) then i; else j;  end; end
def min(i,j); if(i>j) then j; else i;  end; end
def abs(i);   if(i>0) then i; else -i; end; end
def evalx(x); if(x.kind_of?(String)) then eval(x); else x; end; end

####################################################
#   end  of class definition
####################################################
