#!/usr/local/bin/ruby
# from demo/grph2/udegpk/u2df01.f

require "dcl"

$nx=19; $ny=19;
$xmin=0.0; $xmax=360.0; $ymin=-90.0; $ymax=90.0;
$pi=3.141592; $drad=$pi/180.0; $dz=0.05;

p=[]; x=[]; y=[];
for j in 0 .. $ny-1
   for i in 0 .. $nx-1 
        alon=( $xmin + ($xmax-$xmin) * i / ($nx-1) ) * $drad
	alat=( $ymin + ($ymax-$ymin) * j / ($ny-1) ) * $drad
        slat=Math.sin(alat)
        p[i+j*$nx] = Math.cos(alon) * (1-slat**2) * Math.sin(2*$pi*slat) + $dz
	x[i]=alon/$drad;
	y[j]=alat/$drad;
    end
end

Dcl.gropn(1)
Dcl.grfrm()

Dcl.grswnd($xmin, $xmax, $ymin, $ymax)
Dcl.grsvpt(0.2, 0.8, 0.2, 0.8 )
Dcl.grstrn(1)
Dcl.grstrf()

Dcl.usdaxs()

Dcl.uwsgxa(x,$nx)
Dcl.uwsgya(y,$ny)
Dcl.udcntr(p,$nx,$nx,$ny)

Dcl.grcls()



