/************************************************
  dcl.c
************************************************/

#include "ruby.h"
#include "math.h"


static VALUE
grfrm(self)
    VALUE self;     
{
  grfrm_();
  return INT2FIX(1);
}

static VALUE
grstrf(self)
    VALUE self;     
{
  grstrf_();
  return INT2FIX(1);
}

static VALUE
grcls(self)
    VALUE self;     
{
  grcls_();
  return INT2FIX(1);
}

static VALUE
usdaxs(self)
    VALUE self;     
{
  usdaxs_();
  return INT2FIX(1);
}

static VALUE
gropn(self,viws)
    VALUE self;     
    VALUE viws;     
{
  int iws;
  iws = FIX2INT(viws);
  gropn_(&iws);
  return INT2FIX(1);
}

static VALUE
grstrn(self,vitrn)
    VALUE self;     
    VALUE vitrn;     
{
  int itrn;
  itrn = FIX2INT(vitrn);
  grstrn_(&itrn);
  return INT2FIX(1);
}


static VALUE
grswnd(self,vxmin,vxmax,vymin,vymax)
    VALUE self;     
    VALUE vxmin;  VALUE vxmax;     
    VALUE vymin;  VALUE vymax;     
{
  float xmin, xmax, ymin, ymax;
  xmin = RFLOAT(vxmin)->value;
  xmax = RFLOAT(vxmax)->value;
  ymin = RFLOAT(vymin)->value;
  ymax = RFLOAT(vymax)->value;
  grswnd_(&xmin,&xmax,&ymin,&ymax);
  return INT2FIX(1);
}

static VALUE
grsvpt(self,vxmin,vxmax,vymin,vymax)
    VALUE self;     
    VALUE vxmin;  VALUE vxmax;     
    VALUE vymin;  VALUE vymax;     
{
  float xmin, xmax, ymin, ymax;
  xmin = RFLOAT(vxmin)->value;
  xmax = RFLOAT(vxmax)->value;
  ymin = RFLOAT(vymin)->value;
  ymax = RFLOAT(vymax)->value;
  grsvpt_(&xmin,&xmax,&ymin,&ymax);
  return INT2FIX(1);
}

static VALUE
udcntr(self,va,vmx,vnx,vny)
    VALUE self;     
    VALUE va;
    VALUE vmx;    VALUE vnx;    VALUE vny;
{
  float *a;
  int mx, nx, ny, i;

  mx = FIX2INT(vmx);
  nx = FIX2INT(vnx);
  ny = FIX2INT(vny);
  a = malloc(mx*ny*sizeof(float));
  for (i=0; i<mx*ny; i++) 
    a[i] = (float) RFLOAT(RARRAY(va)->ptr[i])->value;
  udcntr_(a,&mx,&nx,&ny);
  free(a);
  return INT2FIX(1);
}

static VALUE
uwsgxa(self,va,vnx)
    VALUE self;     
    VALUE va;
    VALUE vnx; 
{
  float *a;
  int nx, i;

  nx = FIX2INT(vnx);
  a = malloc(nx*sizeof(float));
  for (i=0; i<nx; i++)
    a[i] = (float) RFLOAT(RARRAY(va)->ptr[i])->value;
  uwsgxa_(a,&nx);
  free(a);
  return INT2FIX(1);
}

static VALUE
uwsgya(self,va,vny)
    VALUE self;     
    VALUE va;
    VALUE vny; 
{
  float *a;
  int ny, i;

  ny = FIX2INT(vny);
  a = malloc(ny*sizeof(float));
  for (i=0; i<ny; i++)
    a[i] = (float) RFLOAT(RARRAY(va)->ptr[i])->value;
  uwsgya_(a,&ny);
  free(a);
  return INT2FIX(1);
}

static VALUE
uxmttl(self,vcs,vct,vp)
    VALUE self;     
    VALUE vcs;
    VALUE vct; 
    VALUE vp;      
{
  char * cside;
  char * cttl;
  float px;

  cside = STR2CSTR(vcs);
  cttl  = STR2CSTR(vct);
  px    = RFLOAT(vp)->value;
  uxmttl_(cside,cttl,&px,strlen(cside),strlen(cttl));
  return INT2FIX(1);
}

static VALUE
uymttl(self,vcs,vct,vp)
    VALUE self;     
    VALUE vcs;
    VALUE vct; 
    VALUE vp;      
{
  char * cside;
  char * cttl;
  float px;

  cside = STR2CSTR(vcs);
  cttl  = STR2CSTR(vct);
  px    = RFLOAT(vp)->value;
  uymttl_(cside,cttl,&px,strlen(cside),strlen(cttl));
  return INT2FIX(1);
}

static VALUE
uxsttl(self,vcs,vct,vp)
    VALUE self;     
    VALUE vcs;
    VALUE vct; 
    VALUE vp;      
{
  char * cside;
  char * cttl;
  float px;

  cside = STR2CSTR(vcs);
  cttl  = STR2CSTR(vct);
  px    = RFLOAT(vp)->value;
  uxsttl_(cside,cttl,&px,strlen(cside),strlen(cttl));
  return INT2FIX(1);
}

static VALUE
uysttl(self,vcs,vct,vp)
    VALUE self;     
    VALUE vcs;
    VALUE vct; 
    VALUE vp;      
{
  char * cside;
  char * cttl;
  float px;

  cside = STR2CSTR(vcs);
  cttl  = STR2CSTR(vct);
  px    = RFLOAT(vp)->value;
  uysttl_(cside,cttl,&px,strlen(cside),strlen(cttl));
  return INT2FIX(1);
}

static VALUE
usgrph(self,vn,vx,vy)
    VALUE self;     
    VALUE vn;
    VALUE vx; 
    VALUE vy; 
{
  int n,i;
  float *x, *y;

  n = FIX2INT(vn);
  x = malloc(n*sizeof(float)); 
  y = malloc(n*sizeof(float));
  for (i=0; i<n; i++) {
    x[i] = (float) RFLOAT(RARRAY(vx)->ptr[i])->value;
    y[i] = (float) RFLOAT(RARRAY(vy)->ptr[i])->value;
  }
  usgrph_(&n,x,y);
  free(y); free(x);
  return INT2FIX(1);
}

static VALUE
usinit(self)
    VALUE self;     
{
  usinit_();
  return INT2FIX(1);
}

static VALUE
glrset(self,vcp,vpa)
    VALUE self;     
    VALUE vcp;
    VALUE vpa; 
{
  char * cp;
  float para;

  cp    = STR2CSTR(vcp);
  para  = RFLOAT(vpa)->value;
  glrset_(cp,&para,strlen(cp));
  return INT2FIX(1);
}


Init_dcl()
{
    VALUE mDcl = rb_define_module("Dcl");
    rb_define_module_function(mDcl, "grfrm",  grfrm,  0);
    rb_define_module_function(mDcl, "grstrf", grstrf, 0);
    rb_define_module_function(mDcl, "grcls",  grcls,  0);
    rb_define_module_function(mDcl, "usdaxs", usdaxs, 0);
    rb_define_module_function(mDcl, "gropn",  gropn,  1);
    rb_define_module_function(mDcl, "grstrn", grstrn, 1);
    rb_define_module_function(mDcl, "grswnd", grswnd, 4);
    rb_define_module_function(mDcl, "grsvpt", grsvpt, 4);
    rb_define_module_function(mDcl, "udcntr", udcntr, 4);
    rb_define_module_function(mDcl, "uwsgxa", uwsgxa, 2);
    rb_define_module_function(mDcl, "uwsgya", uwsgya, 2);
    rb_define_module_function(mDcl, "uxmttl", uxmttl, 3);
    rb_define_module_function(mDcl, "uymttl", uymttl, 3);
    rb_define_module_function(mDcl, "uxsttl", uxsttl, 3);
    rb_define_module_function(mDcl, "uysttl", uysttl, 3);
    rb_define_module_function(mDcl, "usgrph", usgrph, 3);
    rb_define_module_function(mDcl, "usinit", usinit, 0);
    rb_define_module_function(mDcl, "glrset", glrset, 2);
}

/* I don't know why this is neccessary */
MAIN__()
{
}
