########################################################################
# ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
# Copyright (C) 1998--2009 Keiichi Ishioka <ishioka@gfd-dennou.org>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301 USA.
########################################################################
.text
.globl ljlgzs_
ljlgzs_:

       movl   (%rdi), %edi  # : JH  rdi 
       movhpd (%rdx), %xmm1 # R  xmm1 ξ̤
       movlpd (%rdx), %xmm1 # R  xmm1 β̤ˤ
       movq  8(%rsp), %r10  # : W Υ١ɥ쥹
       
       pxor %xmm0,%xmm0 # xmm0  0 ˥å       
       
       shlq $3,%rdi # JH*8  rdi 
       
       movq %rcx,%r11
       addq %rdi,%r11
       
.align 16
.L0:
       movaps (%rcx), %xmm4 # Y
       movaps (%r8), %xmm2  # QA
       movaps (%r9), %xmm3  # QB
       movaps (%r10), %xmm5 # W

       mulpd %xmm1,%xmm4 # Y*R
       mulpd %xmm2,%xmm4 # R*Y*QA
       addpd %xmm4,%xmm3 # 줿 QB  xmm3 
       
       mulpd %xmm5,%xmm2 # W*QA
       addpd %xmm2,%xmm0 # S=S+W*QA

       movaps %xmm3,(%r9)  
       
       addq $16,%rcx
       addq $16,%r8       
       addq $16,%r9
       addq $16,%r10
       cmpq %rcx,%r11
       jne .L0
       
       movaps %xmm0,%xmm1
       shufpd $0x1,%xmm1,%xmm1
       addpd %xmm1,%xmm0
       movlpd %xmm0,(%rsi)  # xmm0 β̤ S 
       
#------------------------------------

       ret
       
