!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------
!
!= 1  (y ) ֳָ߳ʻ ͭºʬǥ ⥸塼
!
!* 
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2006/06/02 () : x_bc_module 
!

module y_bc_module
  != 1  (y ) ֳָ߳ʻ ͭºʬǥ ⥸塼
  !
  !== 
  !
  ! y_bc_module , 1  (y ) ֳָ߳ʻҤѤͭºʬˡ
  ! ŤͥǥΤ,  Fortran 90 ץ
  ! .
  !
  ! Υ⥸塼 y_module β̥⥸塼Ǥ. ⥸塼
  ! Ȥ data_type, y_base_module ⥸塼ѤƤ. 
  !
  !
  !== ³̿̾ˡ
  !
  ! ꤹץ
  !
  !   Boundary[򼨤ʸ]_(μ)
  !
  ! Τ褦̿̾Ƥ. 򼨤ʸϰʲ 3 ĤǤ.
  !
  !   Sym  : о
  !   Asym : ȿо
  !   Cyc :  
  ! 

  use dc_types,      only : DBKIND => DP
  use y_base_module, only : jm, ymargin, jmin, jmax
  implicit none

  private
  public :: BoundarySym_y, BoundaryAsym_y, BoundaryCyc_y
  public :: BoundarySym_q, BoundaryAsym_q, BoundaryCyc_q

  interface BoundaryCyc_y
    module procedure BoundaryCyc
  end interface 

  interface BoundaryCyc_q
    module procedure BoundaryCyc
  end interface 

  contains
!--------------------------------------------------------------------
    subroutine BoundarySym_y(y_Var)
      ! 1  (y ) оζŬѤ.

      real(DBKIND),intent(inout) :: y_Var(jmin:jmax) !  
      integer                    :: jy               ! 롼ź

      ! оζŬѤ
      ! 
      !   ex.) jm=5, ymargin=2 ξ (jmin=-1, jmax=7)
      !
      !   q    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   y  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    y_Var(jmin:0)          y_Var(jm+1,jmax) ͤ򹹿
      !     
      !   y_Var(0)  = y_Var(1)
      !   y_Var(-1) = y_Var(2)
      !   y_Var(6)  = y_Var(5)
      !   y_Var(7)  = y_Var(4)
      !
      do jy = 1, ymargin
        y_Var(1-jy)  = y_Var(jy)
        y_Var(jm+jy) = y_Var(jm+1-jy)
      end do

    end subroutine BoundarySym_y
!--------------------------------------------------------------------
    subroutine BoundaryAsym_y(y_Var)
      ! 1  (y ) ȿоζŬѤ.

      real(DBKIND),intent(inout) :: y_Var(jmin:jmax) !  
      integer                    :: jy               ! 롼ź

      ! ȿоζŬѤ
      ! 
      !   ex.) jm=5, ymargin=2 ξ (jmin=-1, jmax=7)
      !
      !   q    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   y  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    y_Var(jmin:0)          y_Var(jm+1,jmax) ͤ򹹿
      !     
      !   y_Var(0)  = - y_Var(1)
      !   y_Var(-1) = - y_Var(2)
      !   y_Var(6)  = - y_Var(5)
      !   y_Var(7)  = - y_Var(4)
      !
      do jy = 1, ymargin
        y_Var(1-jy)  = - y_Var(jy)
        y_Var(jm+jy) = - y_Var(jm+1-jy)
      end do

    end subroutine BoundaryAsym_y
!--------------------------------------------------------------------
    subroutine BoundarySym_q(q_Var)
      ! 1  (y ) оζŬѤ.

      real(DBKIND),intent(inout) :: q_Var(jmin:jmax) !  
      integer                    :: jy               ! 롼ź

      ! оζŬѤ
      ! 
      !   ex.) jm=5, ymargin=2 ξ (jmin=-1, jmax=7)
      !
      !   q    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   y  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    q_Var(jmin:-1)         q_Var(jm+1:jmax) ͤ򹹿
      !     
      !   q_Var(-1) = y_Var(1)
      !   q_Var(6)  = y_Var(4)
      !   q_Var(7)  = y_Var(3)
      !
      do jy = 1, ymargin-1
        q_Var(-jy)   = q_Var(jy)      
      end do

      do jy = 1, ymargin
        q_Var(jm+jy) = q_Var(jm+1-jy)
      end do

    end subroutine BoundarySym_q
!--------------------------------------------------------------------
    subroutine BoundaryAsym_q(q_Var)
      ! 1  (y ) ȿоζŬѤ.

      real(DBKIND),intent(inout) :: q_Var(jmin:jmax) !  
      integer                    :: jy               ! 롼ź

      ! ȿоζŬѤ
      ! 
      !   ex.) jm=5, ymargin=2 ξ (jmin=-1, jmax=7)
      !
      !   q    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   y  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    q_Var(jmin:0)           q_Var(jm,jmax) ͤ򹹿
      !     
      !   y_Var(0)  = 0
      !   y_Var(-1) = - y_Var(1)
      !   y_Var(5)  = 0
      !   y_Var(6)  = - y_Var(4)
      !   y_Var(7)  = - y_Var(3)
      !
      q_Var(0) = 0.0d0
      q_Var(jm) = 0.0d0
          
      do jy = 1, ymargin-1
        q_Var(-jy) = - q_Var(jy)
      end do

      do jy = 1, ymargin
        q_Var(jm+jy) = - q_Var(jm-jy)
      end do

    end subroutine BoundaryAsym_q
!--------------------------------------------------------------------
    subroutine BoundaryCyc(Var)
      ! 1  (y ) ˼ŬѤ.

      real(DBKIND),intent(inout) :: Var(jmin:jmax) !  
      integer                    :: jy             ! 롼ź

      ! ŬѤ
      ! 
      !   ex.) jm=5, ymargin=2 ξ (jmin=-1, jmax=7)
      !
      !   q    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   y  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    y_Var(jmin:0)         y_Var(jm+1,jmax) ͤ򹹿
      !    q_Var(jmin:0)         q_Var(jm+1,jmax) ͤ򹹿
      !     
      !   y_Var(0)  = y_Var(5)
      !   y_Var(-1) = y_Var(4)
      !   y_Var(6)  = y_Var(1)
      !   y_Var(7)  = y_Var(2)
      !     
      !   q_Var(0)  = q_Var(5)
      !   q_Var(-1) = q_Var(4)
      !   q_Var(6)  = q_Var(1)
      !   q_Var(7)  = q_Var(2)
      !
      do jy = 1, ymargin
        Var(1-jy)  = Var(jm+1-jy)
        Var(jm+jy) = Var(jy)
      end do

    end subroutine BoundaryCyc
!--------------------------------------------------------------------
end module y_bc_module
