!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------
!
!= 3  (xyz ) ֳָ߳ʻ ʻ⥸塼
!
!* 
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2006/12/26 () : ʿѴؿ̾򸵤᤹
!  * 2006/06/05 () : 
!
module xyz_base_module
  != 3  (xyz ) ֳָ߳ʻ ʻ⥸塼
  !
  !== 
  !
  ! xyz_base_module , 3  (xyz ) ֳָ߳ʻҤѤͭºʬ
  ! ˡ˴ŤͥǥΤ, Ū Fortran90 ץप
  ! ؿ󶡤. 
  !
  ! Υ⥸塼 xyz_module β̥⥸塼Ǥ. ⥸塼
  ! Ȥ data_type, x_base_module, y_base_module z_base_module 
  ! ⥸塼ѤƤ. 
  ! 
  !
  !== 
  !
  ! * 㳰ʤ
  ! * ξΥåɽʤ
  ! * ͤϥޥ󥤥ץͤȤƤ٤
  !
  use dc_types,  only : DBKIND => DP
  use x_base_module, only : im, imin, imax, xmargin, x_axis_init,   &
    &                       x_X, p_X, x_dx, p_dx, x_avr_p, p_avr_x, &
    &                       IntX_p, IntX_x, AvrX_p, AvrX_x
  use y_base_module, only : jm, jmin, jmax, ymargin, y_axis_init,   &
    &                       y_Y, q_Y, y_dy, q_dy, y_avr_q, q_avr_y, &
    &                       IntY_q, IntY_y, AvrY_q, AvrY_y
  use z_base_module, only : km, kmin, kmax, zmargin, z_axis_init,   &
    &                       z_Z, r_Z, z_dz, r_dz, z_avr_r, r_avr_z, &
    &                       IntZ_r, IntZ_z, AvrZ_r, AvrZ_z
  use xy_base_module, only : y_IntX_xy, y_IntX_py, q_IntX_xq
  
  implicit none

  private
  public :: im, imin, imax, xmargin, x_X, p_X, x_dx, p_dx    ! Cascaded
  public :: jm, jmin, jmax, ymargin, y_Y, q_Y, y_dy, q_dy    ! Cascaded
  public :: km, kmin, kmax, zmargin, z_Z, r_Z, z_dz, r_dz     ! Cascaded 
  public :: x_avr_p, p_avr_x, IntX_p, IntX_x, AvrX_p, AvrX_x ! Cascaded
  public :: y_avr_q, q_avr_y, IntY_q, IntY_y, AvrY_q, AvrY_y ! Cascaded
  public :: z_avr_r, r_avr_z, IntZ_r, IntZ_z, AvrZ_r, AvrZ_z ! Cascaded
  public :: xyz_X, xyz_Y, xyz_Z, xyz_dX, xyz_dY, xyz_dZ 
  public :: xyz_axis_init
!!
  public :: xyz_avr_pyz, xyr_avr_pyr, xqz_avr_pqz
  public :: pyz_avr_xyz, pyr_avr_xyr, pqz_avr_xqz
  public :: xyz_avr_xqz, pyz_avr_pqz, xyr_avr_xqr
  public :: xqz_avr_xyz, pqz_avr_pyz, xqr_avr_xyr
  public :: xyz_avr_xyr, pyz_avr_pyr, xqz_avr_xqr
  public :: xyr_avr_xyz, pyr_avr_pyz, xqr_avr_xqz
!!
  public :: pqz_avr_xyz, pyr_avr_xyz, xqr_avr_xyz
  public :: xyz_avr_pqz, xyz_avr_pyr, xyz_avr_xqr
!!
  public :: yz_IntX_xyz, yz_IntX_pyz, qz_IntX_xqz, yr_IntX_xyr
  public :: xz_IntY_xyz, xz_IntY_xqz, pz_IntY_pyz, xr_IntY_xyr 
  public :: xy_IntZ_xyz, xy_IntZ_xyr, py_IntZ_pyz, xq_IntZ_xqz 
  public :: z_IntXY_xyz, z_IntXY_pyz, z_IntXY_xqz, r_IntXY_xyr
  public :: IntXYZ_xyz , IntXYZ_pyz , IntXYZ_xqz , IntXYZ_xyr
  public :: yz_AvrX_xyz, yz_AvrX_pyz, qz_AvrX_xqz, yr_AvrX_xyr
  public :: xz_AvrY_xyz, xz_AvrY_xqz, pz_AvrY_pyz, xr_AvrY_xyr 
  public :: xy_AvrZ_xyz, xy_AvrZ_xyr, py_AvrZ_pyz, xq_AvrZ_xqz 
  public :: z_AvrXY_xyz, z_AvrXY_pyz, z_AvrXY_xqz, r_AvrXY_xyr
  public :: AvrXYZ_xyz , AvrXYZ_pyz , AvrXYZ_xqz , AvrXYZ_xyr

  real(DBKIND),allocatable :: xyz_X(:,:,:)   ! x ɸ(Ⱦʻ)
  real(DBKIND),allocatable :: xyz_Y(:,:,:)   ! y ɸ(Ⱦʻ)
  real(DBKIND),allocatable :: xyz_Z(:,:,:)   ! z ɸ(Ⱦʻ)
  real(DBKIND),allocatable :: xyz_dX(:,:,:)  ! x ʻҴֳ(Ⱦʻ)
  real(DBKIND),allocatable :: xyz_dY(:,:,:)  ! y ʻҴֳ(Ⱦʻ)
  real(DBKIND),allocatable :: xyz_dZ(:,:,:)  ! z ʻҴֳ(Ⱦʻ)

  save xyz_X, xyz_Y, xyz_Z

  interface xyz_avr_pyz
    module procedure xaa_avr_paa
  end interface 

  interface xyr_avr_pyr
    module procedure xaa_avr_paa
  end interface 

  interface xqz_avr_pqz
    module procedure xaa_avr_paa
  end interface 

  interface pyz_avr_xyz
    module procedure paa_avr_xaa
  end interface 

  interface pqz_avr_xqz
    module procedure paa_avr_xaa
  end interface 

  interface pyr_avr_xyr
    module procedure paa_avr_xaa
  end interface 

  interface xyz_avr_xqz
    module procedure aya_avr_aqa
  end interface 

  interface pyz_avr_pqz
    module procedure aya_avr_aqa
  end interface 

  interface xyr_avr_xqr
    module procedure aya_avr_aqa
  end interface 

  interface xqz_avr_xyz
    module procedure aqa_avr_aya
  end interface 

  interface pqz_avr_pyz
    module procedure aqa_avr_aya
  end interface 

  interface xqr_avr_xyr
    module procedure aqa_avr_aya
  end interface 

  interface xyz_avr_xyr
    module procedure aaz_avr_aar
  end interface 

  interface pyz_avr_pyr
    module procedure aaz_avr_aar
  end interface 

  interface xqz_avr_xqr
    module procedure aaz_avr_aar
  end interface 

  interface xyr_avr_xyz
    module procedure aar_avr_aaz
  end interface 

  interface pyr_avr_pyz
    module procedure aar_avr_aaz
  end interface 

  interface xqr_avr_xqz
    module procedure aar_avr_aaz
  end interface 

  interface yz_IntX_xyz
    module procedure aa_IntX_xaa
  end interface

  interface qz_IntX_xqz
    module procedure aa_IntX_xaa
  end interface

  interface yr_IntX_xyr
    module procedure aa_IntX_xaa
  end interface

  interface xz_IntY_xyz
    module procedure aa_IntY_aya
  end interface

  interface pz_IntY_pyz
    module procedure aa_IntY_aya
  end interface

  interface xr_IntY_xyr
    module procedure aa_IntY_aya
  end interface

  interface xy_IntZ_xyz
    module procedure aa_IntZ_aaz
  end interface

  interface py_IntZ_pyz
    module procedure aa_IntZ_aaz
  end interface

  interface xq_IntZ_xqz
    module procedure aa_IntZ_aaz
  end interface

  interface z_IntXY_xyz
    module procedure a_IntXY_xya
  end interface

  interface r_IntXY_xyr
    module procedure a_IntXY_xya
  end interface

  interface yz_AvrX_xyz
    module procedure aa_AvrX_xaa
  end interface

  interface qz_AvrX_xqz
    module procedure aa_AvrX_xaa
  end interface

  interface yr_AvrX_xyr
    module procedure aa_AvrX_xaa
  end interface

  interface xz_AvrY_xyz
    module procedure aa_AvrY_aya
  end interface

  interface pz_AvrY_pyz
    module procedure aa_AvrY_aya
  end interface

  interface xr_AvrY_xyr
    module procedure aa_AvrY_aya
  end interface

  interface xy_AvrZ_xyz
    module procedure aa_AvrZ_aaz
  end interface

  interface py_AvrZ_pyz
    module procedure aa_AvrZ_aaz
  end interface

  interface xq_AvrZ_xqz
    module procedure aa_AvrZ_aaz
  end interface

  interface z_AvrXY_xyz
    module procedure a_AvrXY_xya
  end interface

  interface r_AvrXY_xyr
    module procedure a_AvrXY_xya
  end interface

  contains
!--------------------------------------------------------------------
    subroutine xyz_axis_init(i, j, k, xmg, ymg, zmg, &
      &                      xmin, xmax, ymin, ymax, zmin, zmax)

      integer         ,intent(in) :: i     ! x ʻ
      integer         ,intent(in) :: j     ! y ʻ
      integer         ,intent(in) :: k     ! z ʻ
      integer         ,intent(in) :: xmg   ! x ʻ
      integer         ,intent(in) :: ymg   ! y ʻ
      integer         ,intent(in) :: zmg   ! z ʻ
      real(DBKIND),intent(in)     :: xmin  ! x ɸǾ     
      real(DBKIND),intent(in)     :: xmax  ! x ɸ  
      real(DBKIND),intent(in)     :: ymin  ! y ɸǾ     
      real(DBKIND),intent(in)     :: ymax  ! y ɸ  
      real(DBKIND),intent(in)     :: zmin  ! z ɸǾ     
      real(DBKIND),intent(in)     :: zmax  ! z ɸ  

      real(DBKIND),allocatable :: xy_X(:,:)! x ɸ(Ⱦʻ, )
      real(DBKIND),allocatable :: xy_Y(:,:)! y ɸ(Ⱦʻ, )
      real(DBKIND),allocatable :: yz_Z(:,:)! z ɸ(Ⱦʻ, )

      ! ξ岼¤, ɸͤȳʻֳ֤
      ! * 1 ѤΥ֥롼Ѥ
      !
      call x_axis_init(i, xmg, xmin, xmax)
      call y_axis_init(j, ymg, ymin, ymax)
      call z_axis_init(k, zmg, zmin, zmax)

      ! 3 ɸ
      ! * Ȥ߹ߴؿ spread Ѥ. 
      ! * Ȥ 2 ɸ,  3 ˳ĥ.
      ! 
      allocate(xy_X(imin:imax,jmin:jmax))
      allocate(xy_Y(imin:imax,jmin:jmax))
      allocate(yz_Z(jmin:jmax,kmin:kmax))

      allocate(xyz_X(imin:imax,jmin:jmax,kmin:kmax))
      allocate(xyz_Y(imin:imax,jmin:jmax,kmin:kmax))
      allocate(xyz_Z(imin:imax,jmin:jmax,kmin:kmax))
      allocate(xyz_dX(imin:imax,jmin:jmax,kmin:kmax))
      allocate(xyz_dY(imin:imax,jmin:jmax,kmin:kmax))
      allocate(xyz_dZ(imin:imax,jmin:jmax,kmin:kmax))

      xy_X  = spread(x_X, 2,size(y_Y))
      xyz_X = spread(xy_X,3,size(z_Z))

      xy_X   = spread(x_dX, 2,size(y_dY))
      xyz_dX = spread(xy_X,3,size(z_dZ))

      xy_Y  = spread(y_Y, 1,size(x_X))
      xyz_Y = spread(xy_Y,3,size(z_Z))

      xy_Y   = spread(y_dY, 1,size(x_dX))
      xyz_dY = spread(xy_Y,3,size(z_dZ))

      yz_Z  = spread(z_Z, 1,size(y_Y))
      xyz_Z = spread(yz_Z,1,size(x_X))

      yz_Z   = spread(z_dZ, 1,size(y_dY))
      xyz_dZ = spread(yz_Z,1,size(x_dX))

      deallocate(xy_X)
      deallocate(xy_Y)
      deallocate(yz_Z)

    end subroutine xyz_axis_init  
!--------------------------------------------------------------------
    function xaa_avr_paa(paa_Var)
      ! ʿԤ x ʻͤȾ֤
  
      real(DBKIND),intent(in) :: paa_Var(imin:imax,jmin:jmax,kmin:kmax)
      real(DBKIND)            :: xaa_avr_paa(imin:imax,jmin:jmax,kmin:kmax)
!      integer                 :: jy, kz
      integer                 :: ix

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xaa_avr_paa = 0.0d0

      ! ʿ
      ! * ؿ x_avr_p ѤƷ׻
      !
!      do kz = kmin, kmax
!        do jy = jmin, jmax
!          xaa_avr_paa(:,jy,kz) = x_avr_p(paa_Var(:,jy,kz))
!        end do
!      end do

      do ix = imin+1, imax
        xaa_avr_paa(ix,:,:) = (paa_Var(ix,:,:) + paa_Var(ix-1,:,:))*0.5d0 
      end do

      ! imin ʻҾ
      xaa_avr_paa(imin,:,:) = xaa_avr_paa(imin+1,:,:)


    end function xaa_avr_paa
!--------------------------------------------------------------------
    function paa_avr_xaa(xaa_Var)
      ! Ⱦʻ֤ͤ
  
      real(DBKIND),intent(in) :: xaa_Var(imin:imax,jmin:jmax,kmin:kmax)
      real(DBKIND)            :: paa_avr_xaa(imin:imax,jmin:jmax,kmin:kmax)
!      integer                 :: jy, kz                    
      integer                 :: ix

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      paa_avr_xaa = 0.0d0                                

      ! ʿ
      ! * ؿ p_avr_x ѤƷ׻
      !
!      do kz = kmin, kmax
!        do jy = jmin, jmax
!          paa_avr_xaa(:,jy,kz) = p_avr_x(xaa_Var(:,jy,kz))
!        end do
!      end do

      do ix = imin, imax-1
        paa_avr_xaa(ix,:,:) = &
          &  (x_dx(ix)*xaa_Var(ix+1,:,:) + x_dx(ix+1)*xaa_Var(ix,:,:)) &
          &  *0.5d0/p_dx(ix)
      end do

      paa_avr_xaa(imax,:,:) = paa_avr_xaa(imax-1,:,:) 

    end function paa_avr_xaa
!--------------------------------------------------------------------
    function aya_avr_aqa(aqa_Var)
      ! ʿԤ y Ⱦʻͤʻ֤
  
      real(DBKIND),intent(in) :: aqa_Var(imin:imax,jmin:jmax,kmin:kmax)   
      real(DBKIND)            :: aya_avr_aqa(imin:imax,jmin:jmax,kmin:kmax)
!      integer                 :: ix, kz
      integer                 :: jy

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      aya_avr_aqa = 0.0d0

      ! ʿ
      ! * ؿ y_q ѤƷ׻
      !
!      do kz = kmin, kmax
!        do ix = imin, imax
!          aya_avr_aqa(ix,:,kz) = y_avr_q(aqa_Var(ix,:,kz))
!        end do
!      end do

      do jy = jmin+1, jmax
        aya_avr_aqa(:,jy,:) = (aqa_Var(:,jy,:) + aqa_Var(:,jy-1,:))*0.5d0 
      end do
      
      aya_avr_aqa(:,jmin,:) = aya_avr_aqa(:,jmin+1,:)

    end function aya_avr_aqa
!--------------------------------------------------------------------
    function aqa_avr_aya(aya_Var)
      ! ʿԤ y Ⱦʻͤʻ֤
  
      real(DBKIND),intent(in) :: aya_Var(imin:imax,jmin:jmax,kmin:kmax)
      real(DBKIND)            :: aqa_avr_aya(imin:imax,jmin:jmax,kmin:kmax) 
!      integer                 :: ix, kz
      integer                 :: jy

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      aqa_avr_aya = 0.0d0

      ! ʿ
      ! * ؿ q_avr_y ѤƷ׻
      !
!      do kz = kmin, kmax
!        do ix = imin, imax
!          aqa_avr_aya(ix,:,kz) = q_avr_y(aya_Var(ix,:,kz))
!        end do
!      end do

      do jy = jmin, jmax-1
        aqa_avr_aya(:,jy,:) = &
          &  (y_dy(jy)*aya_Var(:,jy+1,:) + y_dy(jy+1)*aya_Var(:,jy,:)) &
          &  * 0.5d0/q_dy(jy)
      end do

      aqa_avr_aya(:,jmax,:) =  aqa_avr_aya(:,jmax-1,:) 

    end function aqa_avr_aya
!--------------------------------------------------------------------
    function aaz_avr_aar(aar_Var)
      ! ʿԤ z ʻͤȾʻ֤
  
      real(DBKIND),intent(in) :: aar_Var(imin:imax,jmin:jmax,kmin:kmax)   
      real(DBKIND)            :: aaz_avr_aar(imin:imax,jmin:jmax,kmin:kmax)
!      integer                 :: ix, jy
      integer                 :: kz

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      aaz_avr_aar = 0.0d0

      ! ʿ
      ! * ؿ z_avr_r ѤƷ׻
      !
!      do jy = jmin, jmax
!        do ix = imin, imax
!          aaz_avr_aar(ix,jy,:) = z_avr_r(aar_Var(ix,jy,:))
!        end do
!      end do

      do kz = kmin+1, kmax
        aaz_avr_aar(:,:,kz) = (aar_Var(:,:,kz) + aar_Var(:,:,kz-1))*0.5d0 
      end do

      aaz_avr_aar(:,:,kmin) = aaz_avr_aar(:,:,kmin+1)

    end function aaz_avr_aar
!--------------------------------------------------------------------
    function aar_avr_aaz(aaz_Var)
      ! ʿԤ z Ⱦʻͤʻ֤
  
      real(DBKIND),intent(in) :: aaz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DBKIND)            :: aar_avr_aaz(imin:imax,jmin:jmax,kmin:kmax)
!      integer                 :: ix, jy
      integer                 :: kz

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      aar_avr_aaz = 0.0d0

      ! ʿ
      ! * ؿ r_avr_z ѤƷ׻
      !
!      do jy = jmin, jmax
!        do ix = imin, imax
!          aar_avr_aaz(ix,jy,:) = r_avr_z(aaz_Var(ix,jy,:))
!        end do
!      end do

      do kz = kmin, kmax-1
        aar_avr_aaz(:,:,kz) = &
          &  (z_dz(kz)*aaz_Var(:,:,kz+1) + z_dz(kz+1)*aaz_Var(:,:,kz)) &
          &  *0.5d0/r_dz(kz)
      end do

      aar_avr_aaz(:,:,kmax) = aar_avr_aaz(:,:,kmax-1)

    end function aar_avr_aaz
!--------------------------------------------------------------------
    function pqz_avr_xyz(xyz_Var)
      real(DBKIND), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax)! 
      real(DBKIND)             :: pqz_avr_xyz(imin:imax,jmin:jmax,kmin:kmax)       ! 
      integer                  :: ix, jy                          ! 롼ź

      ! 
      pqz_avr_xyz = 0.0d0

      do jy = jmin, jmax-1
        do ix = imin, imax-1
          pqz_avr_xyz(ix,jy,:) = &
            &  ( xyz_Var(ix,jy,:)   + xyz_Var(ix+1,jy,:) +  &
            &    xyz_Var(ix,jy+1,:) + xyz_Var(ix+1,jy+1,:) ) * 0.25d0 
        end do
      end do

    end function pqz_avr_xyz
!--------------------------------------------------------------------
    function pyr_avr_xyz(xyz_Var)
      real(DBKIND), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax)! 
      real(DBKIND)             :: pyr_avr_xyz(imin:imax,jmin:jmax,kmin:kmax)       ! 
      integer                  :: ix, kz                          ! 롼ź

      ! 
      pyr_avr_xyz = 0.0d0

      do kz = kmin, kmax-1
        do ix = imin, imax-1
          pyr_avr_xyz(ix,:,kz) = &
            &  ( xyz_Var(ix,:,kz)   + xyz_Var(ix+1,:,kz) +  &
            &    xyz_Var(ix,:,kz+1) + xyz_Var(ix+1,:,kz+1) ) * 0.25d0 
        end do
      end do

    end function pyr_avr_xyz
!--------------------------------------------------------------------
    function xqr_avr_xyz(xyz_Var)
      real(DBKIND), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax)! 
      real(DBKIND)             :: xqr_avr_xyz(imin:imax,jmin:jmax,kmin:kmax)       ! 
      integer                  :: jy, kz                          ! 롼ź

      ! 
      xqr_avr_xyz = 0.0d0

      do kz = kmin, kmax-1
        do jy = jmin, jmax-1
          xqr_avr_xyz(:,jy,kz) = &
            &  ( xyz_Var(:,jy,kz)   + xyz_Var(:,jy+1,kz) +  &
            &    xyz_Var(:,jy,kz+1) + xyz_Var(:,jy+1,kz+1) ) * 0.25d0 
        end do
      end do

    end function xqr_avr_xyz
!--------------------------------------------------------------------
    function xyz_avr_pqz(pqz_Var)
      real(DBKIND), intent(in) :: pqz_Var(imin:imax,jmin:jmax,kmin:kmax)! 
      real(DBKIND)             :: xyz_avr_pqz(imin:imax,jmin:jmax,kmin:kmax)       ! 
      integer                  :: ix, jy                          ! 롼ź

      ! 
      xyz_avr_pqz = 0.0d0

      do jy = jmin+1, jmax
        do ix = imin+1, imax
          xyz_avr_pqz(ix,jy,:) = &
            &  ( pqz_Var(ix-1,jy-1,:) + pqz_Var(ix,jy-1,:) +  &
            &    pqz_Var(ix-1,jy,:)   + pqz_Var(ix,jy,:)     ) * 0.25d0 
        end do
      end do

    end function xyz_avr_pqz
!--------------------------------------------------------------------
    function xyz_avr_pyr(pyr_Var)
      real(DBKIND), intent(in) :: pyr_Var(imin:imax,jmin:jmax,kmin:kmax)! 
      real(DBKIND)             :: xyz_avr_pyr(imin:imax,jmin:jmax,kmin:kmax)       ! 
      integer                  :: ix, kz                          ! 롼ź

      ! 
      xyz_avr_pyr = 0.0d0

      do kz = kmin+1, kmax
        do ix = imin+1, imax
          xyz_avr_pyr(ix,:,kz) = &
            &  ( pyr_Var(ix-1,:,kz-1) + pyr_Var(ix,:,kz-1) +  &
            &    pyr_Var(ix-1,:,kz)   + pyr_Var(ix,:,kz)     ) * 0.25d0 
        end do
      end do

    end function xyz_avr_pyr
!--------------------------------------------------------------------
    function xyz_avr_xqr(xqr_Var)
      real(DBKIND), intent(in) :: xqr_Var(imin:imax,jmin:jmax,kmin:kmax)! 
      real(DBKIND)             :: xyz_avr_xqr(imin:imax,jmin:jmax,kmin:kmax)       ! 
      integer                  :: jy, kz                          ! 롼ź

      ! 
      xyz_avr_xqr = 0.0d0

      do kz = kmin+1, kmax
        do jy = jmin+1, jmax
          xyz_avr_xqr(:,jy,kz) = &
            &  ( xqr_Var(:,jy-1,kz-1) + xqr_Var(:,jy,kz-1) +  &
            &    xqr_Var(:,jy-1,kz)   + xqr_Var(:,jy,kz)     ) * 0.25d0 
        end do
      end do

    end function xyz_avr_xqr
!--------------------------------------------------------------------
    function aa_IntX_xaa(xaa_Var)
      ! xaa ʻҾФ x ʬԤ

      real(DBKIND), intent(in) :: xaa_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: aa_IntX_xaa(jmin:jmax,kmin:kmax)       ! 
      integer                  :: jy, kz                           ! 롼ź

      ! 
      aa_IntX_xaa = 0.0d0

      ! ʬ
      do kz = kmin, kmax
        do jy = jmin, jmax
          aa_IntX_xaa(jy,kz) = IntX_x(xaa_Var(:,jy,kz))
        end do
      end do

    end function aa_IntX_xaa
!--------------------------------------------------------------------
    function yz_IntX_pyz(pyz_Var)
      ! pyz ʻҾФ x ʬԤ

      real(DBKIND), intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: yz_IntX_pyz(jmin:jmax,kmin:kmax)       ! 
      integer                  :: jy, kz                           ! 롼ź

      ! 
      yz_IntX_pyz = 0.0d0

      ! ʬ
      do kz = kmin, kmax
        do jy = jmin, jmax
          yz_IntX_pyz(jy,kz) = IntX_p(pyz_Var(:,jy,kz))
        end do
      end do

    end function yz_IntX_pyz
!--------------------------------------------------------------------
    function aa_IntY_aya(aya_Var)
      ! aya ʻҾФ y ʬԤ

      real(DBKIND), intent(in) :: aya_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: aa_IntY_aya(imin:imax,kmin:kmax)       ! 
      integer                  :: ix, kz                           ! 롼ź

      ! 
      aa_IntY_aya = 0.0d0

      ! ʬ
      do kz = kmin, kmax
        do ix = imin, imax
          aa_IntY_aya(ix,kz) = IntY_y(aya_Var(ix,:,kz))
        end do
      end do

    end function aa_IntY_aya
!--------------------------------------------------------------------
    function xz_IntY_xqz(xqz_Var)
      ! xqz ʻҾФ y ʬԤ

      real(DBKIND), intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: xz_IntY_xqz(imin:imax,kmin:kmax)       ! 
      integer                  :: ix, kz                           ! 롼ź

      ! 
      xz_IntY_xqz = 0.0d0

      ! ʬ
      do kz = kmin, kmax
        do ix = imin, imax
          xz_IntY_xqz(ix,kz) = IntY_q(xqz_Var(ix,:,kz))
        end do
      end do

    end function xz_IntY_xqz
!--------------------------------------------------------------------
    function aa_IntZ_aaz(aaz_Var)
      ! aaz ʻҾФ z ʬԤ

      real(DBKIND), intent(in) :: aaz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: aa_IntZ_aaz(imin:imax,jmin:jmax)       ! 
      integer                  :: ix, jy                           ! 롼ź

      ! 
      aa_IntZ_aaz = 0.0d0

      ! ʬ
      do jy = jmin, jmax
        do ix = imin, imax
          aa_IntZ_aaz(ix,jy) = IntZ_z(aaz_Var(ix,jy,:))
        end do
      end do

    end function aa_IntZ_aaz
!--------------------------------------------------------------------
    function xy_IntZ_xyr(xyr_Var)
      ! xyr ʻҾФ z ʬԤ

      real(DBKIND), intent(in) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: xy_IntZ_xyr(imin:imax,jmin:jmax)       ! 
      integer                  :: ix, jy                           ! 롼ź

      ! 
      xy_IntZ_xyr = 0.0d0

      ! ʬ
      do jy = jmin, jmax
        do ix = imin, imax
          xy_IntZ_xyr(ix,jy) = IntZ_r(xyr_Var(ix,jy,:))
        end do
      end do

    end function xy_IntZ_xyr
!--------------------------------------------------------------------
    function a_IntXY_xya(xya_Var)
      ! xya ʻҾФ xy ʬԤ

      real(DBKIND), intent(in) :: xya_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: a_IntXY_xya(kmin:kmax)       ! 
      integer                  :: kz                           ! 롼ź

      ! 
      a_IntXY_xya = 0.0d0

      ! ʬ
      do kz = kmin, kmax
        a_IntXY_xya(kz) = IntY_y(y_IntX_xy(xya_Var(:,:,kz)))
      end do

    end function a_IntXY_xya
!--------------------------------------------------------------------
    function z_IntXY_pyz(pyz_Var)
      ! pyz ʻҾФ xy ʬԤ

      real(DBKIND), intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: z_IntXY_pyz(kmin:kmax)       ! 
      integer                  :: kz                           ! 롼ź

      ! 
      z_IntXY_pyz = 0.0d0

      ! ʬ
      do kz = kmin, kmax
        z_IntXY_pyz(kz) = IntY_y(y_IntX_py(pyz_Var(:,:,kz)))
      end do

    end function z_IntXY_pyz
!--------------------------------------------------------------------
    function z_IntXY_xqz(xqz_Var)
      ! xqz ʻҾФ xy ʬԤ

      real(DBKIND), intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: z_IntXY_xqz(kmin:kmax)       ! 
      integer                  :: kz                           ! 롼ź

      ! 
      z_IntXY_xqz = 0.0d0

      ! ʬ
      do kz = kmin, kmax
        z_IntXY_xqz(kz) = IntY_q(q_IntX_xq(xqz_Var(:,:,kz)))
      end do

    end function z_IntXY_xqz
!--------------------------------------------------------------------
    function IntXYZ_xyz(xyz_Var)
      ! xyz ʻҾФΰʬԤ

      real(DBKIND), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: IntXYZ_xyz                             ! 

      ! 
      IntXYZ_xyz = 0.0d0

      IntXYZ_xyz = IntZ_z(a_IntXY_xya(xyz_Var))

    end function IntXYZ_xyz
!--------------------------------------------------------------------
    function IntXYZ_pyz(pyz_Var)
      ! pyz ʻҾФΰʬԤ

      real(DBKIND), intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: IntXYZ_pyz                             ! 

      ! 
      IntXYZ_pyz = 0.0d0

      IntXYZ_pyz = IntZ_z(z_IntXY_pyz(pyz_Var))

    end function IntXYZ_pyz
!--------------------------------------------------------------------
    function IntXYZ_xqz(xqz_Var)
      ! xqz ʻҾФΰʬԤ

      real(DBKIND), intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: IntXYZ_xqz                             ! 

      ! 
      IntXYZ_xqz = 0.0d0

      IntXYZ_xqz = IntZ_z(z_IntXY_xqz(xqz_Var))

    end function IntXYZ_xqz
!--------------------------------------------------------------------
    function IntXYZ_xyr(xyr_Var)
      ! xyr ʻҾФΰʬԤ

      real(DBKIND), intent(in) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: IntXYZ_xyr                             ! 

      ! 
      IntXYZ_xyr = 0.0d0

      IntXYZ_xyr = IntZ_r(a_IntXY_xya(xyr_Var))

    end function IntXYZ_xyr
!--------------------------------------------------------------------
    function aa_AvrX_xaa(xaa_Var)
      ! xaa ʻҾФ x ʿѤԤ

      real(DBKIND), intent(in) :: xaa_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: aa_AvrX_xaa(jmin:jmax,kmin:kmax)       ! 

      ! 
      aa_AvrX_xaa = 0.0d0

      ! ʿ
      aa_AvrX_xaa = aa_IntX_xaa(xaa_Var)/sum(x_dx(1:im))

    end function aa_AvrX_xaa
!--------------------------------------------------------------------
    function yz_AvrX_pyz(pyz_Var)
      ! pyz ʻҾФ x ʿѤԤ

      real(DBKIND), intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: yz_AvrX_pyz(jmin:jmax,kmin:kmax)       ! 
      
      ! 
      yz_AvrX_pyz = 0.0d0

      ! ʿ
      yz_AvrX_pyz = yz_IntX_pyz(pyz_Var)/sum(x_dx(1:im))

    end function yz_AvrX_pyz
!--------------------------------------------------------------------
    function aa_AvrY_aya(aya_Var)
      ! aya ʻҾФ y ʿѤԤ

      real(DBKIND), intent(in) :: aya_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: aa_AvrY_aya(imin:imax,kmin:kmax)       ! 
      
      ! 
      aa_AvrY_aya = 0.0d0

      ! ʿ
      aa_AvrY_aya = aa_IntY_aya(aya_Var)/sum(y_dy(1:jm))

    end function aa_AvrY_aya
!--------------------------------------------------------------------
    function xz_AvrY_xqz(xqz_Var)
      ! xqz ʻҾФ y ʿѤԤ

      real(DBKIND), intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: xz_AvrY_xqz(imin:imax,kmin:kmax)       ! 
      
      ! 
      xz_AvrY_xqz = 0.0d0

      ! ʿ
      xz_AvrY_xqz = xz_IntY_xqz(xqz_Var)/sum(y_dy(1:jm))

    end function xz_AvrY_xqz
!--------------------------------------------------------------------
    function aa_AvrZ_aaz(aaz_Var)
      ! aaz ʻҾФ z ʿѤԤ

      real(DBKIND), intent(in) :: aaz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: aa_AvrZ_aaz(imin:imax,jmin:jmax)       ! 

      ! 
      aa_AvrZ_aaz = 0.0d0

      ! ʿ
      aa_AvrZ_aaz = aa_IntZ_aaz(aaz_Var)/sum(z_dz(1:km))

    end function aa_AvrZ_aaz
!--------------------------------------------------------------------
    function xy_AvrZ_xyr(xyr_Var)
      ! xyr ʻҾФ z ʿѤԤ

      real(DBKIND), intent(in) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: xy_AvrZ_xyr(imin:imax,jmin:jmax)       ! 
      
      ! 
      xy_AvrZ_xyr = 0.0d0

      ! ʿ
      xy_AvrZ_xyr = xy_IntZ_xyr(xyr_Var)/sum(z_dz(1:km))

    end function xy_AvrZ_xyr
!--------------------------------------------------------------------
    function AvrXYZ_xyz(xyz_Var)
      ! xyz ʻҾФΰʬԤ

      real(DBKIND), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: AvrXYZ_xyz                             ! 

      ! 
      AvrXYZ_xyz = 0.0d0

      AvrXYZ_xyz = IntXYZ_xyz(xyz_Var)/ &
        &             (sum(x_dx(1:im))*sum(y_dy(1:jm))*sum(z_dz(1:km)))

    end function AvrXYZ_xyz
!--------------------------------------------------------------------
    function AvrXYZ_pyz(pyz_Var)
      ! pyz ʻҾФΰʬԤ

      real(DBKIND), intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: AvrXYZ_pyz                             ! 

      ! 
      AvrXYZ_pyz = 0.0d0

      AvrXYZ_pyz = IntXYZ_pyz(pyz_Var)/ &
        &             (sum(x_dx(1:im))*sum(y_dy(1:jm))*sum(z_dz(1:km)))

    end function AvrXYZ_pyz
!--------------------------------------------------------------------
    function AvrXYZ_xqz(xqz_Var)
      ! xqz ʻҾФΰʬԤ

      real(DBKIND), intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: AvrXYZ_xqz                             ! 

      ! 
      AvrXYZ_xqz = 0.0d0

      AvrXYZ_xqz = IntXYZ_xqz(xqz_Var)/ &
        &             (sum(x_dx(1:im))*sum(y_dy(1:jm))*sum(z_dz(1:km)))

    end function AvrXYZ_xqz
!--------------------------------------------------------------------
    function AvrXYZ_xyr(xyr_Var)
      ! xyr ʻҾФΰʬԤ

      real(DBKIND), intent(in) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: AvrXYZ_xyr                             ! 

      ! 
      AvrXYZ_xyr = 0.0d0

      AvrXYZ_xyr = IntXYZ_xyr(xyr_Var)/ &
        &             (sum(x_dx(1:im))*sum(y_dy(1:jm))*sum(z_dz(1:km)))

    end function AvrXYZ_xyr
!--------------------------------------------------------------------
    function a_AvrXY_xya(xya_Var)
      ! xya ʻҾФ xy ʿѤԤ

      real(DBKIND), intent(in) :: xya_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: a_AvrXY_xya(kmin:kmax)       ! 

      ! 
      a_AvrXY_xya = 0.0d0

      ! ʿ
      a_AvrXY_xya = a_IntXY_xya(xya_Var)/(sum(x_dx(1:im))*sum(y_dy(1:jm)))

    end function a_AvrXY_xya
!--------------------------------------------------------------------
    function z_AvrXY_pyz(pyz_Var)
      ! pyz ʻҾФ xy ʿѤԤ

      real(DBKIND), intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: z_AvrXY_pyz(kmin:kmax)       ! 

      ! 
      z_AvrXY_pyz = 0.0d0

      ! ʿ
      z_AvrXY_pyz = z_IntXY_pyz(pyz_Var)/(sum(x_dx(1:im))*sum(y_dy(1:jm)))

    end function z_AvrXY_pyz
!--------------------------------------------------------------------
    function z_AvrXY_xqz(xqz_Var)
      ! xqz ʻҾФ xy ʬԤ

      real(DBKIND), intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
      real(DBKIND)             :: z_AvrXY_xqz(kmin:kmax)       ! 

      ! 
      z_AvrXY_xqz = 0.0d0

      ! ʿ
      z_AvrXY_xqz = z_IntXY_xqz(xqz_Var)/(sum(x_dx(1:im))*sum(y_dy(1:jm)))

    end function z_AvrXY_xqz
!--------------------------------------------------------------------
end module xyz_base_module
