!= Module TimeSet
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: timeset.f90,v 1.5 2007-08-03 06:32:34 odakker Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ줿 NAMELIST ե뤫, ˴ؤ, 
!ݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!

module timeset
  !
  !Ϳ줿 NAMELIST ե뤫, ˴ؤ, 
  !ݴɤ뤿ѿ⥸塼
  !

  !⥸塼ɤ߹
  use dc_types,   only: DP
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  
  !ۤηػ
  implicit none

  !save °
  save

  ! Public Interface
  real(DP)          :: DelTimeLong    !Ĺॹƥå
  real(DP)          :: DelTimeShort   !ûॹƥå
  real(DP)          :: TimeInt        !ʬ
  real(DP)          :: TimeDisp       !եϤֳִ
  real(DP)          :: DayTime        ! 1 Ĺ [s]
  integer           :: NstepLong      !ĹॹƥåפΥƥå׿
  integer           :: NstepShort     !ûॹƥåפΥƥå׿
  integer           :: NstepDisp      !ϤޤǤΥƥå׿

contains

  subroutine timeset_init(cfgfile)
    !
    !NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
    !

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile

    !ѿ
    integer                  :: unit
    
    !NAMELIST 
    NAMELIST /timeset/ &
         & DelTimeLong, DelTimeShort, TimeInt, TimeDisp, DayTime
    
    call FileOpen(unit, file=cfgfile, mode='r')
    read(unit, NML=timeset)
    close(unit)

    !---------------------------------------------------------------
    ! 顼
    !   DelTimeShort < DelTimeLong =< TimeDisp =< TimeInt Ǥʤ, 
    !   顼֤λ
    !---------------------------------------------------------------
    if ( TimeDisp > TimeInt ) then
      call MessageNotify( "E", &
        &                 "timeset_init", &
        &                 "TimeInt is smaller than TimeDisp" )
    else if ( DelTimeLong > TimeDisp ) then 
      call MessageNotify( "E", &
        &                 "timeset_init", &
        &                 "TimeDisp is smaller than DelTimeLong" )
    else if ( DelTimeShort > DelTimeLong ) then 
      call MessageNotify( "E", &
        &                 "timeset_init", &
        &                 "DelTimeLong is smaller than DelTimeShort" )
    end if


    !---------------------------------------------------------------
    ! 롼ײ
    !---------------------------------------------------------------
    NstepLong = nint( TimeInt / DelTimeLong )
    NstepShort = 2 * nint( DelTimeLong / DelTimeShort )
    
    !ʬ֤Ĺ֥ƥåפǳڤʤˤϷٹФ
    if(mod(TimeInt, DelTimeLong) /= 0) then 
      call MessageNotify( "W", &
        & "timeset_init", "mod(TimeInt, DelTimeLong) is not zero")
    end if
    
    !Ĺ֥ƥåפû֥ƥåפǳڤʤˤϷٹФ
    if(mod(DelTimeLong, DelTimeShort) /= 0) then 
      call MessageNotify( "W", &
        & "timeset_init", "mod(DelTimeLong, DelTimeShort) is not zero")
    end if
    
    !ϤޤǤΥƥå׿
    NStepDisp = nint( TimeDisp / DelTimeLong ) 
    if(mod(TimeDisp, DelTimeLong) /= 0) then 
      call MessageNotify( "W", &
        & "timeset_init", "mod(TimeDisp, DelTimeLong) is not zero")
    end if
    if(mod(NstepLong, NstepDisp) /= 0) then 
      call MessageNotify( "W", &
        & "timeset_init", "mod(NstepLong, NstepDisp) is not zero")
    end if
       
    !---------------------------------------------------------------
    ! ǧ
    !---------------------------------------------------------------
    call MessageNotify( "M", &
      & "timeset_init", "DelTimeLong = %f", d=(/DelTimeLong/) )
    call MessageNotify( "M", &
      & "timeset_init", "DelTimeShort = %f", d=(/DelTimeShort/) )
    call MessageNotify( "M", &
      & "timeset_init", "NstepLong = %d", i=(/NstepLong/) )
    call MessageNotify( "M", &
      & "timeset_init", "NstepDisp = %d", i=(/NstepDisp/) )
    call MessageNotify( "M", &
      & "timeset_init", "NstepShort = %d", i=(/NstepShort/) )
    call MessageNotify( "M", &
      & "timeset_init", "TimeInt = %f",  d=(/TimeInt/)  )
    call MessageNotify( "M", &
      & "timeset_init", "TimeDisp= %f", d=(/TimeDisp/) )
    call MessageNotify( "M", &
      & "timeset_init", "DayTime= %f",  d=(/DayTime/)  )
   
  end subroutine timeset_init
  
end module timeset
