!= Module StorePotTemp_3d
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: storepottemp_3d.f90,v 1.2 2008-06-19 16:52:09 odakker Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!̤˴ؤѻͤݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module StorePotTemp_3d
  !
  !̤˴ؤѻͤݴɤ뤿ѿ⥸塼.
  !
  use dc_types,  only : DP
  use dc_message,only : MessageNotify

  !⥸塼ɤ߹
  use gridset_3d, only:   DimXMin,     & ! x β
    &                  DimXMax,     & ! x ξ
    &                  DimYMin,     & ! y β
    &                  DimYMax,     & ! y ξ
    &                  DimZMin,     & ! z β
    &                  DimZMax,     & ! z ξ
    &                  SpcNum,      & ! number of species
    &                  RegXMin,     & ! x ʪΰβ
    &                  RegXMax,     & ! x ʪΰξ
    &                  RegYMin,     & ! y ʪΰβ
    &                  RegYMax        ! y ʪΰξ
  use TimeSet, only:   TimeDisp,    & ! ϻֳִ
    &                  DelTimeLong    ! Ĺ֥ƥå

  use xyz_base_module, only: z_AvrXY_xyz

  !ۤηػ
  implicit none

  !°λ
  private

  !
  public StorePotTemp_Init, StorePotTempMeanXY, StorePotTempClean
  public z_Adv,  z_Turb, z_Disp, z_Diff, z_Rad, &
    &    z_Cond, z_Flux, z_Damp
  public StorePotTempAdv,  StorePotTempTurb, StorePotTempDisp, &
    &    StorePotTempDiff, StorePotTempRad,                    &
    &    StorePotTempCond, StorePotTempFlux, StorePotTempDamp

  !ѿ
  real(DP),allocatable :: z_Adv(:)
  real(DP),allocatable :: z_Turb(:)
  real(DP),allocatable :: z_Disp(:)
  real(DP),allocatable :: z_Diff(:)
  real(DP),allocatable :: z_Rad(:)
  real(DP),allocatable :: z_Damp(:)
  real(DP),allocatable :: z_Cond(:)
  real(DP),allocatable :: z_Flux(:)
  real(DP),allocatable :: xyz_Adv(:,:,:)
  real(DP),allocatable :: xyz_Turb(:,:,:)
  real(DP),allocatable :: xyz_Disp(:,:,:)
  real(DP),allocatable :: xyz_Diff(:,:,:)
  real(DP),allocatable :: xyz_Rad(:,:,:)
  real(DP),allocatable :: xyz_Damp(:,:,:)
  real(DP),allocatable :: xyz_Cond(:,:,:)
  real(DP),allocatable :: xyz_Flux(:,:,:)

  !save °
  save xyz_Adv,  xyz_Turb, xyz_Disp, xyz_Diff, xyz_Rad, &
    &  xyz_Cond, xyz_Flux, xyz_Damp
  save z_Adv,  z_Turb, z_Disp, z_Diff, z_Rad, &
    &  z_Cond, z_Flux, z_Damp

contains

  subroutine StorePotTemp_Init( )
    !롼

    call MessageNotify( "M", "StorePotTemp_Init", "Initialize" )

    allocate(     &
      & z_Adv (DimZMin:DimZMax), & 
      & z_Turb(DimZMin:DimZMax), &
      & z_Disp(DimZMin:DimZMax), &
      & z_Diff(DimZMin:DimZMax), &
      & z_Rad (DimZMin:DimZMax), &
      & z_Damp(DimZMin:DimZMax), &
      & z_Cond(DimZMin:DimZMax), &
      & z_Flux(DimZMin:DimZMax), &
      & xyz_Adv (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), & 
      & xyz_Turb(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_Disp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_Diff(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_Rad (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_Damp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_Cond(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax), &
      & xyz_Flux(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)  &
      &  )

    call StorePotTempClean

  end subroutine StorePotTemp_Init


  subroutine StorePotTempClean( )
    !ݴɤͤΥꥢ
    
    z_Adv  = 0.0d0
    z_Turb = 0.0d0
    z_Diff = 0.0d0
    z_Disp = 0.0d0
    z_Rad  = 0.0d0
    z_Damp = 0.0d0
    z_Cond = 0.0d0
    z_Flux = 0.0d0

    xyz_Adv  = 0.0d0
    xyz_Turb = 0.0d0
    xyz_Diff = 0.0d0
    xyz_Disp = 0.0d0
    xyz_Rad  = 0.0d0
    xyz_Damp = 0.0d0
    xyz_Cond = 0.0d0
    xyz_Flux = 0.0d0
   
!    CalNum  = 1.0d-40    !ػ. 
  end subroutine StorePotTempClean


  subroutine StorePotTempMeanXY( )
    !ݴɤͤοʿʿ [K/s]
    real(DP):: CalNum

    CalNum = TimeDisp / DelTimeLong 
    
    z_Adv  = a_MeanXY_aaa( xyz_Adv )   / CalNum
    z_Turb = a_MeanXY_aaa( xyz_Turb )  / CalNum
    z_Diff = a_MeanXY_aaa( xyz_Diff )  / CalNum
    z_Disp = a_MeanXY_aaa( xyz_Disp )  / CalNum
    z_Rad  = a_MeanXY_aaa( xyz_Rad  )  / CalNum
    z_Damp = a_MeanXY_aaa( xyz_Damp )  / CalNum
    z_Cond = a_MeanXY_aaa( xyz_Cond )  / CalNum
    z_Flux = a_MeanXY_aaa( xyz_Flux )  / CalNum

  end subroutine StorePotTempMeanXY


  subroutine StorePotTempAdv( Work )
    !ήݴ

    implicit none

    real(DP),intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    Work2  = xyz_Adv + Work
    xyz_Adv = Work2

  end subroutine StorePotTempAdv


  subroutine StorePotTempTurb( Work )
    !ήݴ

    implicit none

    real(DP),intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    Work2   = xyz_Turb + Work
    xyz_Turb = Work2

  end subroutine StorePotTempTurb


  subroutine StorePotTempDiff( Work )
    !ͳȻݴ

    implicit none
    
    real(DP),intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    Work2   = xyz_Diff + Work
    xyz_Diff = Work2

  end subroutine StorePotTempDiff


  subroutine StorePotTempDisp( Work )
    !Ǯݴ

    implicit none
    
    real(DP),intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    Work2   = xyz_Disp + Work
    xyz_Disp = Work2

  end subroutine StorePotTempDisp


  subroutine StorePotTempRad( Work )
    !ѹݴ

    implicit none
    
    real(DP),intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    Work2  = xyz_Rad + Work
    xyz_Rad = Work2

  end subroutine StorePotTempRad


  subroutine StorePotTempDamp( Work )
    !ԥ󥰹ݴ

    implicit none
    
    real(DP),intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    Work2   = xyz_Damp + Work
    xyz_Damp = Work2

  end subroutine StorePotTempDamp


  subroutine StorePotTempCond( Work )
    !ǮȯǮݴ

    implicit none
    
    real(DP),intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    Work2   = xyz_Cond + Work
    xyz_Cond = Work2

  end subroutine StorePotTempCond


  subroutine StorePotTempFlux( Work )
    !ɽ̥եåݴ

    implicit none
    
    real(DP),intent(in)  :: Work(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: Work2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    Work2   = xyz_Flux + Work
    xyz_Flux = Work2

  end subroutine StorePotTempFlux

  function a_MeanXY_aaa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)  :: var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(DP)              :: a_MeanXY_aaa(DimZMin:DimZMax)
                                     !ʿʿ
    real(DP)              :: aa_work(DimYMin:DimYMax,DimZMin:DimZMax)
                                     !ʿʿ

    aa_work = aa_MeanX_aaa(var)

    a_MeanXY_aaa = sum( aa_work(RegYMin:RegYMax, :), 1 ) &
      &           / real(RegYMax - RegYMin + 1, 8) 


  end function a_MeanXY_aaa

  function aa_MeanX_aaa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)  :: var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(DP)             :: aa_MeanX_aaa(DimYMin:DimYMax,DimZMin:DimZMax)
                                     !ʿʿ

    aa_MeanX_aaa = sum( var(RegXMin:RegXMax, :, :), 1 ) &
      &           / real(RegXMax - RegXMin + 1 , 8) 

  end function aa_MeanX_aaa
  
  
end module StorePotTemp_3d
