!= Module HeatFlux_3d
!
! Authors::   ODAKA Masatsugu 
! Version::   $Id: heatflux_3d.f90,v 1.2 2007-10-01 08:57:59 odakker Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
! Υեåˤ벹٤ȶŷʬѲΨХ륯ˡ
! ŤƷ׻⥸塼.  (1994) Ѥ줿ˡǤ.
!
! Ǯեå Fh ȶŷʪΥեå Fq Ȥ, ٤ȶŷʪ
! ѲΨ H, Q 
!
!   H = Fh/z_1  
!   Q = Fq/z_1  
!
! ɽ.  z_1 ϺǲؤγʻҴֳ֤Ǥ.  
!
! Ǯեå Fh ȶŷʪΥեå Fq ϰʲμˤä
! ׻.
!
!   Fh = - Cd|V| * (_1_1 - T_sfc)
!   Fh = - Cd|V| * (Q_1 - Q*(T_sfc))
!
!  _1, Q_1, _1 Ϻǲؤβ٤ȶŷʪκ椪̵
! ϴؿ, T_sfc ϲβ, Q*(T_sfc)  T_sfc Ƿޤ˰º
! Ǥ. 
!
! Х륯 Cd ϰȤ. ̵ϴؿ _1 ϴܾͤѤ.
! ® |V| 
!
!   V = ( V^2 + V_0^2 )^(1/2)
!
! ȷ׻. 
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!
!== Future Plans
!
!

module HeatFlux_3d
  !
  !ǤΥեåη׻⥸塼
  !
  
  !⥸塼ɤ߹
  use gridset_3d,  only: DimXMin,         & !x β
    &                 DimXMax,         & !x ξ
    &                 DimYMin,         & !y β
    &                 DimYMax,         & !y ξ
    &                 DimZMin,         & !z β
    &                 DimZMax,         & !z ξ
    &                 RegZMin,         & !z ʪΰβ
    &                 z_dz               !z γʻֳ
  use basicset_3d, only: xyz_ExnerBasicZ  ,& !ʡؿδܾ
    &                 xyz_PotTempBasicZ,& !̤δܾ
    &                 TempSfc         ,& !ɽ̲
    &                 PressSfc        ,& !ɽ̰ [Pa]
    &                 CpDry           ,& !ʬ갵Ǯ [J/K kg]
    &                 GasRDry            !ʬε [J/K kg]

  use xyz_module, only:  xyz_avr_pyz, xyz_avr_xqz
  use chemcalc, only: SvapPress
  use StorePotTemp_3d,  only: StorePotTempFlux


  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public 
  public xyz_HeatFluxBulk
  public pyz_MomFluxBulk
  public xqz_MomFluxBulk

  !ѿ
!  real(8)  :: Bulk = 1.5d-3        !Ǯư̥եåΥХ륯
  real(8)  :: Bulk = 1.0d-2        !Ǯư̥եåΥХ륯

  !ͤ¸
  save Bulk

  interface pyz_MomFluxBulk
    module procedure aaz_MomFluxBulk
  end interface

  interface xqz_MomFluxBulk
    module procedure aaz_MomFluxBulk
  end interface


contains


!!!------------------------------------------------------------------------!!!
  function aaz_MomFluxBulk( Vel )
    ! 
    ! Υեåˤ뱿ư̤ѲΨ,
    ! Х륯ˡ˴ŤƷ׻.
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)   :: Vel(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                           !ʿ®
    real(8)               :: aaz_MomFluxBulk(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                           !ɽǮեå
    integer               :: kz            !ź


    !
    !  * Ƥͤ򥼥˸
    aaz_MomFluxBulk = 0.0d0
    
    !ɽ̱ư̥եåˤѲΨ׻
    !  * ñ̤ m/s^2
    !  * ʻ xz Ǥ, ʪΰκǲüź RegZMin+1

    kz = RegZMin

    aaz_MomFluxBulk(:,:,kz) =                                     &
      & MAX(                                                      &
      &       0.0d0,                                              & 
      &     - Bulk * abs(Vel(:,:,kz)) * Vel(:,:,kz) /z_dz(kz) )

  end function aaz_MomFluxBulk
  
!!!------------------------------------------------------------------------!!!
  function xyz_HeatFluxBulk( xyz_PotTemp, pyz_VelX, xqz_VelY )
    ! 
    ! Υեåˤ벹٤ѲΨ,
    ! Х륯ˡ˴ŤƷ׻.
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)   :: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                           !̤ξʬ    
    real(8), intent(in)   :: pyz_VelX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                           !ʿ®
    real(8), intent(in)   :: xqz_VelY(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                           !ʿ®
    real(8)               :: xyz_HeatFluxBulk(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                           !ɽǮեå
    real(8)               :: VelX = 0.0d0  !ؤǤοʿ®ٿ夲
    real(8)               :: TempGrndSfc = 270.0d0  ! 
    integer               :: kz            !ź

    real(8), allocatable  :: xyz_VelX(:,:,:)  !ʿ® (xyz ʻ)
    real(8), allocatable  :: xyz_VelY(:,:,:)  !ʿ® (xyz ʻ)


    !γդ
    allocate(xyz_VelX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax))
    allocate(xyz_VelY(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax))


    !
    !  * Ƥͤ򥼥˸
    xyz_HeatFluxBulk = 0.0d0
    
    !ɽǮեåˤǮΨ׻
    !  * ñ̤ K/s
    !  * ʡؿϴܾͤɽ.     
    !  * ʻ xz Ǥ, ʪΰκǲüź RegZMin+1

    kz = RegZMin
    xyz_VelX = xyz_avr_pyz(pyz_VelX)
    xyz_VelY = xyz_avr_xqz(xqz_VelY)

    xyz_HeatFluxBulk(:,:,kz) =                                    &
      & MAX(                                                      &
      &       0.0d0,                                              & 
      &     - Bulk                                                &
      &       * SQRT( (xyz_VelX(:,:,kz) + VelX)**2.0              &
      &               + xyz_VelY(:,:,kz)**2.0 )                   &
      &       * (xyz_ExnerBasicZ(:,:,kz)                          &
      &            * (xyz_PotTemp(:,:,kz)  + xyz_PotTempBasicZ(:,:,kz)) &
      &          - TempGrndSfc                                    &
      &         )/z_dz(kz)                                        &
      &    )

    call StorePotTempFlux( xyz_HeatFluxBulk )

    !β
    deallocate(xyz_VelX)
    deallocate(xyz_VelY)
   
  end function xyz_HeatFluxBulk

end module HeatFlux_3d
