!= Module MoistFunc_3d
!
! Authors::   SUGIYAMA Ko-ichiro ODAKA Masatsugu
! Version::   $Id: moistfunc_3d.f90,v 1.1 2008-06-19 16:53:25 odakker Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ʷ׻ġ뷲
!   * 麮Ѵ
!   * 椫麮Ѵ
!   * 椫Ѵ
!   * 椫Ѵ
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module MoistFunc_3d
  !
  !ñ̤δԤΥѥå⥸塼
  !   * 麮Ѵ
  !   * 椫麮Ѵ
  !   * 椫Ѵ
  !   * 椫Ѵ
  ! 

  !⥸塼ɤ߹
  use dc_types,       only : STRING, DP

  use gridset_3d, only : DimXMin, DimXMax,   & !x β¤Ⱦ
    &                    DimYMin, DimYMax,   & !y β¤Ⱦ
    &                    DimZMin, DimZMax      !z β¤Ⱦ
  use basicset_3d,only : PressBasis,         & !̤ɸవ         [Pa]
    &                    CpDry,              & !ʬʿ갵Ǯ [J/K kg]
    &                    MolWtDry,           & !ʬʿʬ   [kg/mol]
    &                    GasRDry               !ʬε     [J/K kg]
  use ChemCalc_3d,only : xyz_DSvapPressDTemp   !˰¾βʬ

  !ۤηػ
  implicit none 
  
  !°λ
  private

  !ؿ public ˻
  public xyz_DMixRtSatDPotTemp
  public xyz_DelMixRtNH4SH
  public DelMolFrNH4SH

contains

!!!
!!!ܴؿ
!!!

!!!-----------------------------------------------------------------------!!!
  function xyz_DMixRtSatDPotTemp(SpcID, MolWt, xyz_TempAll, xyz_ExnerAll)
    !
    !˰¾  ʬԤ
    !ºݤˤ, dq/dp * dp/dT * dT/d ¹. (â p ˰¾)
    !

    !ۤηػ
    implicit none 
    
    !ѿ
    integer, intent(in) :: SpcID
    real(DP),intent(in) :: MolWt
    real(DP),intent(in) :: xyz_TempAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                            !( + ܾ)
    real(DP),intent(in) :: xyz_ExnerAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                            !ʡؿ( + ܾ)
    real(DP)            :: xyz_PressAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                            !( + ܾ)
    real(DP)            :: xyz_DMixRtSatDPotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                           
    xyz_DMixRtSatDPotTemp   = 0.0d0
    xyz_PressAll = PressBasis * (xyz_ExnerAll ** (CpDry / GasRDry))
    
    xyz_DMixRtSatDPotTemp =                            &
      &   MolWt / ( MolWtDry * xyz_PressAll )          &
      & * xyz_DSvapPressDTemp(SpcID, xyz_TempAll)       &
      & * xyz_ExnerAll
    
  end function xyz_DMixRtSatDPotTemp


!!!-----------------------------------------------------------------------!!!
  function xyz_DelMixRtNH4SH(xyz_TempAll, xyz_PressAll, xyz_MixRtNH3, xyz_MixRtH2S, &
    &                    MolWtNH3, MolWtH2S)
    !
    ! NH4SH ȿȼ, NH4SH ()
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP),intent(in) :: xyz_TempAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                         !
    real(DP),intent(in) :: xyz_PressAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                         !
    real(DP),intent(in) :: xyz_MixRtNH3(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                         !NH3 κ
    real(DP),intent(in) :: xyz_MixRtH2S(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                         !H2S κ
    real(DP),intent(in) :: MolWtNH3      !NH3 ʬ
    real(DP),intent(in) :: MolWtH2S      !H2S ʬ

    real(DP) :: xyz_DelMixRtNH4SH(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                         !NH4SH κ
    real(DP) :: xyz_EquivConst(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                         !ʿ
    real(DP) :: xyza_PartialPress(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,2)
                                         !(ʬ)
    real(DP) :: xyz_Solution(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                         !(β)

    !
    xyz_DelMixRtNH4SH = 0.0d0

    !˥βǤʬ. 
    xyza_PartialPress(:,:,:,1) = xyz_MixRtNH3 * xyz_PressAll * MolWtDry / MolWtNH3 
    xyza_PartialPress(:,:,:,2) = xyz_MixRtH2S * xyz_PressAll * MolWtDry / MolWtH2S      
    
    !ʿ
    xyz_EquivConst = 61.781d0 - 10834.0d0 / xyz_TempAll - dlog(1.0d2)
    
    !Ѳ. 
    !  (P_NH3 - X) * (P_H2S - X) = exp(Kp)
    !  DelX^2 - (P_NH3 + P_H2S) * DelX + P_NH3 * P_H2S * exp( Kp ) = 0
    !  Ȥɬפ뤬, P_NH3 > P_H2S  X < P_H2S 
    !  θ, θΤ򤵤.
    xyz_Solution  =                                                   &
      & (                                                            &
      &     sum(xyza_PartialPress, 4)                                        &
      &   - dsqrt( (xyza_PartialPress(:,:,:,1) - xyza_PartialPress(:,:,:,2)) ** 2.0d0 &
      &            + 4.0d0 * dexp( min( 700.0d0, xyz_EquivConst ) ) ) &
      &  ) * 5.0d-1

    !̤
    xyz_DelMixRtNH4SH = xyz_Solution * ( MolWtNH3 + MolWtH2S ) &
      &                   / ( xyz_PressAll * MolWtDry )

  end function xyz_DelMixRtNH4SH
  

!!!-----------------------------------------------------------------------!!!
  function DelMolFrNH4SH(TempAll, PressAll, MolFrNH3, MolFrH2S, Humidity)
    !
    ! NH4SH ȿȼ H2S  NH3 Υθʬ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP),intent(in) :: TempAll       !
    real(DP),intent(in) :: PressAll      !
    real(DP),intent(in) :: MolFrNH3      !NH3 Υ
    real(DP),intent(in) :: MolFrH2S      !H2S Υ
    real(DP),intent(in) :: Humidity      !˰
    real(DP)            :: DelMolFrNH4SH !NH4SH ȼѲ
    real(DP)            :: EquivConst    !ʿ
    real(DP)            :: PPress(2)     !(ʬ)
    real(DP)            :: Solution      !(β)

    !------------------------------------------------------------
    !NH4SH ʿվ
    !------------------------------------------------------------
    !˥βǤʬ
    PPress(1) = MolFrNH3 * PressAll
    PPress(2) = MolFrH2S * PressAll

    !ʿ
    EquivConst = 61.781d0 - 10834.0d0 / TempAll - dlog(1.0d2) - 2.0d0 * dlog( Humidity )
    
    !ѲβȤƵ. 
    Solution = 5.0d-1 * (sum(PPress) &
      &        - dsqrt( (PPress(1) - PPress(2))**2.0d0 &
      &                    + 4.0d0 * dexp( min( 700.0d0, EquivConst ))) )
    
    !NH4SH . 
    DelMolFrNH4SH = Solution / PressAll

  end function DelMolFrNH4SH

end module MoistFunc_3d
