!= Module MoistBuoyancy_3d
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: moistbuoyancy_3d.f90,v 1.1 2008-06-19 16:53:24 odakker Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!
!== Future Plans
!
!

module MoistBuoyancy_3d
  !
  !
  !

  !⥸塼ɤ߹ 
  use dc_types, only : DP
  use dc_message, only: MessageNotify

  use gridset_3d, only:  SpcNum,            &! ؼο
    &                 DimXMin,           &! x β
    &                 DimXMax,           &! x ξ
    &                 DimYMin,           &! y β
    &                 DimYMax,           &! y ξ
    &                 DimZMin,           &! z β
    &                 DimZMax,           &! z ξ
    &                 x_dx,              &! x γʻֳ
    &                 y_dy,              &! y γʻֳ
    &                 z_dz                ! z γʻֳ
  use basicset_3d, only: MolWtDry,          &!ʬʬ
    &                 Grav,              &!ϲ®
    &                 SpcWetID,          &!ŽʬID
    &                 MolWtWet,          &!Žʬʬ
    &                 CpDry,             &!ʬʿ갵Ǯ [J/K kg]
    &                 xyz_PotTempBasicZ,  &!ܾβ
    &                 xyz_EffMolWtBasicZ, &!ܾʬ̸
    &                 xyz_ExnerBasicZ,    &!̵ܾ
    &                 xyza_MixRtBasicZ     !ܾκ
  use moistset, only: CondNum,          &!ŷο
    &                 IdxCG,            &!ŷ()ź
    &                 IdxCC,            &!ŷ()ź
    &                 GasNum,           &!Το
    &                 IdxG,             &!Τź
    &                 IdxNH3,           &!NH3()ź
    &                 IdxH2S             !H2S()ź
  use ChemCalc_3d, only: xyz_LatentHeat,    &!Ǯ
    &                 ReactHeatNH4SH     !NH4SH ȿǮ
  use xyz_base_module, only : xyz_avr_xyr, xyr_avr_xyz
  use xyz_deriv_module,only : xyr_dz_xyz

  use StoreBuoy_3d,    only: StoreBuoyMolWt, StoreBuoyDrag

  !ۤηػ
  implicit none
  
  !°λ
  private
  
  !ؿ public 
  public MoistBuoy_Init
  public xyz_BuoyMoistKm
  public xyr_BuoyMolWt
  public xyr_BuoyDrag

  !ѿ
  real(DP)     :: Cm           = 2.0d-1
  real(DP)     :: MixLen       = 0.0d0
  real(DP), allocatable :: xyz_MixRtBasicZPerMolWt(:,:,:)
                              !ܾκ / ʬ 
  real(DP), allocatable :: xyr_MixRtBasicZPerMolWt(:,:,:)
                              !ܾκ / ʬ 
  real(DP), allocatable :: xyz_MixRtBasicZ(:,:,:)
                              !ܾκ
  real(DP), allocatable :: xyr_MixRtBasicZ(:,:,:)
                              !ܾκ
  
  save Cm, MixLen
  save xyz_MixRtBasicZPerMolWt
  save xyr_MixRtBasicZPerMolWt
  save xyz_MixRtBasicZ
  save xyr_MixRtBasicZ 

contains

!!!------------------------------------------------------------------!!!
  subroutine MoistBuoy_Init( )

    !ۤηػ
    implicit none

    !ѿ
    integer              :: s
    real(DP), allocatable :: xyza_MixRtBasicZPerMolWt(:,:,:,:)
                                  !ܾκ / ʬ
    real(DP) :: MinDelX
    real(DP) :: MinDelY
    real(DP) :: MinDelZ

    !-----------------------------------------------------------
    ! Υ
    !-----------------------------------------------------------

    !Υ
    MinDelX = minval(x_dx)
    MinDelY = minval(y_dy)
    MinDelZ = minval(z_dz)

!    MixLen = ( MinDelX * MinDelY * MinDelZ ) ** (1.0d0/3.0d0)

    MixLen = min( MinDelZ, min( MinDelX, MinDelY ) )

    !-----------------------------------------------------------
    ! ν. 
    !-----------------------------------------------------------
    allocate( &
      & xyza_MixRtBasicZPerMolWt(DimXMin:DimXMax,DimYMin:DimYMax, DimZMin:DimZMax, GasNum),  &
      & xyr_MixRtBasicZPerMolWt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),           &
      & xyz_MixRtBasicZPerMolWt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),           &
      & xyr_MixRtBasicZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),                   &
      & xyz_MixRtBasicZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)                    &
      & )

    xyza_MixRtBasicZPerMolWt = 0.0d0
    xyr_MixRtBasicZPerMolWt = 0.0d0
    xyz_MixRtBasicZPerMolWt = 0.0d0
    xyr_MixRtBasicZ = 0.0d0
    xyz_MixRtBasicZ = 0.0d0

    call MessageNotify( "M", &
      & "MoistBuoy_Init", "MolWtWet = %f", d=(/pack(MolWtWet(:), .true.) /) )

    do s = 1, GasNum
      xyza_MixRtBasicZPerMolWt(:,:,:,s) = &
        & xyza_MixRtBasicZ(:,:,:,IdxG(s)) / MolWtWet(IdxG(s))
    end do

    xyz_MixRtBasicZPerMolWt = sum(xyza_MixRtBasicZPerMolWt, 4) 
    xyr_MixRtBasicZPerMolWt = xyr_avr_xyz( sum(xyza_MixRtBasicZPerMolWt, 4) )
    xyz_MixRtBasicZ         = sum(xyza_MixRtBasicZ, 4) 
    xyr_MixRtBasicZ         = xyr_avr_xyz( sum(xyza_MixRtBasicZ, 4) )     
    
  end subroutine MoistBuoy_Init


!!!------------------------------------------------------------------------!!!
  function xyz_BuoyMoistKm(xyz_PotTemp, xyz_Exner, xyza_MixRt)
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !
    real(DP), intent(in) :: xyz_Exner(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !̵
    real(DP), intent(in) :: xyza_MixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(DP) :: xyza_MixRtAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(DP) :: xyza_MixRtAll2(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(DP) :: xyz_BuoyMoistKm(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !
    real(DP) :: xyza_LatentHeat(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, GasNum)
                                               !Ǯ
    real(DP) :: xyz_TempAll(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !
    real(DP) :: xyz_EffHeat(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !
    real(DP) :: xyz_EffPotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)    
                                               !ϤФ벹ٺδͿ
    real(DP) :: xyz_EffMolWt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)    
                                               !ϤФʬ̺δͿ
    real(DP) :: xyza_MixRtPerMolWt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, GasNum)
                                               !/ʬ
    integer              :: s
    
    
    !, , ̤
    !ʬʿʬ­
    xyz_TempAll = ( xyz_PotTemp + xyz_PotTempBasicZ ) * ( xyz_Exner + xyz_ExnerBasicZ )
    xyza_MixRtAll = xyza_MixRtBasicZ + xyza_MixRt
    xyza_LatentHeat = 0.0d0
    
    !ν. ΤΤ
    do s = 1, GasNum
      xyza_MixRtPerMolWt(:,:,:,s) = xyza_MixRt(:,:,:,IdxG(s)) / MolWtWet(IdxG(s))
    end do
    
    !٤θ
    xyz_EffPotTemp = xyz_PotTemp / xyz_PotTempBasicZ 
    
    !ʬ̸ + Ťθ
    xyz_EffMolWt =                                           &
      & + sum(xyza_MixRtPerMolWt, 4)                         &
      &    / ( 1.0d0 / MolWtDry + xyz_MixRtBasicZPerMolWt )  &
      & - sum(xyza_MixRt, 4) / ( 1.0d0 + xyz_MixRtBasicZ )
    
    !ȯǮ׻
    !  ʬ̤ʬϤĤǤǮ˰¤ƤʤȸʤΤ, 
    !  κ椬λˤ, ǮδͿϥȤʤ褦ĴᤷƤ
    xyza_MixRtAll2 = xyza_MixRtAll
!    xzya_MixRtAll2(:,:,:,IdxNH3) = &
!      &  xyza_MixRtAll(:,:,:,IdxNH3) - xyza_MixRtAll(:,:,:,IdxH2S) 

    do s = 1, CondNum
      xyza_LatentHeat(:,:,:,s) =                             &
        & xyz_LatentHeat( SpcWetID(IdxCC(s)), xyz_TempAll )  &
        &  * xyza_MixRtAll2(:,:,:,IdxCG(s))                    &
        &  * ( 5.0d-1 + sign( 5.0d-1, (xyza_MixRtAll2(:,:,:,IdxCC(s)) - 1.0d-4) ) )
    end do

    xyz_EffHeat = ( sum( xyza_LatentHeat, 4 ) * xyz_EffMolWtBasicZ &
!      &            + ReactHeatNH4SH * &
!      &            (xyza_MixRtAll(:,:,:,IdxH2S) + xyza_MixRtAll(:,:,:,IdxH2S)) &
      &          ) / ( CpDry * xyz_ExnerBasicZ ) 
    
    !ήȻλȯŸϹ
    xyz_BuoyMoistKm = &
      &  - 3.0d0 * Grav * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 )     &
      &    * xyz_avr_xyr(                                           &
      &        xyr_dz_xyz(                                          &
      &           xyz_EffHeat                                       &
      &         + xyz_PotTempBasicZ / xyz_EffMolWtBasicZ            &
      &           * ( 1.0d0 + xyz_EffPotTemp + xyz_EffMolWt )       &
      &         )                                                   &
      &      )                                                      &
      &    / ( 2.0d0 * xyz_PotTempBasicZ / xyz_EffMolWtBasicZ)                   

  end function xyz_BuoyMoistKm
    

!!!------------------------------------------------------------------------!!!
  function xyr_BuoyMolWt(xyza_MixRt)
    !
    ! ľαư˸ϹΤ, 
    ! ʬ̤θ̤
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)  :: xyza_MixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(DP) :: xyr_BuoyMolWt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !Ϲ(ʬ̸)
    real(DP) :: xyza_MixRtPerMolWt(DimXMin:DimXMax,DimYMin:DimYMax, DimZMin:DimZMax, GasNum)
                                               !/ʬ
    integer              :: s
    
    !
    xyr_BuoyMolWt           = 0.0d0
    
    !ν. ΤΤ
    do s = 1, GasNum
      xyza_MixRtPerMolWt(:,:,:,s) = xyza_MixRt(:,:,:,IdxG(s)) / MolWtWet(IdxG(s))
    end do
    
    !Ϲη׻
    xyr_BuoyMolWt =                                               &
      & + Grav * xyr_avr_xyz( sum(xyza_MixRtPerMolWt, 4) )        &
      &    / ( 1.0d0 / MolWtDry + xyr_MixRtBasicZPerMolWt )       &
      & - Grav * xyr_avr_xyz( sum(xyza_MixRt(:,:,:,1:GasNum), 4) )&
      &    / ( 1.0d0 + xyr_MixRtBasicZ )

    call StoreBuoyMolWt(xyz_avr_xyr(xyr_BuoyMolWt))

  end function xyr_BuoyMolWt


!!!------------------------------------------------------------------------!!!
  function xyr_BuoyDrag(xyza_MixRt) 
    !
    ! ľαư˸ϹΤ, 
    ! ŤΤθ̤
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)  :: xyza_MixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(DP) :: xyr_BuoyDrag(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !Ϲ(ʬ̸)
    !
    xyr_BuoyDrag           = 0.0d0

    !Ϲη׻
    xyr_BuoyDrag =                                                     &
      & - Grav * xyr_avr_xyz( sum(xyza_MixRt(:,:,:,GasNum+1:SpcNum), 4) ) &
      &    / ( 1.0d0 + xyr_MixRtBasicZ )

    call StoreBuoyDrag(xyz_avr_xyr(xyr_BuoyDrag))
    
  end function xyr_BuoyDrag
  
end module MoistBuoyancy_3d
