!= Module NumDiffusion
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: numdiffusion.f90,v 1.1 2009-03-05 05:39:43 yamasita Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ή׻. 
!ͳȻη׻⥸塼
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module NumDiffusion
  !
  !ͳȻη׻⥸塼
  !ߤ 2 濴ʬ
  !

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  use gridset, only:  DimXMin,           &! x β
    &                 DimXMax,           &! x ξ
    &                 DimZMin,           &! z β
    &                 DimZMax,           &! z ξ
    &                 SpcNum,            &!
    &                 DelX,              &! X γʻֳ
    &                 DelZ                ! Z γʻֳ
  use timeset, only:  DelTimeLong         !Ĺ֥ƥå
!  use differentiate_center2, only: xz_dx_pz, xz_dz_xr, &
!    &                              xr_dx_pr, xr_dz_xz, &
!    &                              pz_dx_xz, pz_dz_pr, &
!    &                              pr_dx_xr, pr_dz_pz
  use differentiate_center4, only: xz_dx_pz, xz_dz_xr, &
    &                              xr_dx_pr, xr_dz_xz, &
    &                              pz_dx_xz, pz_dz_pr, &
    &                              pr_dx_xr, pr_dz_pz
  use StorePotTemp, only: StorePotTempDiff
  use StoreMixRt,   only: StoreMixRtDiff

  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public ˤ
  public NumDiffusion_Init
  public xz_NumDiffScalar
  public xz_NumDiffKm
  public xza_NumDiffScalar
  public pz_NumDiffVelX
  public xr_NumDiffVelZ

  !ѿ
  real(8)  :: NuH   = 0.0d0   !Ǵη (ʿ)
  real(8)  :: NuV   = 0.0d0   !Ǵη (ľ)
!!  real(8)  :: Alpha = 1.0d-4
  real(8)  :: Alpha = 5.0d-4  ! ̼׻ǥե
!  real(8)  :: Alpha = 2.5d-4
!  real(8)  :: Alpha = 1.0d-3
!  real(8)  :: Alpha = 2.0d-3

  save NuH, NuV, Alpha

contains

!!!-------------------------------------------------------------------!!!
  subroutine NumDiffusion_init()
    !
    ! NumDiffusion ⥸塼ν롼
    !

    !ۤηػ
    implicit none
    
    ! CReSS ޥ˥奢Ǥ, 2 濴ʬξ, Alpha < 1/8 餤ŬȽҤ٤Ƥ. 
    ! deepconv Ǥ NuH Ȥ 500 ʾͤäƤ,
    NuH  = Alpha * ( DelX ** 2.0d0 ) / DelTimeLong
    NuV  = Alpha * ( DelZ ** 2.0d0 ) / DelTimeLong
    
    !ǧ
    call MessageNotify( "M", "NumDiffusion_init", "NuH = %f", d=(/NuH/) )
    call MessageNotify( "M", "NumDiffusion_init", "NuV = %f", d=(/NuV/) )

  end subroutine NumDiffusion_init

!!!-------------------------------------------------------------------!!!
  function xz_NumDiffScalar(xz_Scalar)
    !
    ! x, z ȾʻҤ줿ǤοͳȻɾ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_Scalar(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !顼
    real(8)             :: xz_NumDiffScalar(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ʿοͳȻ
    
!    xz_NumDiffScalar = 0.0d0  !
    xz_NumDiffScalar =   &
      &    NuH * (xz_dx_pz(pz_dx_xz( xz_Scalar ))) &
      &  + NuV * (xz_dz_xr(xr_dz_xz( xz_Scalar ))) 

!    xz_NumDiffScalar = xr_dz_xz( xz_Scalar ) 
!    xz_NumDiffScalar = NuH 

    
    call StorePotTempDiff( xz_NumDiffScalar )

  end function xz_NumDiffScalar


!!!-------------------------------------------------------------------!!!
  function xz_NumDiffKm(xz_Scalar)
    !
    ! x, z ȾʻҤ줿ǤοͳȻɾ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xz_Scalar(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !顼
    real(8)             :: xz_NumDiffKm(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ʿοͳȻ
    
    xz_NumDiffKm =   &
      &    NuH * (xz_dx_pz(pz_dx_xz( xz_Scalar ))) &
      &  + NuV * (xz_dz_xr(xr_dz_xz( xz_Scalar ))) 
    
  end function xz_NumDiffKm


!!!-------------------------------------------------------------------!!!
  function xza_NumDiffScalar(xza_Scalar)
    !
    ! x, z ȾʻҤ줿ǤοͳȻɾ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in) :: xza_Scalar(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                                    !顼
    real(8)             :: xza_NumDiffScalar(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                                    !ʿοͳȻ
    integer             :: s
    

    do s = 1, SpcNum
      xza_NumDiffScalar(:,:,s) =   &
        &    NuH * (xz_dx_pz(pz_dx_xz( xza_Scalar(:,:,s) ))) &
        &  + NuV * (xz_dz_xr(xr_dz_xz( xza_Scalar(:,:,s) ))) 
    end do

    call StoreMixRtDiff( xza_NumDiffScalar )

  end function xza_NumDiffScalar


!!!-------------------------------------------------------------------!!!
  function pz_NumDiffVelX(pz_VarX)
    !
    ! z ȾʻҤ줿ǤοͳȻɾ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_VarX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ʪ
    real(8)             :: pz_NumDiffVelX(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ͳȻ
    
!    pz_NumDiffVelX = 0.0d0  !
    pz_NumDiffVelX = &
      &   NuH * ( pz_dx_xz( xz_dx_pz( pz_VarX ) ) ) &
      & + NuV * ( pz_dz_pr( pr_dz_pz( pz_VarX ) ) )
    
  end function pz_NumDiffVelX
  

!!!-------------------------------------------------------------------!!!  
  function xr_NumDiffVelZ(xr_VarZ)
    !
    ! x ȾʻҤ줿ǤοͳȻɾ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: xr_VarZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ʪ
    real(8)             :: xr_NumDiffVelZ(DimXMin:DimXMax, DimZMin:DimZMax)
                                                    !ͳȻ

!    xr_NumDiffVelZ = 0.0d0 
    xr_NumDiffVelZ = &
      &   NuH * ( xr_dx_pr( pr_dx_xr( xr_VarZ ) ) ) &
      & + NuV * ( xr_dz_xz( xz_dz_xr( xr_VarZ ) ) )
    
  end function xr_NumDiffVelZ

end module NumDiffusion
