!= Module ArgSet
!
! Authors::   ODAKA Masatsugu
! Version::   $Id: argset.f90,v 1.1 2009-03-05 05:39:43 yamasita Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ޥɥ饤βԤ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module argset
  !
  !

  !⥸塼ɤ߹
  use dc_types,       only : STRING, DP
  use dc_string,      only : StoA
  use dc_args,        only : ARGS, Open, Debug, Help, Strict, Close, Option
  use dc_message,     only : MessageNotify

  !ۤηػ
  implicit none

  !save °
  save

  !ѿ
  !-----   ޥɥ饤ѿ    -----
  type(ARGS)           :: arg             ! ޥɥ饤
  logical              :: OPT_namelist    ! ޥɥ饤ѿ
  character(STRING)    :: VAL_namelist    ! ޥɥ饤


contains

  subroutine argset_init(cfgfile)
    !
    !ޥɥ饤ᤷ, Ϳ줿 NAMELIST ե̾
    !֤. 
    !

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(out) :: cfgfile

    !NAMELIST եμ
    !  gt4f90io 饤֥ dc_args ⥸塼.
    !  ǽʥץϰʲ̤.
    !
    !  -N=VAL, --namelist=VAL
    !    specify Namelist file (default is 'arare.conf'). 
    !
    !  -D=VAL, --debug=VAL
    !    call dc_trace#SetDebug (display a lot of messages for debug).
    !    VAL is unit number (default is standard output)
    !
    !  -h=VAL, -H=VAL, --help=VAL
    !    display this help and exit. VAL is unit number (default is
    !    standard output)
    !
    call Open(arg)
    call Option(arg, StoA('-N', '--namelist'), &
      &         OPT_namelist, VAL_namelist, &
      &         help="specify Namelist file (default is 'arare.conf')." )
                      ! "-N/--namelist" ץ
    call Debug(arg)   ! ǥХåץμư
    call Help(arg)    ! إץץμư
    call Strict(arg)  ! ̵ʥץ˷ٹɽ

    !"-N/-namelist" ץβ
    !  ͿƤʤϥǥե (arare.conf)  
    !  NAMLIST ե̾Ȥ.
    !
    if (OPT_namelist) then
      call MessageNotify( "M", "main", &
        &                 "Namelist file is '%c'", c1=trim(VAL_namelist) )
      cfgfile=trim(VAL_namelist)
    else
      call MessageNotify( "W", "main", &
        &                 "Namelist file is not specified." )
      call MessageNotify( "M", "main", &
        &                 "Use default Namelist file (arare.conf)." )
      cfgfile="arare.conf"
    end if

    call Close(arg)

    ! ǧ
    call MessageNotify( "M",                  &
      &                 "argset_init",        &
      &                 "NAMELIST FILE = %c", &
      &                 c1=cfgfile )


  end subroutine argset_init
end module argset
