!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Subroutine SaturationRatio
!
!   * Developer: KITAMORI Taichi 
!   * Version: $ 
!   * Tag Name: $Name: arare4-20100306 $
!   * Change History: 
!
!== Overview 
!
!ή׻. 
!˰׻. 
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!
!
!
!== Future Plans
!
                                                                 !=end
subroutine SaturationRatio(xz_Exner,  &   !(in)
  &                        xz_PotTemp, &  !(in)
  &                        xz_SatRatio)   !(out)
                                                                 !=begin
  !== Dependency
  use dc_trace, only:  BeginSub, EndSub
  use gridset,  only:  DimXMin, DimXMax, DimZMin, DimZMax
  use basicset, only:  xz_ExnerBasicZ, &
    &                  xz_PotTempBasicZ, &
    &                  GasRDry,          &
    &                  CpDry,            &
    &                  PressSfc
  use ChemData, only: ChemData_Cp,     &   ! 갵Ǯ
    &                 ChemData_SVapPress_AntoineA, & ! Antoine μη A
    &                 ChemData_SVapPress_AntoineB    ! Antoine μη B
!  use physset,  only:  GasR, &
!    &                  PressSfc
!  use cloudset, only:  SatPressA,   &
!    &                  SatPressB

  !== Input
  real(8), intent(in)   :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8), intent(in)   :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)

  !== Output
  real(8), intent(out)  :: xz_SatRatio(DimXMin:DimXMax, DimZMin:DimZMax)
                                                                 !=end

  call BeginSub("SaturationRatio", &
    &           fmt="%c",        &
    &           c1="Calculate saturation ratio.")

  xz_SatRatio =  &
!    &  PressSfc * (xz_ExnerBasicZ + xz_Exner)**(ChemData_Cp / GasRDry) &
    &  PressSfc * (xz_ExnerBasicZ + xz_Exner)**(CpDry / GasRDry) &
    &  * (  exp(  &
    &           - ChemData_SVapPress_AntoineA(12) &
    &           + ChemData_SVapPress_AntoineB(12) &
    &             / ( (xz_ExnerBasicZ + xz_Exner) &
    &                 *  (xz_PotTempBasicZ + xz_PotTemp) )&
    &          )  &
    &    ) 

!  xz_SatRatio =  &
!    &  PressSfc * (xz_ExnerBasicZ + xz_Exner)**(xz_CpBasicZ / GasR) &
!    &  * (  exp(  &
!    &           - SatPressA &
!    &           + SatPressB  &
!    &             / ( (xz_ExnerBasicZ + xz_Exner) &
!    &                 *  (xz_PotTempBasicZ + xz_PotTemp) )&
!    &          )  &
!    &    ) 

  call EndSub("SaturationRatio")

end subroutine SaturationRatio
