!= Module Radiation
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: radiation_balance.f90,v 1.1 2009-03-05 05:39:42 yamasita Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ή׻. 
!ǥͲ׻뤿Υѥå⥸塼
!Ūˤϰʲι׻뤿δؿǼ.  
!  * ѡͲǮ
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!ѤȰͲǮХ󥹤. 
!
!== Future Plans
!
!

module Radiation
  !
  !ǥͲ׻뤿Υѥå⥸塼
  !Ūˤϰʲι׻뤿δؿǼ.  
  !  * ѡͲǮ
  !

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  use GridSet,  only: DimXMin,     & !x β
    &                 DimXMax,     & !x ξ
    &                 DimZMin,     & !z β
    &                 DimZMax,     & !z ξ
    &                 RegXMin,     & !x β
    &                 RegXMax,     & !x ξ
    &                 RegZMin,     & !z β
    &                 RegZMax,     & !z ξ
    &                 s_Z,         & !Z ɸ(顼ʻ)
    &                 DelZ           !ʻҴֳ
  use TimeSet,  only: DayTime        ! 1 Ĺ [s]
  use basicset, only: xz_ExnerBasicZ, & !ʡؿδܾ
    &                 xz_PressBasicZ, & !Ϥδܾ
    &                 xz_PotTempBasicZ, & !̤δܾ
    &                 PressSfc,       & !ɽ̰
    &                 CpDry,          & !갵Ǯ
    &                 GasRDry,        & !
    &                 Grav              !ϲ®
  use StorePotTemp,  only: StorePotTempRad, StorePotTempDamp
  
  !ۤηػ
  implicit none

  !private °
  private

  !ؿ public ˤ. 
  public Radiation_init
  public xz_RadHeatConst
  public xz_RadHeatBalance
  public xz_NewtonCool

  !ѿ
  real(8)              :: RadHeatRate  = 0.0d0 !ͲǮΨ [K/day]
  real(8), allocatable :: xz_RadHeight(:,:)    !ͲǮ¸ߤΰ
  real(8)              :: RadHeatRate2  = 0.0d0 !ͲǮΨ [K/day]
  real(8), allocatable :: xz_RadHeight2(:,:)    !ͲǮ¸ߤΰ
  real(8)              :: HeatWork      !ˤ
                                        !ñ̻֤βǮ()
  integer              :: IntHeightUp   !Ǯ¤αľɸб
                                        !
  integer              :: IntHeightUp2   !Ѱ¤αľɸб
                                         !
  real(8)                  :: RadHeightUp   !ͶͿľΰξ
  real(8)                  :: RadHeightDown !ͶͿľΰβ
  real(8)                  :: RadHeightUp2   !ͶͿľΰξ
  real(8)                  :: RadHeightDown2 !ͶͿľΰβ
  
  !save °
!  save RadHeatRate, xz_RadHeight
  save RadHeatRate, xz_RadHeight, RadHeatRate2, xz_RadHeight2, HeatWork
  save IntHeightUp, IntHeightUp2, RadHeightUp, RadHeightDown, RadHeightUp2, RadHeightDown2

contains

!!!------------------------------------------------------------------------!!!
  subroutine Radiation_init(cfgfile)
    !
    !NAMELIST Ͷ
    !

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile
    real(8)                  :: PressHeightUp   !Ͷΰ¤δܾ찵
                                                !1֤ˤ껻
!    real(8)                  :: RadHeightUp   !ͶͿľΰξ
!    real(8)                  :: RadHeightDown !ͶͿľΰβ
!    real(8)                  :: RadHeightUp2   !ͶͿľΰξ
!    real(8)                  :: RadHeightDown2 !ͶͿľΰβ
    integer                  :: k             !롼ѿ


    ! NAMELIST 
    NAMELIST /radiation/ RadHeatRate, RadHeightUp, RadHeightDown, RadHeatRate2, RadHeightUp2, RadHeightDown2

    open (10, FILE=cfgfile)
    read(10, NML=radiation)
    close(10)

    allocate( xz_RadHeight(DimXMin:DimXMax, DimZMin:DimZMax) )
    allocate( xz_RadHeight2(DimXMin:DimXMax, DimZMin:DimZMax) )

    ! IntHeightUp 
    do k = DimZMin, DimZMax
      if ( (RadHeightUp - DelZ <= s_Z(k)) .and. (s_Z(k) < RadHeightUp) ) then
        IntHeightUp = k
      else if ( (RadHeightUp2 - DelZ <= s_Z(k)) .and. (s_Z(k) < RadHeightUp2) ) then
        IntHeightUp2 = k
      end if
    end do

    ! PressHeightUp λ
    PressHeightUp =  xz_PressBasicZ(1,IntHeightUp) +  &
     & ( xz_PressBasicZ(1,IntHeightUp + 1) - xz_PressBasicZ(1,IntHeightUp) ) &
     & * ( RadHeightUp - s_Z(IntHeightUp) ) / DelZ


    ! HeatWork λ
    HeatWork = CpDry * RadHeatRate * ( PressSfc - PressHeightUp ) / Grav


    ! Ͷ¸ߤΰ
    ! RadHeightDown < s_Z < RadHeightUp ϰϤǤͤ 1 Ȥʤ
    ! Ѱդ.
    !
    xz_RadHeight = 1.0d0    
    xz_RadHeight2 = 1.0d0    

    do k = DimZMin, DimZMax
      if ( s_Z(k) <= RadHeightDown  ) then
        xz_RadHeight(:,k) = 0.0d0 
      elseif( s_Z(k) >= RadHeightUp ) then
        xz_RadHeight(:,k) = 0.0d0 
      end if
    end do

    do k = DimZMin, DimZMax
      if ( s_Z(k) <= RadHeightDown2  ) then
        xz_RadHeight2(:,k) = 0.0d0 
      elseif( s_Z(k) >= RadHeightUp2 ) then
        xz_RadHeight2(:,k) = 0.0d0 
      end if
    end do

    

    call MessageNotify( "M", &
      & "Radiation", "RadHeatRate = %f", d=(/RadHeatRate/))
    call MessageNotify( "M", &
      & "Radiation", "RadHeightUp = %f", d=(/RadHeightUP/))
    call MessageNotify( "M", &
      & "Radiation", "RadHeightDown= %f", d=(/RadHeightDown/))
    call MessageNotify( "M", &
      & "Radiation", "RadHeatRate2 = %f", d=(/RadHeatRate2/))
    call MessageNotify( "M", &
      & "Radiation", "RadHeightUp2 = %f", d=(/RadHeightUP2/))
    call MessageNotify( "M", &
      & "Radiation", "RadHeightDown2 = %f", d=(/RadHeightDown2/))
    call MessageNotify( "M", &
      & "Radiation", "PressHeightUp = %f", d=(/PressHeightUp/))
    
  end subroutine Radiation_init


!!!------------------------------------------------------------------------!!!
  function xz_RadHeatConst(xz_Exner)
    !
    ! ̤Ͷ. 
    ! ɽ̤ RadHeight ǻꤵ줿٤ޤǤδ֤ǰѤͿ. 
    ! ʡؿϴܾͿ. 
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                       !ʡؿξ
    real(8)               :: xz_RadHeatConst(DimXMin:DimXMax, DimZMin:DimZMax)
                                       !Ͷ

!    xz_RadHeatConst = &
!      & xz_RadHeight * RadHeatRate  &
!      & / ( ( xz_ExnerBasicZ + xz_Exner ) * DayTime )

    xz_RadHeatConst = &
      & xz_RadHeight * RadHeatRate  &
      & / ( ( xz_ExnerBasicZ + xz_Exner ) * DayTime ) &
      & + xz_RadHeight2 * RadHeatRate2  &
      & / ( ( xz_ExnerBasicZ + xz_Exner ) * DayTime )

    call StorePotTempRad( xz_RadHeatConst )
    
  end function xz_RadHeatConst


!!!------------------------------------------------------------------------!!!
  function xz_RadHeatBalance(xz_ExnerBasicZ, xz_PotTempBasicZ, xz_Exner, xz_PotTemp)
    !
    ! ̤Ͷ. 
    ! ɽ̤ RadHeight ǻꤵ줿٤ޤǤδ֤ǶŪ˰ͤʲǮ, 
    ! RadHeight  RadHeight2 ޤǤδ֤ǶŪʰͤѤͿ. 
    ! ͶΤȤƲǮѤХ󥹤褦˻ͲǮΨ
    ! ӰΨѲ. 
    ! κ, ˤơβǮ̤̤ϽβǮ̤
    ! ʤ褦Ĵ᤹. 

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: xz_ExnerBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: xz_PotTempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)               :: xz_RadHeatBalance(DimXMin:DimXMax, DimZMin:DimZMax)                                       !Ͷ
    real(8)               :: xz_DensSum(DimXMin:DimXMax, DimZMin:DimZMax) 
                                        !̩(ܾʬȾʬ)
    real(8)               :: z_DensXmean(DimZMin:DimZMax)
                                        !̩(ʿʿ)
    real(8)               :: HeatRatio  !βǮΨȤβǮΨ
    real(8)               :: CoolRatio  !ΨȤΨ
    real(8)               :: HeatSum    !Ǥñ̻βǮ
    real(8)               :: CoolSum    !Ǥñ̻
    integer               :: k

    ! ̩٤λ
    xz_DensSum = PressSfc &
      & * (xz_ExnerBasicZ + xz_Exner)**( (CpDry - GasRDry)/GasRDry ) &
      & / (GasRDry * (xz_PotTempBasicZ + xz_PotTemp ) )

    ! ̩٤οʿʿѤλ
    z_DensXmean = sum( xz_DensSum, 1) / real(DimXMax - DimXMin + 1)

    HeatSum = 0.0d0
    CoolSum = 0.0d0

    ! ǤβǮ̤׻
!    do k = DimZmin, IntHeightUp - 1
    do k = RegZmin + 1, IntHeightUp - 1
     HeatSum = HeatSum + 0.5d0 * DelZ * CpDry * RadHeatRate * &
       & ( z_DensXmean(k) + z_DensXmean(k+1) )
    end do

    HeatSum = HeatSum + 0.5d0 * CpDry * RadHeatRate * &
      & ( 2.0d0 * z_DensXmean(RegZMin+1) - &
      & (z_DensXmean(RegZMin+2) - z_DensXmean(RegZMin+1) ) &
      & * s_Z(RegZMin+1) / DelZ &
      & + 2.0d0 * z_DensXmean(IntHeightUp) + &
      & ( z_DensXmean(IntHeightUp - 1) - z_DensXmean(IntHeightUp) ) & 
      & * (RadHeightUp - s_Z(IntHeightUp)) / DelZ )



    ! Ǥ̤׻
    do k = IntHeightUp + 1, IntHeightUp2 - 1
     CoolSum = CoolSum + 0.5d0 * DelZ * CpDry * RadHeatRate2 * &
       & ( z_DensXmean(k) + z_DensXmean(k+1) )
    end do

    CoolSum = CoolSum + 0.5d0 * CpDry * RadHeatRate2 * &
      & ( 2.0d0 * z_DensXmean(IntHeightUp + 1) - &
      & (z_DensXmean(IntHeightUp+2) - z_DensXmean(IntHeightUp+1) ) &
      & * ( s_Z(IntHeightUp+1) - RadHeightUp2 ) / DelZ &
      & + 2.0d0 * z_DensXmean(IntHeightUp2) + &
      & ( z_DensXmean(IntHeightUp2 + 1) - z_DensXmean(IntHeightUp2) ) & 
      & * (RadHeightUp2 - s_Z(IntHeightUp2)) / DelZ )

    ! Ǯ̵ڤ̤Ѳ򻻽
    HeatRatio = HeatWork / HeatSum

    CoolRatio = - HeatWork / CoolSum

    xz_RadHeatBalance = &
      & xz_RadHeight * HeatRatio * RadHeatRate  &
      & / ( xz_ExnerBasicZ  * DayTime ) &
      & + xz_RadHeight2 * CoolRatio * RadHeatRate2  &
      & / ( xz_ExnerBasicZ  * DayTime )

    call StorePotTempRad( xz_RadHeatBalance )
    
  end function xz_RadHeatBalance
  
  
  
!!!------------------------------------------------------------------------!!!
  function xz_NewtonCool(xz_PotTemp)
    !
    ! ̤Ͷ. 
    ! ɽ̤ RadHeight ǻꤵ줿٤ޤǤδ֤ǰѤͿ. 
    ! 
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                                       !̤ξ
    real(8)               :: xz_NewtonCool(DimXMin:DimXMax, DimZMin:DimZMax)
                                       !Ͷ
    real(8)               :: xz_PotTempMean(DimXMin:DimXMax, DimZMin:DimZMax)
                                       !̾ʿ
    real(8)               :: EFTime    !ʹ»
    integer               :: k

    !ʹ»֤ 5 
    EFTime = 5.0d0 * DayTime  
    
    do k = DimZMin, DimZMax
      xz_PotTempMean(:,k) = sum( xz_PotTemp(:,k) ) / real(DimXMax - DimXMin + 1)
    end do
    
    xz_NewtonCool = - xz_PotTempMean / EFTime 
    
    call StorePotTempDamp( xz_NewtonCool )

  end function xz_NewtonCool
  
end module Radiation
