class ResultInfo
 attr_accessor :server_name, :keyvalues,:pathtree, :point, :partial, :all_covered
 
def initialize(server_name)
  @server_name=server_name
  @keyvalues=Hash.new
  @pathtree=Hash.new
  @point=Hash.new
  @partial=Hash.new
  @all_covered=Hash.new
end

def add_keyvalue_count(keyname,keyvalue,count)
  if !@keyvalues[keyname] then
    @keyvalues[keyname]=Hash.new    
  end
  if !@keyvalues[keyname][keyvalue] then
    @keyvalues[keyname][keyvalue]=count.to_i
  else
    @keyvalues[keyname][keyvalue]=@keyvalues[keyname][keyvalue].to_i+count.to_i
  end
end


def add_keyname_count(keyname,count)
  if !@keyvalues[keyname] then
    @keyvalues[keyname]=Hash.new    
  end
  if !(@keyvalues[keyname].key?(:all_values)) then
    @keyvalues[keyname][:all_values]=0
  end
  @keyvalues[keyname][:all_values]+=count.to_i
end

def set_keyname_count(keyname,count)
  if !@keyvalues[keyname] then
    @keyvalues[keyname]=Hash.new    
  end
  @keyvalues[keyname][:all_values]=count
end

def get_keynames
  return @keyvalues.keys
end

def get_keynames_sorted
  sorted = @keyvalues.to_a.sort{|a,b|
    (b[1][:all_values]<=>a[1][:all_values])
  }
  sorted_keys = Array.new
  i=0
  sorted.size.times{
    sorted_keys.push(sorted[i][0])
    i=i+1
  }  
  return sorted_keys
end


def get_keyvalues(keyname)
  return @keyvalues[keyname]
end

def get_keyvalues_sorted(keyname)
  sorted = @keyvalues[keyname].to_a.sort{|a,b|
    (b[1]<=>a[1])
  }
  sorted_keys = Array.new
  i=0
  sorted.size.times{
    sorted_keys.push(sorted[i])
    i=i+1
  }  
  return sorted_keys

end

def get_keyvalue_count(keyname,keyvalue)
  return @keyvalues[keyname][keyvalue]
end

def get_keyname_count(keyname)
  return @keyvalues[keyname][:all_values]
end

def add_all_covered(added) #@added 2011.1.18 chiemi
	added.keys.each{ |region|
		if @all_covered.key?(region) then
			@all_covered[region]=@all_covered[region]+added[region]
		else
			@all_covered[region]=added[region]
		end
	}
end

 def add_partial(added) #@added 2011.1.18 chiemi
	added.keys.each{ |region|
		if @partial.key?(region) then
			@partial[region]=@partial[region]+added[region]
		else
			@partial[region]=added[region]
		end
	}
end

def add_point(added)
	added.keys.each{ |pnt|
		if @point.key?(pnt) then
			@point[pnt]=@point[pnt]+added[pnt]
		else
			@point[pnt]=added[pnt]
		end
	}
end

def get_count_point(pnt)
	return @point[pnt]
end

def get_count_partial(reg)
	return @partial[reg]
end

def get_count_all_covered(reg)
	region @all_covered[reg]
end

  def ResultInfo.get_pathtree_viewinfo(pathtree,serverurl,urlroot) 
       ptStack=Array.new
       ptStackDepth=Array.new        
       restNodes=Array.new
       restNodes[0]=1
       viewInfoList=Array.new
      
      if pathtree=="no result" then
        return pathtree
      end
      
        if urlroot!="" then
          urlprefix="http://#{serverurl}#{urlroot}"
        else
          urlprefix="http://#{serverurl}"
        end
      
      
      ptStack.push(pathtree)
      ptStackDepth.push(0)
      insert_string =""
      while ptStack.size>0 
        dir=ptStack.pop
        depth=ptStackDepth.pop
	    viewInfo=Hash.new
        
        if dir then
            if dir.elements["name"] then
              indents_tmp=""
              if depth>0 then
                #Cfg\
                for d in 0..depth-1
                  if restNodes[d]>0 then
                    indents_tmp="#{indents_tmp}<img src=#{urlroot}/images/tree/tate.png>"
                  else                  
                    indents_tmp="#{indents_tmp}<img src=#{urlroot}/images/tree/space.gif>"                  
                  end
                end
              end
              if restNodes[depth]==1 then
                indents="#{indents_tmp}<img src=#{urlroot}/images/tree/last.png>"
              else
                indents="#{indents_tmp}<img src=#{urlroot}/images/tree/t.png>"
	      end
              prevDepth=depth
              if dir.elements["path"] then
                nodepath="#{serverurl.gsub("/","_")}_#{dir.elements["path"].text.gsub("/","_")}"
                input_path=dir.elements["path"].text
                input_path.strip!
                # @todo : how does it work when input_path = "/" ?
                strlength=input_path.size
                if input_path[strlength-1]=="/"[0] then
                  input_path=input_path[0..strlength-2]
                end
                if dir.elements["treeicon"] then
		          viewInfo[:nodepath]=nodepath
	              viewInfo[:indent]=indents
		          viewInfo[:display_path]=dir.elements["name"].text
		          viewInfo[:input_path]=input_path
		          viewInfo[:input_server]=serverurl
		          viewInfo[:restNodes]=restNodes
		          viewInfo[:depth]=depth
		          viewInfo[:count]=dir.elements["count"].text
		          viewInfo[:treeicon]=dir.elements["treeicon"].text
                  if dir.elements["treeicon"].text=="plus" then
                      viewInfo[:imgsrc]="#{urlroot}/images/tree/plus.gif"
                  elsif dir.elements["treeicon"].text=="minus" then                                
                      viewInfo[:imgsrc]="#{urlroot}/images/tree/minus.gif"
	              end
	              viewInfo[:nodetype]="directory"
		        end
                cdirs=dir.elements["directories"]
                if cdirs && cdirs.class.to_s=="REXML::Element" then
                  cdirs.each{ |d|
                    if d.class.to_s=="REXML::Element" then
                      ptStack.push(d)
                      ptStackDepth.push(depth+1)
                      if restNodes.size<=depth+1 then
                        restNodes[depth+1]=1
                      else
                        restNodes[depth+1]=restNodes[depth+1]+1
                      end
                    end
                  }
                end
                #IuWFNg\
                cobjs=dir.elements["objects"]
                if cobjs && cobjs.class.to_s=="REXML::Element" then
                  i=1
                  objsize=0
                  cobjs.each{ |o| 
                    if o.class.to_s=="REXML::Element" then
                      objsize=objsize+1
                    end
                  }              
                  viewInfo[:objInfoList]=Array.new
                  cobjs.each{ |o|
		            objInfo=Hash.new		    
                    if o.class.to_s=="REXML::Element" then
                      path=o.elements["path"].text
                      nodeid=o.elements["id"].text
                      node_type=o.elements["node-type"].text.to_i
                      objname=o.elements["path"].text.split("/").pop
                      indents="#{indents_tmp}<img src=#{urlroot}/images/tree/tate.png>"
                      if i<objsize then
                        indents="#{indents}<img src=#{urlroot}/images/tree/t.png>"
                      else
                        indents="#{indents}<img src=#{urlroot}/images/tree/last.png>"                  
                      end
                      objInfo[:nodetype]="object"
                      objInfo[:indent]=indents
                      url=urlprefix+"/data#{path}.html"
                      objInfo[:imgsrc]="#{urlroot}/images/tree/page.gif"
                      objInfo[:objname]=objname
                      objInfo[:url]=url
                      objInfo[:path]=path                  
                      if node_type==Node::VARIABLE then
                        avurl=urlprefix+"/finder/add_to_list?path=#{path}"
                        objInfo[:analysis]=avurl
                        viewInfo[:objInfoList].push(objInfo)
                      elsif node_type==Node::KNOWLEDGE then
                        knurl=urlprefix+"/knowledge/show?path=#{path}"
                        objInfo[:knowledge]=knurl
                        viewInfo[:objInfoList].push(objInfo)
                      elsif node_type==Node::IMAGE then
                        objInfo[:image]=url
                        viewInfo[:objInfoList].push(objInfo)
                      end
                      i=i+1
                    end #if o.class.to_s=="REXML::Element" then
                  }#cobjs.each{ |o|
                end #if cobjs && cobjs.class.to_s=="REXML::Element" then                           
              else #if dir.elements["path"] then
              end
            end # if dir.elements["name"] then
          end # if dir then
          restNodes[depth]=restNodes[depth]-1 #\m[h̐炷
          if restNodes[depth]==0 then
            dp=depth
            hasdescendant=0            
            while dp<restNodes.size do
              if restNodes[dp]>0 then
                hasdescendant=1
              end
              dp=dp+1
            end
            if hasdescendant==0 then
	          closestr="</div>"
              dp=depth-1
              while dp>0 do
                if restNodes[dp]==0 then
	              closestr="#{closestr}</div>"
                end
                dp=dp-1
	          end
	          viewInfo[:closestr]=closestr
            end
          end
        if viewInfo.size>0 then 
	      viewInfoList.push(viewInfo)	
	    end  
      end # while ptStack.size>0
      return viewInfoList
  end



end