!== dc_trace.f90 - ǥХåѥ⥸塼
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: dc_trace.f90,v 1.8 2006/12/05 21:29:32 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20070711 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! This file provides dc_trace
!

module dc_trace
  !
  !== Overview
  !
  ! dc_trace ϥǥХåθפ뤿Υ֥롼
  ! ĥ⥸塼Ǥ Υ⥸塼Ѥǡ
  ! ʲΤ褦˥֥롼γع¤Τޤʬ褦
  ! ǥХååϤǽǤ
  !
  !         :
  !    #call HistoryPut0
  !    #| call HistoryPutEx : time
  !    #| | call TimeGoAhead : varname=time head=1.
  !    #| | | call lookup_dimension
  !    #| | | | call gtvarinquire : var.mapid=1
  !    #| | | | | call anvarinqurie : var.id=1
  !    #| | | | | end anvarinqurie : ok
  !    #| | | | |-name=time
  !    #| | | | end gtvarinquire
  !    #| | | end lookup_dimension : ord=1
  !    #| | | call gtvarslice : var%mapid=1 dimord=1
  !    #| | | |-[gt_variable 1: ndims=1, map.size=1]
  !    #| | | |-[dim1 dimno=1 ofs=0 step=1 all=0 start=1 count=0 stride=1 url=]
  !    #| | | |-[vartable 1: class=netcdf cid=1 ref=1]
  !    #| | | |-[AN_VARIABLE(file=3, var=1, dim=1)]
  !    #| | | |-map(dimord): originally start=1 count=0 stride=1
  !    #| | | |-start=1 (1 specified)
  !    #| | | |-count=1 (1 specified)
  !    #| | | end gtvarslice
  !    #| | end TimeGoAhead
  !    #| |-anfiledefinemode
  !    #| end HistoryPutEx
  !    #end HistoryPut0
  !         :
  !
  !== List
  !
  ! SetDebug    :: ǥХå⡼ɤ򥪥󥪥
  ! BeginSub    :: ץ೫ϤΥå
  ! EndSub      :: ץཪλΥå
  ! DbgMessage  :: ǥХåѥå
  !
  !== Usage
  !
  ! dc_trace ⥸塼Ѥ뤿ΰϢή⤷ޤ
  ! ܤϳƼ³ξܺ٤򻲾ȤƤ
  !
  ! ޤʲΤ褦ץμ¹ʸƬȺǸ
  ! BeginSub  EndSub Ѥޤ
  !
  !     subroutine TestRoutine(file, var, times, db, url)
  !       use dc_types,  only: STRING, DP
  !       use dc_trace,  only: BeginSub, EndSub
  !       character(len = *), intent(in) :: file, var
  !       integer           , intent(in) :: times
  !       real(DP)          , intent(in) :: db(5)
  !       character(len = *), intent(out):: url
  !       character(len = STRING), parameter:: subname = "TestRoutine"
  !     continue
  !       call BeginSub(subname, 'file=%c, var=%c, times=%d', &
  !         &           c1=trim(file), c2=trim(var), i=(/times/) )
  !       
  !       url = trim(file) // trim(var) // ' ' // ','
  !       url = repeat(trim(url), times)
  !     
  !       call EndSub(subname, 'url=%c', c1=trim(url) )
  !     end subroutine TestRoutine
  !
  ! ơץμ¹ʸƬ SetDebug Ѥޤ
  ! ɬܤǤϤޤ󤬡ξǥХåå
  ! ɸ२顼Ϥɽޤ⤷ɸϤʤɤ¾
  ! ϤϽϤֹȤͿƤ
  !
  !     program main
  !       use dc_types,  only: STRING, DP
  !       use dc_trace,  only: SetDebug
  !       character(len = STRING), parameter:: file    = 'test.nc'
  !       character(len = STRING), parameter:: var     = 'div'
  !       integer                , parameter:: times   = 2
  !       character(len = STRING)           :: url
  !       real(DP)                          :: db(5) = (/1.1, 2.2, 3.3, 4.4, 5.5/)
  !       character(len = STRING), parameter:: subname = "TestProgram"
  !     
  !     continue
  !     
  !       call SetDebug
  !     
  !       call TestRoutine(file, var, times, db, url)
  !     
  !       stop
  !     end program main
  !
  ! 嵭ΥץफϰʲΤ褦ʥǥХåå
  ! ɸ२顼Ϥ˽Ϥޤ
  !
  !     #SetDebug: dbg = 0
  !     #call TestRoutine : file=test.nc, var=div, times=2
  !     #end TestRoutine : url=test.ncdiv ,test.ncdiv ,
  !
  ! ʲդ­򵭤ޤ
  !
  ! * 嵭Τ褦 BeginSub  SetDebug ƤФƤɬפޤ
  ! * BeginSub Ʊ EndSub ƤФƤʤФʤޤ
  ! * ץκǽȺǸʳǥǥХåå
  !   Ϥˤ DbgMessage ѤƲ
  ! * ǥХååȤ¿ǡϤ
  !   DataDump ѤƤ
  ! * ߤΥǥХå⡼ɤξ (ǥХå⡼ɤݤ
  !   ץο١ֹ) Ĵ٤ϡ
  !   줾 Debug, SubLevel, dbg ѤƤ
  !
  !== Example
  !
  !     program main
  !       use dc_types,  only: STRING, DP
  !       use dc_trace,  only: SetDebug
  !       character(len = STRING), parameter:: file    = 'test.nc'
  !       character(len = STRING), parameter:: var     = 'div'
  !       integer                , parameter:: times   = 2
  !       character(len = STRING)           :: url
  !       real(DP)                          :: db(5) = (/1.1, 2.2, 3.3, 4.4, 5.5/)
  !       character(len = STRING), parameter:: subname = "TestProgram"
  !     
  !     continue
  !     
  !       call SetDebug
  !     
  !       call TestRoutine(file, var, times, db, url)
  !     
  !       stop
  !     end program main
  !
  !     subroutine TestRoutine(file, var, times, db, url)
  !       use dc_types,  only: STRING, DP
  !       use dc_trace,  only: BeginSub, EndSub
  !       character(len = *), intent(in) :: file, var
  !       integer           , intent(in) :: times
  !       real(DP)          , intent(in) :: db(5)
  !       character(len = *), intent(out):: url
  !       character(len = STRING), parameter:: subname = "TestRoutine"
  !     continue
  !       call BeginSub(subname, 'file=%c, var=%c, times=%d', &
  !         &           c1=trim(file), c2=trim(var), i=(/times/) )
  !       
  !       url = trim(file) // trim(var) // ' ' // ','
  !       call DbgMessage('url=%c', c1=trim(url))
  !       url = repeat(trim(url), times)
  !       call DataDump('db', db, strlen=60)
  !
  !       call EndSub(subname, 'url=%c', c1=trim(url) )
  !     end subroutine TestRoutine
  !
  ! 嵭ΥץफϰʲΤ褦ʥǥХåå
  ! ɸ२顼Ϥ˽Ϥޤ
  !
  !     #SetDebug: dbg = 0
  !     #call TestRoutine : file=test.nc, var=div, times=2
  !     #|-url=test.ncdiv ,
  !     #|-db(1-3)=1.1000000238418580000, 2.2000000476837160000, 3.2999999523162840000
  !     #|-db(4-5)=4.4000000953674320000, 5.5000000000000000000
  !     #end TestRoutine : url=test.ncdiv ,test.ncdiv ,
  !
  !
  use dc_types, only: TOKEN, STRING
  implicit none
  private

  logical, save         :: lfirst = .true. 
                                        ! ե饰
  integer, save, public :: dbg = -1     ! SetDebug ꤵ줿
                                        ! ǥХåå
                                        ! ϤֹǤ
  integer, save         :: level = 0    ! ֥롼٥
  integer, parameter    :: trace_stack_size = 128
                                        ! 糬ؿ
  character(TOKEN), save:: table(trace_stack_size)
                                        ! آΥץ̾
  character(STRING), save, allocatable:: called_subname(:), &
    &                                    called_subname_tmp(:)
                                        ! ˰ٸƤФƤ,
                                        ! *version* ꤷƤ
                                        ! ץ̾Ǽ
  character(1), parameter :: head    = '#'  ! Ƭʸ
  character(2), parameter :: indent  = '| ' ! ʸ
  character(2), parameter :: meshead = '|-' ! DbgMessage ѹƬʸ

  public:: BeginSub, EndSub, Debug, SetDebug, DbgMessage, Dbg_Scratch
  public:: SubLevel, DataDump

  interface DataDump
    module procedure DataD1Dump, DataD2Dump, DataD3Dump
  end interface

contains

  integer function SubLevel() result(result)
    !
    !== ץγإ٥֤
    !
    ! ץγإ٥֤ޤ ٥ΥǥեȤ 0 ǡ
    ! BeginSub ˤ٥ 1  EndSub ˤ٥ 1 ޤ
    !
    result = level
  end function SubLevel

  subroutine Dbg_Scratch(on)
    !
    !== ǥХåå
    !
    ! <b>ư̤ǧǤΤѤκݤˤϤղ</b>
    !
    ! ѿ on  .true. Ϳǡ
    ! ʹߤ ǥХååäޤ
    !
    ! ʤѿ on  <tt>.false.</tt>  Ϳǡ
    ! ľ˸Ƥ Dbg_Scratch ʹߤΥå
    ! ǥХååȤƺƤӽϤ
    ! ʹߤΥǥХåå Ϥ褦ˤޤ
    !
    logical, intent(in):: on
    integer, save:: saved_dbg = -1
    logical:: x, p
    character(80):: line
    integer:: ios
  continue
    if (on) then
      if (dbg < 0) return
      saved_dbg = dbg
      ! ͭ 1  99 ֹ礭ͤ (?)
      dbg = 98
      do
        inquire(unit=dbg, exist=x, opened=p)
        ! ֹ dbg ³ǽǡ̤³ξ
        if (x .and. .not. p) then
          ! ֹ deg 򥹥åեȤƳ
          !    åեȤϡüʳեǤ롣
          !      ̾ʤΰեǤꡢƤ
          !      ֤¸ߤ롣Ĥޤꡢץबλ
          !      ¸ߤʤʤ롣
          open(unit=dbg, status='SCRATCH')
          ! Фǽλ
          return
        endif
        ! ֹ dbg ԲġޤѺѤξ 0 ʲ
        ! ʤޤ dbg - 1 Ʒ֤
        dbg = dbg - 1
        if (dbg < 0) exit
      enddo
      ! ֹ dbg ʤ硢dbg  saved_dbg 
      dbg = saved_dbg
      saved_dbg = -1
    else
      ! ֹ dbg = 980 ǥåե򳫤Ƥ
      ! ʤФǽλ
      if (saved_dbg < 0) return
      ! ֹ dbg ³줿åե򤽤γϰ
      ! ˰դ롣顼100 continueפ
      rewind(dbg, err=100)
      do
        ! ֹ dbg ³줿åեΰԤ
        ! line 
        read(dbg, '(A)', iostat=ios) line
        if (ios /= 0) exit
        ! line ֹ saved_dbg ؽ񤭽Ф
        write(saved_dbg, '(A)', iostat=ios) trim(line)
        if (ios /= 0) exit
      enddo
  100 continue
      close(dbg, iostat=ios)
      ! Ǹ dbg  saved_dbg 
      dbg = saved_dbg
      saved_dbg = -1
    endif
  end subroutine Dbg_Scratch

  subroutine SetDebug(debug)
    use dc_types, only: STDOUT, STDERR
    implicit none
    !
    !== ǥХå⡼ɤ򥪥󥪥
    !
    ! ǥХååϤˤΥ֥롼ƤӤޤ
    !
    ! ѿ debug Ϳϡֹ debug ˡ
    ! ʹߤΥ֥롼ˤǥХååϤ褦ˤޤ
    ! debug Ϳʤ硢ֹ 0 (ɸ२顼)
    ! ˥ǥХååϤ褦ˤʤޤ
    ! ֹ 0 ؤνϤʤ
    ! ֹ 6 (ɸ) ˥ǥХååϤ褦ˤʤޤ
    !
    ! debug Ϳ硢ǥХå⡼ɤ졢
    ! ʹߥǥХååϽϤޤ
    !
    ! ʤ SetDebug Ƥݤˤ⡢ֹ debug
    ! ˰ʲΥå ɽޤ
    !
    !     #SetDebug: dbg = debug
    !
    integer, intent(in), optional:: debug
    integer:: ios
    if (present(debug)) then
      ! debug ͿֹȤ deg Ѥ롣
      dbg = debug
      write(dbg, "(A, 'SetDebug: dbg =', i4)", iostat=ios) &
        & trim(head), dbg
      if (ios == 0) return
    else
      ! debug Ϳ̵ֹ 0 (ɸ२顼)
      dbg = STDERR
      write(dbg, "(A, 'SetDebug: dbg = ', I0)", iostat=ios) trim(head), dbg
      if (ios == 0) return
      ! ֹ 0 ؤνϤԤֹ 6 (ɸ)
      dbg = STDOUT
      write(dbg, "(A, 'SetDebug: dbg = ', I0)", iostat=ios) trim(head), dbg
      if (ios == 0) return
    endif
    ! 㳰Ȥ dbg ν
    dbg = -1
  end subroutine SetDebug

  logical function Debug() result(result)
    !
    !== ǥХå⡼ɤɤο
    !
    ! SetDebugǥǥХå⡼ɤˤʤäƤˤ .true. 
    ! ǥХå⡼ɤǤʤˤ .false. ֤ޤ
    !
    result = dbg >= 0
  end function Debug

  subroutine initialize
    !
    ! 
    !
    table(:) = ' '
    lfirst = .false.
  end subroutine initialize

  subroutine BeginSub(name, fmt, i, r, d, L, n, c1, c2, c3, ca, &
    & version)
    !
    !== ץ೫ϤΥå
    !
    ! ʸѿ *name* Ϳץ̾ʲΤ褦˽Ϥޤ.
    !
    !     # call name
    !
    ! ʣƤֻǾ嵭 (dc_trace  Overview ) 
    ! Τ褦˥åϤޤ.
    ! ɬ BeginSub Ʊͤʿ EndSub Ƥ֤褦ˤƤ.
    !
    ! ޤ, ʸѿ *fmt* ӤʹߤΰͿ,
    ! ʲΤ褦ղååϲǽǤ. *fmt*
    ! Ȥʹߤΰ˴ؤ񼰤 dc_string#CPrintf
    ! 򻲾ȤƲ.
    !
    !     # call name : fmt
    !
    ! ˴ؤƤ dc_trace  Usage  Example 򻲾ȤƤ.
    !
    ! *version* ˤ, ץΥСʥСͿޤ.
    ! *version* Ϳ줿ʸ, ץ
    ! ʣƤӽФ줿, ˸ƤӽФ줿Τɽޤ.
    !
    !--
    !== ȯԸ
    !
    ! Υ֥롼ˤ, Υ⥸塼Ūݻ
    ! ѿ level ͤ 1 ޤ
    !
    !++
    use dc_types, only: STRING, DP
    use dc_string, only: cprintf, StrInclude
    character(*), intent(in)          :: name
    character(*), intent(in), optional:: fmt
    integer,      intent(in), optional:: i(:), n(:)
    real,         intent(in), optional:: r(:)
    real(DP),     intent(in), optional:: d(:)
    logical,      intent(in), optional:: L(:)
    character(*), intent(in), optional:: c1, c2, c3
    character(*), intent(in), optional:: ca(:)
    character(*), intent(in), optional:: version
    character(STRING) :: cbuf
    character(STRING) :: name_ver
    logical :: print_version
    integer :: alloc_size
  continue
    if (lfirst) call initialize
    if (debug()) then
      name_ver = name
      print_version = .false.

      !
      !== Print Version check
      !
      if (present(version)) then
        if (.not. allocated(called_subname)) then
          allocate(called_subname(1))
          called_subname(1) = name
          print_version = .true.
        else
          if (.not. StrInclude(called_subname, trim(name))) then
            alloc_size = size(called_subname)
            allocate(called_subname_tmp(alloc_size))
            called_subname_tmp = called_subname
            deallocate(called_subname)
            allocate(called_subname(alloc_size + 1))
            called_subname(1:alloc_size) = called_subname_tmp
            deallocate(called_subname_tmp)
            called_subname(alloc_size + 1) = name
            print_version = .true.
          end if
        end if

        if (print_version) then
          name_ver = cprintf('%c version=<%c>', &
            & c1=trim(name), c2=trim(version))
        end if
      end if
      !
      !== Print Debug message
      !
      if (present(fmt)) then
        cbuf = cprintf(fmt, i, r, d, L, n, c1, c2, c3, ca)
        write(dbg, "(A, A, 'call ', A, ' : ', A)") trim(head), &
          & repeat(indent, level), trim(name_ver), trim(cbuf)
      else
        write(dbg, "(A, A, 'call ',A)") trim(head), & 
          & repeat(indent, level), trim(name_ver)
      endif
    endif
    ! call errtra ! --- for Fujitsu debug
    if (level > size(table)) return
    level = level + 1
    table(level) = name
  end subroutine BeginSub

  subroutine EndSub(name, fmt, i, r, d, L, n, c1, c2, c3, ca)
    !
    !== ץཪλΥå
    !
    ! ʸѿ name Ϳץ̾ʲΤ褦˽Ϥޤ
    !
    !     # end name
    !
    ! BeginSub ФưабƤޤΤǡname ˤб
    ! BeginSub ΰ name ƱΤͿƲ
    !
    ! ޤʸѿ fmt ӤʹߤΰͿǡ
    ! ʲΤ褦ղååϲǽǤ fmt
    ! Ȥʹߤΰ˴ؤ񼰤 dc_string#CPrintf
    ! 򻲾ȤƲ
    !
    !     # end name fmt
    !
    ! ˴ؤƤ dc_trace  Usage  Example򻲾ȤƤ
    !--
    !== ȯԸ
    !
    ! Υ֥롼ˤ, Υ⥸塼Ūݻ
    ! ѿ level ͤ 1 ޤ
    !
    !++
    use dc_types, only: STRING, DP
    use dc_string, only: cprintf
    character(*), intent(in)          :: name
    character(*), intent(in), optional:: fmt
    integer,      intent(in), optional:: i(:), n(:)
    real,         intent(in), optional:: r(:)
    real(DP),     intent(in), optional:: d(:)
    logical,      intent(in), optional:: L(:)
    character(*), intent(in), optional:: c1, c2, c3
    character(*), intent(in), optional:: ca(:)
    character(STRING):: cbuf
  continue
    if (lfirst) call initialize
    ! call errtra ! --- for Fujitsu debug
    if (level <= 0) then
      write(*, "(A, 'Warning EndSub[',A,'] without BeginSub')") &
        & trim(head), trim(name)
    else if (name /= table(level)) then
      write(*, "(A, 'Warning EndSub[',A,'] but tos[',A,']')") &
        & trim(head), trim(name), trim(table(level))
    else
      level = level - 1
    endif
    if (debug()) then
      if (present(fmt)) then
        cbuf = cprintf(fmt, i, r, d, L, n, c1, c2, c3, ca)
        write(dbg, "(A, A, 'end ', A, ' : ', A)") trim(head), &
          & repeat(indent, level), trim(name), trim(cbuf)
      else
        write(dbg, "(A, A, 'end ', A)") trim(head), &
          & repeat(indent, level), trim(name)
      endif
    endif
  end subroutine EndSub

  subroutine DbgMessage(fmt, i, r, d, L, n, c1, c2, c3, ca)
    !
    !== ǥХåѥå
    !
    ! եޥåʸ fmt ˽äƥǥХååϤޤ
    ! fmt Ȥʹߤΰ˴ؤ񼰤 dc_string#CPrintf
    ! 򻲾ȤƲ
    !
    ! ˴ؤƤ dc_trace  Example 򻲾ȤƲ
    !
    !--
    !== ȯԸ
    !
    ! Υ֥롼ѤƤ⡢Υ⥸塼Ūݻ
    ! ѿ level ͤѲޤ
    !
    !++
    use dc_types, only: STRING, DP
    use dc_string, only: cprintf, toChar
    character(*), intent(in)          :: fmt
    integer,      intent(in), optional:: i(:), n(:)
    real,         intent(in), optional:: r(:)
    real(DP),     intent(in), optional:: d(:)
    logical,      intent(in), optional:: L(:)
    character(*), intent(in), optional:: c1, c2, c3
    character(*), intent(in), optional:: ca(:)
    character(STRING):: cbuf
    character(STRING):: meshead_tmp
    integer          :: meshead_len
  continue
    if (.not. debug()) return
    cbuf = cprintf(fmt, i, r, d, L, n, c1, c2, c3, ca)
    if (level < 1) then
      meshead_tmp = ''
      meshead_len = 0
    else
      meshead_tmp = meshead
      meshead_len = len(meshead)
    endif
    write(dbg, "(A, A, A, A)") & 
      & trim(head), repeat( indent, max(level-1, 0) ), &
      & meshead_tmp(1:meshead_len), trim(cbuf)
  end subroutine DbgMessage

  subroutine DataD1Dump(header, d, strlen, multi)
    !
    !== 1 ǡ
    !
    ! ǥХååȤơ¿ǡ d (ټ¿)
    ! Ϥޤ ʸѿ header ϽϻƬʸȤѤޤ
    !  strlen ͿǡԤʸǤޤ
    ! (ǥեȤʸ dc_types#STRING ǻꤵƤޤ)
    !  multi(:) Ϳ뤳Ȥǡ
    ! header θ˼źĤǽǤ
    !
    ! ˴ؤƤ dc_trace  Example 򻲾ȤƲ
    !
    !--
    !== ȯԸ
    !
    ! Υ֥롼ѤƤ⡢Υ⥸塼Ūݻ
    ! ѿ level ͤѲޤ
    !
    !++
    use dc_types,      only: STRING, DP
    use dc_string,     only: toChar
    character(*), intent(in)          :: header  ! ǡ̾
    real(DP),     intent(in)          :: d(:)    ! ټ¿ǡ
    integer,      intent(in), optional:: strlen  ! Ԥʸ
    integer,      intent(in), optional:: multi(:)! ̤μź

    integer          :: i, j

    character(STRING):: unit    ! ǡʸ
    character(STRING):: unitbuf ! ǡʸХåե
    integer          :: ucur    ! unit ˽񤫤줿ʸ
    character(STRING):: cbuf    ! read/write ʸΥХåե
    integer          :: stat    ! ơ

    logical  :: first  ! 1ܤΥǡɤ
    integer  :: begini ! 1ܤΥǡź
    integer  :: endi   ! ǸΥǡź

    character(STRING):: cmulti ! źʸ
    character(STRING):: cout   ! Ϥʸ

    character(STRING):: meshead_tmp
    integer          :: meshead_len
  continue
    if (.not. debug()) return

    ! 
    unit    = ''
    unitbuf = ''
    ucur    = 0
    stat    = 0
    first = .true.

    cmulti = ''

    ! ǥХååإåκ
    if (level < 1) then
      meshead_tmp = ''
      meshead_len = 0
    else
      meshead_tmp = meshead
      meshead_len = len(meshead)
    endif

    ! źʸ
    if (present(multi)) then
      do j = 1, size(multi)
        cmulti = trim(cmulti) // ', ' // trim(  toChar( multi(j) )  )
      enddo
    endif

    i = 1
    Dim_1_Loop : do
      if (first) begini = i
      endi = i
      write(cbuf, "(g40.20)") d(i)
      if (.not. first) cbuf = ', ' // adjustl(cbuf)
      unitbuf = unit
      call append(unit, ucur, trim(adjustl(cbuf)), stat, strlen)

      if ( stat /= 0 .or. i == size( d(:) ) ) then
        ! ܤϡʸСǤ⤽Τޤ޽ϡ
        if (first) then
          cout = header // '(' &
            &   // trim(toChar(begini)) &
            &   // trim(cmulti) &
            &   // ')=' // trim(unit)
          ! ܰʹߤϡСΤϼ
        elseif (stat /= 0 .and. begini == endi-1) then
          cout = header // '(' &
            &   // trim(toChar(begini)) &
            &   // trim(cmulti) &
            &   // ')='// trim(unitbuf)
          ! 1Ĵ᤹
          i = i - 1
        elseif (stat /= 0 .and. begini /= endi-1) then
          cout = header // '(' &
            &   // trim(toChar(begini)) // '-' &
            &   // trim(toChar(endi-1)) &
            &   // trim(cmulti) &
            &   // ')=' // trim(unitbuf)
          ! 1Ĵ᤹
          i = i - 1
          ! i  size(d) ޤã⤽Τޤ޽ϡ
        elseif ( i == size( d(:) ) ) then
          cout = header // '(' &
            &   // trim(toChar(begini)) // '-' &
            &   // trim(toChar(endi))   &
            &   // trim(cmulti) &
            &   // ')='// trim(unit)
        endif

        write(dbg, "(A, A, A, A)") & 
          & trim(head), repeat( indent, max(level-1, 0) ), &
          & meshead_tmp(1:meshead_len), trim(cout)

        ! unit, unitbuf 򥯥ꥢ
        unit    = ''
        unitbuf = ''
        ucur    = 0
        first = .true.
      else
        first = .false.
      endif
      if (i == size( d(:) ) ) exit Dim_1_Loop
      i = i + 1
    enddo Dim_1_Loop
  end subroutine DataD1Dump

  subroutine DataD2Dump(header, d, strlen, multi)
    !
    !== 2 ǡ
    !
    ! ܤ DataDump ޤ DataD1Dump 򻲾Ȥ
    !
    use dc_types,      only: STRING, DP
    character(*), intent(in)          :: header  ! ǡ̾
    real(DP),     intent(in)          :: d(:,:)  ! ټ¿ǡ
    integer,      intent(in), optional:: strlen  ! Ԥʸ
    integer,      intent(in), optional:: multi(:)! ̤μź

    integer, allocatable :: total(:)
    integer              :: j

  continue
    if (.not. debug()) return

    if (present(multi)) then
      allocate( total(size(multi)+1) )
      total(2:size(multi)+1) = multi(:)
    else
      allocate( total(1) )
    endif

    do j = 1, size( d(:,:), 2 )
      total(1) = j
      call DataDump(header, d(:,j), strlen=strlen, multi=total(:))
    enddo

    deallocate( total )

  end subroutine DataD2Dump

  subroutine DataD3Dump(header, d, strlen, multi)
    !
    !== 3 ǡ
    !
    ! ܤ DataDump ޤ DataD1Dump 򻲾Ȥ
    !
    use dc_types,      only: STRING, DP
    character(*), intent(in)          :: header  ! ǡ̾
    real(DP),     intent(in)          :: d(:,:,:)! ټ¿ǡ
    integer,      intent(in), optional:: strlen  ! Ԥʸ
    integer,      intent(in), optional:: multi(:)! ̤μź

    integer, allocatable :: total(:)
    integer              :: k

  continue
    if (.not. debug()) return

    if (present(multi)) then
      allocate( total(size(multi)+1) )
      total(2:size(multi)+1) = multi(:)
    else
      allocate( total(1) )
    endif

    do k = 1, size( d(:,:,:), 3 )
      total(1) = k
      call DataDump(header, d(:,:,k), strlen=strlen, multi=total(:))
    enddo

    deallocate( total )

  end subroutine DataD3Dump

  subroutine append(unit, ucur, val, stat, strlen)
    !
    ! DataD1Dump ؿ
    ! unit  val ղáκݡunit κʸĹۤ
    ! ˤ stat = 2 ֤
    !
    character(*), intent(inout):: unit ! ǽŪ֤ʸ
    integer,      intent(inout):: ucur ! unit ʸ
    character(*), intent(in)   :: val  ! unit ղäʸ
    integer,      intent(out)  :: stat ! ơ
    integer,      intent(in), &
      &        optional     :: strlen ! ʸμư

    integer                    :: wrsz ! val ʸ
    continue
    ! unit κĹۤˤ stat = 2 ֤
    if (present(strlen)) then
      if (ucur >= strlen) then
        stat = 2
        return
      endif
    else
      if (ucur >= len(unit)) then
        stat = 2
        return
      endif
    endif
    ! ν
    ! unit Ĺۤθ unit  val ղä롣
    wrsz = min(len(val), len(unit) - ucur)
    unit(1+ucur: wrsz+ucur) = val(1: wrsz)
    ucur = ucur + wrsz
    stat = 0
    if (wrsz < len(val)) stat = 1
  end subroutine append

end module dc_trace
