!== dc_date_types.f90 - ա˴ؤ빽¤Τ󶡤⥸塼
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: dc_date_types.f90,v 1.9 2006/12/29 10:29:50 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20070711 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]

module dc_date_types
  !
  ! dc_date Ѥ빽¤Τѿݻ⥸塼Ǥ
  !
  ! ޤˡ˴ؤݻƤޤ.
  !
  use dc_types, only: DP, STRING

  implicit none

  private
  public:: DC_DATETIME, DC_DIFFTIME
  public:: CAL_CYCLIC, CAL_NOLEAP, CAL_JULIAN, CAL_GREGORIAN
  public:: CYCLIC_MDAYS, DAY_SECONDS_EARTH, MIN_SECONDS, HOUR_SECONDS
  public:: YEAR_MONTHS, YEAR_DAYS, FOUR_YEARS, FOUR_CENTURY
  public:: PREPARED_CALTYPES
  public:: caltype, day_seconds
  public:: UNIT_SEC, UNIT_MIN, UNIT_HOUR, UNIT_DAY, UNIT_MONTH, UNIT_YEAR

  !-------
  ! ˡ

  integer, parameter:: CAL_CYCLIC = 1   ! 1  30.6  (CYCLIC_MDAYS)
                                        ! Ȥ.
                                        ! (: 0 ܤ 1  30 (30.6),
                                        ! 1 ܤ 1  31 (61.2),
                                        ! 2 ܤ 1  30 (91.8),
                                        ! 3 ܤ 1  31 (122.4),
                                        ! 4 ܤ 1  31 (153.0) ...)
                                        !
                                        ! Ūʻ֤Ǽ¸Ԥ
                                        ! ˻Ѥ뤳ȤꤷƤ
                                        ! ޤ.
                                        !
  integer, parameter:: CAL_NOLEAP = 2   ! 1 ǯ 365 
                                        !
  integer, parameter:: CAL_JULIAN = 3   ! ꥦ
                                        !
  integer, parameter:: CAL_GREGORIAN = 4! 쥴ꥪ
                                        !
  integer, parameter:: PREPARED_CALTYPES(0:3) = &
    & (/CAL_CYCLIC, CAL_NOLEAP, CAL_JULIAN, CAL_GREGORIAN/)

  integer, save:: caltype = CAL_GREGORIAN ! ǥեȤ

  !-------
  ! ñ̴֤δط

  real(DP), parameter:: CYCLIC_MDAYS = 30.6_DP    ! CAL_CYCLIC ǻѤ
                                                  ! 1 .
                                                  ! ޤ DC_DIFFTIME 
                                                  ! 1 ˤ
                                                  ! Ѥޤ.

  real(DP), parameter:: MIN_SECONDS  = 60.0_DP    ! 1 ʬÿ
  real(DP), parameter:: HOUR_SECONDS = 3600.0_DP  ! 1 ֤ÿ
  real(DP), parameter:: DAY_SECONDS_EARTH  = 86400.0_DP
                                                  ! ϵ 1 ÿ
  real(DP), save     :: day_seconds  = DAY_SECONDS_EARTH
                                                  ! 1 ÿ
  integer, parameter:: YEAR_DAYS = 365            ! 1 ǯ (ǯ) 
  integer, parameter:: YEAR_MONTHS = 12           ! 1 ǯη
  integer, parameter:: FOUR_YEARS = YEAR_DAYS * 4 + 1
                                                  ! 4 ǯ
  integer, parameter:: FOUR_CENTURY = YEAR_DAYS * 400 + 97
                                                  ! 1 

  !-------
  ! ñ̤Ȥǧʸ

  character(*), parameter, dimension(8) :: UNIT_SEC = (/ &
    & 'seconds', 'second ', 'secs.  ', 'secs   ', &
    & 'sec.   ', 'sec    ', 's.     ', 's      '/) ! äñ̤򼨤ʸ

  character(*), parameter, dimension(4) :: UNIT_MIN = (/ &
    & 'minutes', 'minute ', 'min.   ', 'min    '/) ! ʬñ̤򼨤ʸ
  character(*), parameter, dimension(8) :: UNIT_HOUR = (/ &
    & 'hours', 'hour ', 'hrs. ', 'hrs  ', &
    & 'hr.  ', 'hr   ', 'h.   ', 'h    '/)         ! ñ̤򼨤ʸ
  character(*), parameter, dimension(4) :: UNIT_DAY = (/ &
    & 'days', 'day ', 'd.  ', 'd   '/)             ! ñ̤򼨤ʸ
  character(*), parameter, dimension(6) :: UNIT_MONTH = (/ &
    & 'months', 'month ', 'mon.  ', &
    & 'mon   ', 'mo.   ', 'mo    '/)               ! ñ̤򼨤ʸ
  character(*), parameter, dimension(4) :: UNIT_YEAR = (/ &
    & 'years', 'year ', 'yr.  ', 'yr   '/)         ! ǯñ̤򼨤ʸ


  type DC_DATETIME
    ! äФջɽޤ.
    !
    ! ι¤ǡѿѤݤɬѿ
    ! dc_date#Create ޤ dc_date#assignment(=)
    ! ˤäƽƤ. ޤ, *day*, *sec* ʤɤѿ
    ! ľѹʤǤ.
    !
    ! ˡ dc_date  "List"  "Usage" 򻲾ȤƤ.
    !
    sequence
    integer :: caltype = CAL_GREGORIAN ! ˡ
    integer :: day = 1      ! 
    real(DP):: sec = 0.0_DP ! 
    real(DP):: day_seconds = DAY_SECONDS_EARTH  ! 1 ÿ
    character(STRING) :: zone = '+00:00' ! UTC λ
  end type DC_DATETIME

  type DC_DIFFTIME
    ! X , X , ʤɤɽ뤿ΥǡǤ.
    !
    ! ι¤ǡѿѤݤɬѿ
    ! dc_date#Create ޤ dc_date#assignment(=)
    ! ˤäƽƤ. ޤ, *day*, *sec* ʤɤѿ
    ! ľѹʤǤ.
    !
    ! ˡ dc_date  "List"  "Usage" 򻲾ȤƤ.
    !
    ! ʤ, 1  dc_date_types#CYCLIC_MDAYS ȴޤ.
    !
    !--
    !== ȯԸ
    !
    ! 1פȤǰб뤿ᡢmonth ޤ
    !
    ! : դȰäƷ normalize 뤳ȤϤǤޤ
    !++
    sequence
    integer :: mon = 0      ! 
    integer :: day = 0      ! 
    real(DP):: sec = 0.0_DP ! 
    real(DP):: day_seconds = DAY_SECONDS_EARTH  ! 1 ÿ
  end type DC_DIFFTIME

end module dc_date_types
