!== dc_date_types#DC_DATETIME, dc_date_types#DC_DIFFTIME ѿʸѴ
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dcdatetimetochar.f90,v 1.4 2006/12/25 14:28:35 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20070305 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006-. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! Υե󶡤³ dc_date ⥸塼ˤ󶡤ޤ
!

function DCDateTimeToChar(time) result(result)
  !
  ! dc_date_types#DC_DATETIME ѿʸѿѴ֤ޤ.
  ! 񼰤ϲΤ褦 JIS X 0301 δɽǤ.
  !
  !   YYYY-MM-DDThh:mm:ss.sTZD
  !
  ! YYYY ǯ, MM Ϸ, DD , hh ϻ, mm ʬ, ss.s ,
  ! TZD ϥॾɽޤ.
  !
  use dc_types, only: STRING, TOKEN, DP
  use dc_string, only: toChar, CPrintf, StoA
  use dc_date, only: Eval
  use dc_date_types, only: DC_DATETIME, &
    & MIN_SECONDS, HOUR_SECONDS, YEAR_MONTHS
  use dc_message, only: MessageNotify
  implicit none
  character(STRING):: result
  type(DC_DATETIME), intent(in):: time

  integer :: year, mon, day, hour, min, csec_len
  real(DP):: sec
  character(TOKEN) :: zone, csec
continue

  call Eval(time, &
    & year=year, mon=mon, day=day, hour=hour, min=min, sec=sec, zone=zone)

  csec = toChar(sec)
  if (int(sec) > -1 .and. int(sec) < 10)  csec = '0' // csec
  csec_len = len(trim(adjustl(csec)))
  if (csec(csec_len:csec_len) == '.') csec = csec(1:csec_len-1)

  result = CPrintf('%04d-%02d-%02dT%02d:%02d:%c%c', &
    & i=(/year, mon, day, hour, min/), &
    & c1=trim(csec), c2=trim(zone))

end function DCDateTimeToChar


function DCDiffTimeToChar(diff) result(result)
  !
  ! dc_date_types#DC_DIFFTIME ѿʸѿѴ֤ޤ.
  ! 񼰤ϰʲΤ褦ˤʤޤ.
  !
  !   YYYY-MM-DDThh:mm:ss.s
  !
  ! YYYY ǯ, MM Ϸ, DD , hh ϻ, mm ʬ, ss.s äɽޤ.
  ! , DD  2 Ķ礬ޤ.
  ! (dc_date_types#DC_DIFFTIME  X , X , ʤɤɽ뤿
  ! ΥǡʤΤ, ˷夲, ˷겼뤳Ȥ
  ! ޤ. ޤǯפξޤ. 1 ǯ 1 
  ! dc_date_types#DC_DATETIME ¦Ƿޤޤ).
  !
  use dc_types, only: STRING, TOKEN, DP
  use dc_string, only: toChar, CPrintf, StoA
  use dc_date, only: Eval
  use dc_date_types, only: DC_DIFFTIME
  implicit none
  character(STRING):: result
  type(DC_DIFFTIME), intent(in):: diff

  integer :: year, mon, day, hour, min, csec_len
  real(DP):: sec
  character(TOKEN) :: csec
continue

  call Eval(diff, year=year, mon=mon, day=day, hour=hour, min=min, sec=sec)

  csec = toChar(sec)
  if (int(sec) > -1 .and. int(sec) < 10)  csec = '0' // csec
  csec_len = len(trim(adjustl(csec)))
  if (csec(csec_len:csec_len) == '.') csec = csec(1:csec_len-1)

  result = CPrintf('%04d-%02d-%02dT%02d:%02d:%c', &
    & i=(/year, mon, day, hour, min/), &
    & c1=trim(csec))

end function DCDiffTimeToChar
