# -*- coding: japanese-cp932 -*-
require "numru/gfdnavi_data/knowledge"
require "forwardable"

module NumRu::GfdnaviData
  class KnowledgeLocal < NumRu::GfdnaviData::Knowledge
    extend Forwardable

    OBJECT_CLASS = ::Knowledge

    # * 唼̃\bh Knowledge IuWFNgɈڏ
    #   (models/knowledge.rb ̓̃\bhƓ悤ɂ)
    #
    #if Node.table_exists? && OBJECT_CLASS.table_exists?
    #meths = Node.column_names.dup + OBJECT_CLASS.column_names.dup
    if OBJECT_CLASS.table_exists?
      meths = OBJECT_CLASS.column_names.dup
      meths.delete("id")
      meths.collect!{|me| /\A(.+)_id\z/ =~ me ? $1 : me} # ...._id  _id 
      meths += ["get_contents", "relational_images", "relational_variables", "figures", "insert_figures", "swap_figures", "comments", "make_new_comment", "save", "delete", "delete_figure"]
      # figures=  Local ̂݁BRemote  add_figure gB
      meths.each do |me|
        def_delegator :@object, me
        def_delegator :@object, me+"="
      end
    end

    def errors
      @object.errors.full_messages
    end

    def to_knlge
      # typẽ`FbNKv
      path = @object.path
      if /\A\/usr(\/.*)\Z/ =~ path
        path = GFDNAVI_USER_PATH + $1
      else
        path = GFDNAVI_DATA_PATH + path
      end
      knowledge_file = File.open(path)
      knowledge_yml = knowledge_file.read
      knowledge_hash = YAML.load(knowledge_yml)
      return knowledge_hash
    end

    def initialize(hash={})
      # hash̒gȂAł
      super(hash) # ͕K{

      #  {} ȂVK쐬
      # (pXw肹ɒPKnowledgeIuWFNg쐬邾A
      # @\ƂĂ͎͌)ƂɂApX͍̏sȂB
      unless hash=={}
        # === pX̏
        # * Local:
        #    * X[p[[Ȕꍇ
               #K΃pXƂ݂Ȃ(ǂɂłt@Cu)
        #    * ʃ[Ȕꍇ
        #      "/usr/" + user_name + "/knowledge/" + @path ̌`
        #      ȂĂȂΑ΃pXƂ݂Ȃ(/knowledge/ȉɂt@CuȂ)
        #    * [UwȂ̏ꍇ
        #      ʃ[UɓB
        # * Remote: 
        #      http:// ͂܂̂ŁApXȗ邱Ƃ͂Ȃ
        path = @object.path
        if @user
          unless @user.super_user
            unless /^\/usr\/(.*)\/knowledge\/.*/ =~ path
              path = "/usr/" + user_name + "/knowledge/" + path
            end
          end
        end
        @object.path = path
        @object.owner = @user
      end
    end
  end
end

