!----------------------------------------------------------------------
!     Copyright (c) 2012--2013 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_base_mpi_module_sjpack
!
!  spml/wa_base_mpi_module_sjpack ⥸塼ϵ̾Ǥήαư
!  ĴȡѤڥȥˡ MPI 󲽤ˤä
!  ͷ׻뤿 ⥸塼 wa_mpi_module_sjpack β⥸塼Ǥ, 
!  ڥȥ׻δŪ Fortran90 ؿ󶡤. 
!
!  ̾ 1 إǥ w_base_mpi_module_sjpack ⥸塼¿إǥѤ
!  ĥΤǤ, ƱʣĤΥڥȥǡ, ʻǡ
!  ФѴԤ.
!
!   ISPACK  SJPACK-MPI  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SJPACK-MPI Υޥ˥奢򻲾Ȥ줿.
!
!
!  2012/03/31  ݹ  wa_base_mpi_module.f90  sjpack 
!      2013/02/13  ݹ  wa_StreamPotential2VectorMPI,  
!                            wa_Vector2VorDivMPI Ƴ
!      2013/02/15  ݹ  wa_VectorCosLat2VorDivMPI Ƴ
!      2013/02/23  ݹ  wa_base_mpi_Finalize Ƴ
!
module wa_base_mpi_module_sjpack
  !
  ! wa_base_mpi_module_sjpack
  !
  !  spml/wa_base_mpi_module_sjpack ⥸塼ϵ̾Ǥήαư
  !  ĴȡѤڥȥˡ MPI 󲽤ˤä
  !  ͷ׻뤿 ⥸塼 wa_mpi_module_sjpack β⥸塼Ǥ, 
  !  ڥȥ׻δŪ Fortran90 ؿ󶡤. 
  !
  !  ̾ 1 إǥ w_base_mpi_module_sjpack ⥸塼¿إǥѤ
  !  ĥΤǤ, ƱʣĤΥڥȥǡ, ʻǡ
  !  ФѴԤ.
  !
  !   ISPACK  SJPACK-MPI  Fortran77 ֥롼ƤǤ. 
  !  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  !  ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
  !
  !
  use dc_message
  use w_base_module_sjpack, only : im, nm=>nn
  use w_base_mpi_module_sjpack, only : jc, w_xv, xv_w, &
                                       w_StreamPotential2VectorMPI, &
                                       w_Vector2VorDivMPI,          &
                                       w_VectorCosLat2VorDivMPI

  implicit none

  private
  private im, nm                               ! Intel Fortran к

  public wa_base_mpi_Initial                   ! ֥롼
  public wa_base_mpi_Finalize                  ! λ

  public xva_wa, wa_xva                        ! Ѵؿ
  public wa_StreamPotential2VectorMPI          ! ήݥƥ󥷥뤫®پ׻
  public wa_Vector2VorDivMPI                   ! ®پ줫鱲ȯ׻
  public wa_VectorCosLat2VorDivMPI             ! ®پ줫鱲ȯ׻

  contains
  !---------------  -----------------
    subroutine wa_base_mpi_initial
      ! 
      ! SNPACK  wa_base_mpi_initial θߴΤΥߡ֥롼
      !
      call MessageNotify('M','wa_base_mpi_initial',&
                         'wa_base_mpi_module_sjpack is initialized (dummy, 2013/02/23)')

    end subroutine wa_base_mpi_initial

  !--------------- Ѵ -----------------

    function xva_wa(wa_data,ipow,iflag)    ! Ĵ´ؿڥȥ -> ʻ
      !
      ! ڥȥǡʻҥǡѴ(¿).
      !
      real(8), intent(in)   :: wa_data(:,:)
      !(in) ڥȥǡ

      real(8)               :: xva_wa(im,jc,size(wa_data,2))
      !(out) ʻǡ

      integer, intent(in), optional  :: ipow
      !(in) Ѥ 1/cos μ. ά 0. 

      integer, intent(in), optional  :: iflag
      !(in) Ѵμ
      !     0 : ̾Ѵ
      !     1 : ʬѤѴ
      !    -1 : ʬѤѴ
      !     2 : sinդѤѴ
      !     ά 0.
      !

      integer, parameter  :: ipow_default  = 0
      integer, parameter  :: iflag_default = 0

      integer ipval, ifval
      integer k

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      do k=1,size(wa_data,2)
        xva_wa(:,:,k) = xv_w(wa_data(:,k),iflag=ifval,ipow=ipval)
      enddo

    end function xva_wa

    function wa_xva(xva_data,ipow,iflag) ! ʻ -> Ĵ´ؿڥȥ
      !
      ! ʻҥǡ饹ڥȥǡ()Ѵ(¿).
      !
      real(8), intent(in)   :: xva_data(:,:,:)
      !(in) ʻǡ(im,jm,*)

      real(8)               :: wa_xva((nm+1)*(nm+1),size(xva_data,3))
      !(out) ڥȥǡ

      integer, intent(in), optional  :: ipow
      !(in) ѴƱ˺Ѥ 1/cos μ. ά 0.

      integer, intent(in), optional  :: iflag
      ! Ѵμ
      !     0 : ̾Ѵ
      !     1 : ʬѤѴ
      !    -1 : ʬѤѴ
      !     2 : sinդѤѴ
      !   ά 0.

      integer, parameter  :: ipow_default  = 0      ! åǥե
      integer, parameter  :: iflag_default = 0      ! åǥե

      integer ipval, ifval
      integer k

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      do k=1,size(xva_data,3)
         wa_xva(:,k) = w_xv(xva_data(:,:,k),iflag=ifval,ipow=ipval)
      enddo

    end function wa_xva

  !----------- ®, ١ȯ, ήݥƥ󥷥׻ -------------

    subroutine wa_StreamPotential2VectorMPI(wa_Psi, wa_Chi, xva_U, xva_V)
      !
      ! ήݥƥ󥷥(ڥȥǡ)®پ(ʻҥǡ)
      ! ()Ѵ(¿)
      !
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !   u cos =      ߦ/ߦ - cosբߦ/ߦ, 
      !   v cos = cosբߦ/ߦ +      ߦ/ߦ 
      !
      real(8), intent(in)   :: wa_Psi(:,:)
      !(in) ήؿ((nm+1)*(nm+1),:)

      real(8), intent(in)   :: wa_Chi(:,:)
      !(in) ®٥ݥƥ󥷥((nm+1)*(nm+1),:)

      real(8), intent(out)   :: xva_U(0:im-1,1:jc,size(wa_Psi,2))
      !(out) ®ٷʬ(0:im-1,1:jc,:)

      real(8), intent(out)   :: xva_V(0:im-1,1:jc,size(wa_Psi,2))
      !(out) ®ٰʬ(0:im-1,1:jc,:)

      integer :: k

      do k=1,size(wa_Psi,2)
         call w_StreamPotential2VectorMPI &
              ( wa_Psi(:,k), wa_Chi(:,k), xva_U(:,:,k), xva_V(:,:,k) )
      enddo

    end subroutine wa_StreamPotential2VectorMPI

    subroutine wa_Vector2VorDivMPI(xva_U, xva_V, wa_Vor, wa_Div)
      !
      ! ®پ(ʻҥǡ)鱲١ȯ(ڥȥǡ)
      ! ()Ѵ(¿)
      ! 
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      real(8), intent(in)   :: xva_U(0:,:,:)
      !(in) ®ٷʬ(0:im-1,1:jm,:)

      real(8), intent(in)   :: xva_V(0:,:,:)
      !(in) ®ٰʬ(0:im-1,1:jm,:)

      real(8), intent(out)   :: wa_Vor((nm+1)*(nm+1),size(xva_U,3))
      !(out) ήؿ
      real(8), intent(out)   :: wa_Div((nm+1)*(nm+1),size(xva_U,3))
      !(out) ®٥ݥƥ󥷥

      integer :: k

      do k=1,size(xva_U,3)
         call w_Vector2VorDivMPI &
               (xva_U(:,:,k), xva_V(:,:,k), wa_Vor(:,k), wa_Div(:,k))
      enddo
    end subroutine wa_Vector2VorDivMPI

    subroutine wa_VectorCosLat2VorDivMPI(xva_UCosLat, xva_VCosLat, wa_Vor, wa_Div)
      !
      ! ®پ(ʻҥǡ)鱲١ȯ(ڥȥǡ)
      ! ()Ѵ(¿)
      ! 
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      real(8), intent(in)   :: xva_UCosLat(0:,:,:)
      !(in) ®ٷʬ * cos(lat) (0:im-1,1:jm,:)

      real(8), intent(in)   :: xva_VCosLat(0:,:,:)
      !(in) ®ٰʬ * cos(lat) (0:im-1,1:jm,:)

      real(8), intent(out)   :: wa_Vor((nm+1)*(nm+1),size(xva_UCosLat,3))
      !(out) ήؿ
      real(8), intent(out)   :: wa_Div((nm+1)*(nm+1),size(xva_UCosLat,3))
      !(out) ®٥ݥƥ󥷥

      integer :: k

      do k=1,size(xva_UCosLat,3)
         call w_VectorCosLat2VorDivMPI &
               ( xva_UCosLat(:,:,k), xva_VCosLat(:,:,k), &
                 wa_Vor(:,k), wa_Div(:,k) )
      enddo
    end subroutine wa_VectorCosLat2VorDivMPI

  !--------------- λ -----------------
    subroutine wa_base_mpi_Finalize
      ! 
      ! ⥸塼νλ(դβ)򤪤ʤ. 
      !
      ! Υ֥롼ñȤѤΤǤʤ, 
      ! ̥֥롼 wa_mpi_Finalize Ѥ뤳.
      !
      call MessageNotify('M','wa_base_mpi_finalize',&
           'wa_base_mpi_module_sjpack is finalized (dummy, 2013/02/23)')

    end subroutine wa_base_mpi_Finalize

end module wa_base_mpi_module_sjpack
