# RFC-822-like file reading/writing module
# $Id: rfc822.pl,v 1.3 1999/05/18 12:47:51 toyoda Exp $
# Copyright (c) TOYODA Eizi, 1998.  All rights reserved.
# see COPYING.TXT for terms of license.

sub emlOpenFile {
	local($file) = @_;
	&open_r($file) || &die("cannot open <$file>");
	&emlSetFile($file);
}

sub emlSetFile {
	($emlFile) = @_;
}

sub emlReadLine {
	&readline($emlFile);
}

# -- emlRead() ---
#
# Reads RFC 822 headers from $inputfile and returns hash with which
# $returned_hash{$field_name} == $filed_value,
# where $field_name is lowercased and colon-containing filed name.
# If $field_value contains '\n', it means that the header
# $field_name appeared more than once.
# Undefined return value means there is a format error.

sub emlRead {
	local(%headers) = ();
	local($name, $val) = ("", "");

	while ($_ = &emlReadLine) {
		s/\r?\n$//;
		last if /^$/;
		if (!/^\s/) {
			next if /^From /;
			if (!/^([-A-Za-z0-9]*:)\s*(.*)/) {
				&warn("broken header <$_> in $emlFile");
				return undef;
			}
			($name = $1) =~ tr/A-Z/a-z/;
			($val = $2) =~ s/[\t\r]/ /g;
			if (defined $headers{$name}) {
				$headers{$name} .= "\n$val";
			} else {
				$headers{$name} = $val;
			}
		} else {
			s/[\t\r]/ /g;
			s/^ */ /;
			$headers{$name} .= $_;
		}
	}
	%headers;
}

sub emlWrite {
	local($outfnam, %headers) = @_;
	local($fieldname, @values, $value);

	foreach $fieldname (keys %headers) {
		local(@values) = split(/\n/, $headers{$fieldname});
		foreach $value (@values) {
			print $outfnam "$fieldname $value\n";
		}
	}
}

