#include	<stdio.h>
#include	"defs.h"
#include	"rastfont.h"
#include	"pkfont.h"

struct rastinitfontinfo pkifi;
struct font_entry pkfe;

BOOLEAN mirror[MAXCHAR+1];

main(ac, av)
int ac;
char *av[];
{
    int i;
    FILE *gf;

    for (i = 0; i <= MAXCHAR; i++)
	pkifi.mark[i] = FALSE;
    pkifi.maxc = MAXCHAR;
    rastinifinfo((&pkfe)) = &pkifi;
    read_vchar(av[1]);
    strcpy(pkfe.name, av[2]);
    read_pk_fontinfo(&pkfe, FALSE);

    if ((gf = fopen(av[3], "w")) == NULL) {
	fprintf(stderr, "cannot write %s\n", av[3]);
	exit(1);
    }
    gfpre(gf);
    gfchars(gf, &pkfe);
    gfpost(gf, pkfe.d, pkfe.c, rastfinfo(&pkfe)->vppp, rastfinfo(&pkfe)->hppp);

    exit(0);
}

#define	LEN	256

read_vchar(fn)
char *fn;
{
    FILE *cf;
    char buf[LEN], *p;
    int i;
    int f, c;

    if ((cf = fopen(fn, "r")) == NULL) {
	fprintf(stderr, "cannot read %s\n", fn);
	exit(1);
    }
    for (i = 0; i <= MAXCHAR; i++)
	mirror[i] = FALSE;
    for (; fgets(buf, LEN, cf) != NULL; ) {
	compute_fc((buf[0]&0x7f)-0x20, (buf[1]&0x7f)-0x20, &f, &c);
	if (f != 1) {
	    fprintf(stderr, "%c%c is not a symbol\n", buf[0], buf[1]);
	    continue;
	}
	if (c > MAXCHAR) {
	    fprintf(stderr, "%c%c out of range\n", buf[0], buf[1]);
	    continue;
	}
	pkifi.mark[c] = TRUE;
	if (strlen(buf) > 4)
	    mirror[c] = TRUE;
    }
}

gfchars(gf, fe)
FILE *gf;
struct font_entry *fe;
{
    struct rastfntinfo *rfi;
    struct rastchar_entry *ce;
    int i;

    rfi = rastfinfo(fe);
    init_rotbm();
    for (i = 0, ce = rfi->ch; i < rfi->nfntchars; i++, ce++)
	if (ce->where.pixptr != NULL)
	    rotgfchar(gf, i, ce);
}

rotgfchar(gf, cc, ce)
FILE *gf;
int cc;
struct rastchar_entry *ce;
{
    extern byte *rotbm;
    extern int rbm_width, rbm_bwid, rbm_height;

    rotate((byte *)(ce->bitmap), ce->width, ce->nbpl, ce->height, mirror[cc]);
    gfchar(gf, cc, 0, 0, rotbm,
	   -(ce->height-ce->yoffset), rbm_width, rbm_bwid,
	   ce->xoffset, rbm_height);
}
